<?php
/**
 * ------------------------------------------------------------------------
 * JA Alpha Template
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2018 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - Copyrighted Commercial Software
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites:  http://www.joomlart.com -  http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Component\Content\Site\Helper\RouteHelper;


$input = Factory::getApplication()->input;
$option = $input->get('option');
$view = $input->get('view');
$id = $input->get('id');

?>
<?php foreach ($list as $item) :
	if (version_compare(JVERSION, '4.0', '<')){
		$url_ = ContentHelperRoute::getCategoryRoute($item->id);
	}else{
		$url_ = RouteHelper::getCategoryRoute($params->get('parent', 'root'));
	}

    $class = '';
    if ($option === 'com_content' && $view === 'category' && $id == $item->id) {
        $class = 'active';
    }
  ?>
  <li class="<?php echo $class ?>">
    <a class="heading-link" href="<?php echo Route::_($url_); ?>">
      <?php echo $item->title; ?>
    </a>
    <?php
    if ($params->get('show_description', 0)) {
      echo HTMLHelper::_('content.prepare', $item->description, $item->getParams(), 'mod_articles_categories.content');
    }
    if ($params->get('show_children', 0) && (($params->get('maxlevel', 0) == 0) || ($params->get('maxlevel') >= ($item->level - $startLevel))) && count($item->getChildren())) {
      echo '<ul>';
      $temp = $list;
      $list = $item->getChildren();
      require ModuleHelper::getLayoutPath('mod_articles_categories', $params->get('layout', 'default') . '_items');
      $list = $temp;
      echo '</ul>';
    }
    ?>
  </li>
<?php endforeach; ?>