<?php
/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

if (version_compare(JVERSION, '4.0', '<')){
	$url_ = ContentHelperRoute::getCategoryRoute($displayData['item']->catid);
}else{
	$url_ = RouteHelper::getCategoryRoute($displayData['item']->catid);
}
?>
<div class="category-name">
	<?php $title = $this->escape($displayData['item']->category_title); ?>
	<?php if ($displayData['params']->get('link_category') && $displayData['item']->catid) : ?>
		<?php $url = '<a href="' . Route::_($url_) . '" itemprop="genre">' . $title . '</a>'; ?>
		<?php echo $url; ?>
	<?php else : ?>
		<?php echo Text::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
	<?php endif; ?>
</div>