<?php
/**
 * @Securitycheckpro_update_database plugin
 * @copyright Copyright (c) 2011 - Jose A. Luque / Securitycheck Extensions
 * @license   GNU General Public License version 3, or later
 */
 
namespace Joomla\Plugin\System\Securitycheckpro_update_database\Extension;

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\Model\DatabaseupdatesModel;

class Securitycheckpro_update_database extends CMSPlugin{

// Variable que contendr el tipo de componente de securitycheck instalado 
private $securitycheck_type = 'Not_defined';
// Variable que almacena la tabla en la que insertar las nuevas vulnerabilidades
private $vuln_table = 'Not_defined';

/* Chequea qu tipo de componente de securitycheck est instalado */
function check_securitycheck_type() {

	$db = Factory::getDbo();
	
	// Consultamos si est instalada la versin Pro
	$query = $db->getQuery(true)
		->select('COUNT(*)')
		->from($db->quoteName('#__extensions'))
		->where($db->quoteName('name').' = '.$db->quote('System - Securitycheck pro'));
	$db->setQuery($query);
	$result = $db->loadResult();
	
	// La extensin Pro est instalada; actualizamos la variable $securitycheck_type y $table
	if ( !(empty($result)) && ($result == '1') ) {
		$this->securitycheck_type = 'com_securitycheckpro';
		$this->vuln_table = '#__securitycheckpro_db';
	} else {
		
		// Consultamos si est instalada la versin free
		$query = $db->getQuery(true)
			->select('COUNT(*)')
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('name').' = '.$db->quote('System - Securitycheck'));
		$db->setQuery($query);
		$result = $db->loadResult();
		
		// La extensin free est instalada; actualizamos la variable $securitycheck_type y $table
		if ( !(empty($result)) && ($result == '1') ) {
			$this->securitycheck_type = 'com_securitycheck';
			$this->vuln_table = '#__securitycheck_db';
		}	
	}	
}

function onUserLogin(){
	
	// Chequeamos el tipo de componente instalado
	$this->check_securitycheck_type();	
		
	// Segn el tipo de instalacin, la ubicacin de la librera vara
	if ( $this->securitycheck_type == 'com_securitycheckpro' ) {
		$update_model = new DatabaseupdatesModel();
	
	} else if ( $this->securitycheck_type == 'com_securitycheck' ) {
		JLoader::import('databaseupdates', JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR. 'com_securitycheck' . DIRECTORY_SEPARATOR . 'helpers');
		$update_model = BaseDatabaseModel::getInstance( 'databaseupdates', 'SecuritychecksModel');
	} else {
		// Si no hay ningn componente instalado terminamos el script
		return;
	}	
		
	// Comprobamos si existen nuevas actualizaciones
	$update_model->check_for_updates();
			
}

}