<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SYW\Component\WeblinkLogosPro\Site\Helper\Helper;
use SYW\Library\Libraries as SYWLibraries;
use SYW\Library\Utilities as SYWUtilities;
use SYW\Library\Version as SYWVersion;

/** @var \SYW\Component\WeblinkLogosPro\Site\View\Directory\HtmlView $this */

if ($this->load_bootstrap) {
	HTMLHelper::_('bootstrap.framework');
	HTMLHelper::_('bootstrap.tooltip', '.hasTooltip');
}

if ($this->show_pagination) {
    if ($this->params->get('load_chosen_script', 0)) {
        HTMLHelper::_('formbehavior.chosen', 'select');
    }
}

$modal_needed = false;

if ($this->show_heading) {
    $previous_heading = '';
    $heading = '';
}

if ($this->remove_whitespaces) {
	ob_start(function($buffer) { return preg_replace('/\s+/', ' ', $buffer); });
}
?>
<div class="wlp_directory<?php echo $this->pageclass_sfx ? ' '.$this->pageclass_sfx : ''; ?><?php echo $this->isMobile ? ' mobile' : ''; ?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if ($this->show_print) : ?>
		<?php
            $layout = new FileLayout('content.wlpicons');
            $data = array('view' => 'directory', 'style' => $this->actions_style, 'classes' => $this->actions_classes, 'print' => $this->print, 'show_print' => $this->show_print);
            $data['category'] = $this->category_request;
            $data['tag'] = $this->tag_request;
            $data['index_fields'] = $this->field_index_array;
            $data['search'] = $this->search_request;
            $data['match'] = $this->search_options_request;
			$data['limitstart'] = $this->limitstart_request;
			$data['bootstrap_version'] = $this->bootstrap_version;
			$data['load_bootstrap'] = $this->load_bootstrap;
			echo $layout->render($data);
		?>
	<?php endif; ?>

	<?php if (trim($this->article_before_text)) : ?>
		<div class="pretext">
			<?php echo $this->article_before_text; ?>
		</div>
	<?php endif; ?>

	<form action="<?php echo Route::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">

		<input type="hidden" name="option" value="com_weblinklogospro">
		<input type="hidden" name="view" value="directory">
		<input type="hidden" name="category" value="<?php echo $this->category_request_value; ?>" />
		<input type="hidden" name="tag" value="<?php echo $this->tag_request_value; ?>" />
		<?php foreach ($this->field_index_array as $field_index) : ?>
			<?php $field_request_value = 'field_' . $field_index . '_value'; ?>
			<input type="hidden" name="field_<?php echo $field_index; ?>" value="<?php echo $this->$field_request_value; ?>" />
		<?php endforeach; ?>
		<input type="hidden" name="limitstart" value="<?php echo $this->limitstart_request_value; ?>" />
		<?php echo HTMLHelper::_('form.token'); ?>

		<?php if (($this->show_pagination || $this->show_search) && !$this->print) : ?>
			<div class="pagination_wrapper top">
				<?php if ($this->show_search || $this->pagination_top_index[0] || $this->pagination_top_index[1] || $this->pagination_bot_index[0] || $this->pagination_bot_index[1]) : ?>
					<?php
						$layout = new FileLayout('pagination.wlpsearch');
            			$data = array('tag' => $this->tag_request, 'category' => $this->category_request);
            			$data['index_fields'] = $this->field_index_array;
            			$data['search'] = $this->search_request;
            			$data['match'] = $this->search_options_request;
            			$data['show_search'] = $this->show_search;
            			$data['show_search_options'] = $this->show_search_options;
            			$data['search_value'] = $this->escape($this->get('state')->get('filter-search'));
            			$data['match_value'] = $this->escape($this->get('state')->get('filter-match'));
            			$data['match_default'] = $this->params->get('search_default', 'any');
            			$data['bootstrap_version'] = $this->bootstrap_version;
            			$data['load_bootstrap'] = $this->load_bootstrap;
            			echo $layout->render($data);
            		?>
				<?php endif; ?>

				<?php if ($this->show_pagination) : ?>
					<?php if ($this->show_pagination_limit) : ?>
    					<?php
	            			$layout = new FileLayout('pagination.wlpdisplay');
	            			$data = array('options' => $this->limits, 'selected' => $this->state->get('list.limit'));
	            			$data['bootstrap_version'] = $this->bootstrap_version;
	            			$data['load_bootstrap'] = $this->load_bootstrap;
	            			echo $layout->render($data);
	            		?>
					<?php endif; ?>

					<?php foreach ($this->pagination_top_index as $index) : ?>
						<?php if ($index) : ?><!-- because of backward compatibility -->
							<div class="<?php echo $this->pagination_class[$index] ?>">
								<?php $this->pagination_data[$index]['suffix'] = 'top'; ?>
								<?php echo $this->pagination_layouts[$index]->render($this->pagination_data[$index]); ?>
							</div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php if (!empty($this->items)) : ?>
			<ul class="weblink_items <?php echo $this->configuration; ?>">
				<?php foreach ($this->items as $i => $item) : ?>
					<?php
                        if ($this->show_heading) {
                            $heading = $item->category_title;
                            if ($heading != $previous_heading) {
                                $previous_heading = $item->category_title;
                            } else {
                                $heading = '';
                            }
                        }

                        $canEdit = $this->user->authorise('core.edit', 'com_weblinklogospro');
                        if (!$canEdit && $this->user->authorise('core.edit.own', 'com_weblinklogospro')) {
                            $canEdit = $this->user->id == $item->created_by;
                        }

                        $edit_addition = '';
                        if ($canEdit && !$this->print) {
                            if ($item->checked_out > 0 && $item->checked_out != $this->user->get('id')) {
                                $checkoutUser = Factory::getUser($item->checked_out);
                                $edit_addition = '<span class="weblink_checked_out hasTooltip" title="'.Text::sprintf('COM_WEBLINKLOGOSPRO_CHECKED_OUT_BY', $checkoutUser->name).'" aria-label="'.Text::sprintf('COM_WEBLINKLOGOSPRO_CHECKED_OUT_BY', $checkoutUser->name).'"><i class="SYWicon-lock" aria-hidden="true"></i></span>';
                            } else {
                                $edit_url = 'index.php?option=com_weblinklogospro&task=weblink.edit&id=' . $item->id . '&return=' . base64_encode(Uri::getInstance());
                                $edit_addition = '<a href="'.$edit_url.'" class="weblink_edit hasTooltip" title="'.Text::_('JGLOBAL_EDIT').'" aria-label="'.Text::_('JGLOBAL_EDIT').'"><i class="SYWicon-create" aria-hidden="true"></i></a>';
                            }
                        }

						$imagetag = '';
						$identical = false;

						if (empty($item->image_first)) {
							$item->error[] = Text::sprintf('COM_WEBLINKLOGOSPRO_ERROR_IMAGEFILEDOESNOTEXIST', '');
						} else {
						    $result_array = Helper::getThumbnailPath($this->unique_filename_extra, $item->id, $item->image_first, $this->tmp_path, $this->clear_cache, $this->width, $this->height, false, $this->image_qualities, $this->filter, $this->create_highres_images, $this->allow_remote, $this->thumbnail_mime_type);

							if (!empty($result_array[1])) {
								$item->error[] = $result_array[1];
							}

							if (!empty($result_array[0])) {

								$attributes = array('class' => 'original');

								$imagetag .= SYWUtilities::getImageElement($result_array[0], $item->alt_first, $attributes, true, $this->create_highres_images, null, true, SYWVersion::getMediaVersion('com_weblinklogospro_' . $this->extra_suffix));
							}

							if (!empty($item->image_second)) {
							    $additional_suffix = '';
							    if ($this->filter === $this->filter_hover) {
							        $additional_suffix = '_hover';
							    }
							    $result_array_hover = Helper::getThumbnailPath($this->unique_filename_extra, $item->id.$additional_suffix, $item->image_second, $this->tmp_path, $this->clear_cache, $this->width, $this->height, false, $this->image_qualities, $this->filter_hover, $this->create_highres_images, $this->allow_remote, $this->thumbnail_mime_type);
							} else {
								if ($this->filter === $this->filter_hover) { // thumbs will be identical
									$result_array_hover = $result_array;
									$identical = true;
								} else {
								    $result_array_hover = Helper::getThumbnailPath($this->unique_filename_extra, $item->id, $item->image_first, $this->tmp_path, $this->clear_cache, $this->width, $this->height, false, $this->image_qualities, $this->filter_hover, $this->create_highres_images, $this->allow_remote, $this->thumbnail_mime_type);
								}
							}

							if (!empty($result_array_hover[1]) && !$identical) {
								$item->error[] = $result_array_hover[1];
							}

							if (!empty($result_array_hover[0])) {

								$attributes = array('class' => 'hover');

								if ($this->params->get('logo_tooltip', 1)) {
									if ($this->bootstrap_version > 0) {
										$attributes['class'] .= ' hasTooltip';
									}
								    $attributes['title'] = htmlspecialchars($item->title);
								}

								$imagetag .= SYWUtilities::getImageElement($result_array_hover[0], $item->alt_first, $attributes, true, $this->create_highres_images, null, true, SYWVersion::getMediaVersion('com_weblinklogospro_' . $this->extra_suffix));
							}
						}
					?>

					<?php if ($this->show_heading && $heading) : ?>
						</ul>
						<div class="heading-group">
							<?php echo '<h'.$this->heading_html_tag.' class="heading">'; ?><?php echo $heading; ?><?php echo '</h'.$this->heading_html_tag.'>'; ?>
							<?php if ($this->show_heading_description || $this->show_heading_image) : ?>
								<div class="heading_description">
									<?php if ($this->show_heading_image) : ?>
										<img class="heading-image" src="<?php echo $this->categories_list[$item->catid]->image; ?>" alt="<?php echo htmlspecialchars($this->categories_list[$item->catid]->image_alt, ENT_COMPAT, 'UTF-8'); ?>" />
									<?php endif; ?>
									<?php if ($this->show_heading_description) : ?>
										<div class="heading-text"><?php echo $this->categories_list[$item->catid]->description; ?></div>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
						<ul class="weblink_items <?php echo $this->configuration; ?>">
					<?php endif; ?>

					<li class="weblink_item weblink_id_<?php echo $item->id; ?> weblink_catid_<?php echo $item->catid; ?>">

						<?php if ($this->show_errors && !empty($item->error)) : ?>
							<?php foreach ($item->error as $error) : ?>
			  					<?php Factory::getApplication()->enqueueMessage('id '.$item->id.': '.$error, 'error'); ?>
							<?php endforeach; ?>
						<?php else : ?>
							<div class="weblink_item_wrapper">
								<?php if ($edit_addition) : ?>
        							<div class="edition">
            							<?php echo $edit_addition; ?>
        							</div>
        						<?php endif; ?>
								<div class="logo">
									<div class="logo_link<?php echo ($identical && $this->hover_type == 'smooth') ? '' : ' '.$this->hover_type; ?>">
										<?php
											switch ($item->target)
											{
												case 1:	// open in a new window
													echo '<a href="'. $item->link .'" target="_blank" rel="'.$this->params->get('follow', 'nofollow').'">'.$imagetag.'</a>';
													break;
												case 2: // open in a popup window
												    echo '<a href="#" onclick="window.open(\''. $item->link .'\', \'\', \'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width='.$this->popup_width.',height='.$this->popup_height.'\'); return false">'.$imagetag.'</a>';
													break;
												case 3: // open in a modal window
												    $modal_needed = true;
												    $link_attributes = ' onclick="return false;" data-modaltitle="'.htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8').'"';
												    if ($this->bootstrap_version > 0) {
												    	$link_attributes .= ' data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="modal" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'target="#wlpmodal"';
												    }
												    echo '<a href="'.$item->link.'" class="wlpmodal"' . $link_attributes . '>'.$imagetag.'</a>';
													break;
												default: // open in parent window
													echo '<a href="'. $item->link .'" rel="'.$this->params->get('follow', 'nofollow').'">'.$imagetag.'</a>';
											}
										?>
									</div>
									<?php if ($this->params->get('caption', 0)) : ?>
										<div class="logo_caption<?php echo $this->caption_classes; ?>"><?php echo htmlspecialchars($item->caption_first, ENT_COMPAT, 'UTF-8'); ?></div>
									<?php endif; ?>
								</div>
								<?php if (($this->params->get('description', 0) && $item->description) || $this->params->get('title', 0) || $this->params->get('hits', 0)) : ?>
									<div class="description">
										<?php if ($this->params->get('title', 0)) : ?>
											<h<?php echo $this->title_html_tag; ?> class="title">
											<?php if ($this->params->get('link_title', 0)) : ?>
    											<?php
        											switch ($item->target)
        											{
        												case 1:	// open in a new window
        												    echo '<a href="'. $item->link .'" target="_blank" rel="'.$this->params->get('follow', 'nofollow').'">'.$item->title.'</a>';
        													break;
        												case 2: // open in a popup window
        												    echo '<a href="#" onclick="window.open(\''. $item->link .'\', \'\', \'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width='.$this->popup_width.',height='.$this->popup_height.'\'); return false">'.$item->title.'</a>';
        													break;
        												case 3: // open in a modal window
        													$modal_needed = true;
        													$link_attributes = ' onclick="return false;" data-modaltitle="'.htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8').'"';
        													if ($this->bootstrap_version > 0) {
        														$link_attributes .= ' data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="modal" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'target="#wlpmodal"';
        													}
        												    echo '<a href="'.$item->link.'" class="wlpmodal"' . $link_attributes . '>'.$item->title.'</a>';
        													break;
        												default: // open in parent window
        												    echo '<a href="'. $item->link .'" rel="'.$this->params->get('follow', 'nofollow').'">'.$item->title.'</a>';
        											}
        										?>
											<?php else : ?>
												<?php echo $item->title; ?>
											<?php endif; ?>
											</h<?php echo $this->title_html_tag; ?>>
										<?php endif; ?>
										<?php if ($this->params->get('hits', 0)) : ?>
											<span class="hits<?php echo $this->hits_classes; ?>"><?php echo Text::sprintf('COM_WEBLINKLOGOSPRO_HITS', $item->hits); ?></span>
										<?php endif; ?>
										<?php if (strlen($item->description) > 0) : ?>
											<?php if ($this->params->get('separator', '')) : ?><span><?php echo $this->params->get('separator', ''); ?></span><?php endif; ?>
											<?php if ($this->description_html_tag) : ?>
												<<?php echo $this->description_html_tag; ?> class="text"><?php echo $item->description; ?></<?php echo $this->description_html_tag; ?>>
											<?php else : ?>
												<?php echo $item->description; ?>
											<?php endif; ?>
										<?php endif; ?>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
		<?php if ($this->show_pagination) : ?>
			<div class="pagination_wrapper bottom">
				<?php if (!empty($this->items)) : ?>
					<div class="counterpagination<?php echo intval($this->bootstrap_version) == 2 ? ' pagination' : '' ?>">
						<?php if ($this->show_pagination_results) : ?>
							<p class="counter">
								<?php echo $this->pagination->getPagesCounter(); ?>
							</p>
						<?php endif; ?>
						<?php echo $this->pagination->getPagesLinks(); ?>
					</div>
				<?php endif; ?>

				<?php if ($this->show_pagination_results_total) : ?>
					<div class="countertotal<?php echo ($this->pagination->total == 0) ? ' norecord' : '' ?>">
						<?php echo $this->pagination->getResultsCounter(); ?>
					</div>
				<?php else : ?>
					<?php if (empty($this->items)) : ?>
						<div class="countertotal norecord">
							<?php echo Text::_('JLIB_HTML_NO_RECORDS_FOUND'); ?>
						</div>
					<?php endif; ?>
				<?php endif; ?>

				<?php if (!$this->print) : ?>
					<?php foreach ($this->pagination_bot_index as $index) : ?>
						<?php if ($index) : ?>
							<div class="<?php echo $this->pagination_class[$index] ?>">
								<?php $this->pagination_data[$index]['suffix'] = 'bot'; ?>
								<?php echo $this->pagination_layouts[$index]->render($this->pagination_data[$index]); ?>
							</div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		<?php else : ?>
			<?php if (empty($this->items)) : ?>
				<div class="pagination_wrapper bottom">
					<div class="countertotal norecord">
						<?php echo Text::_('JLIB_HTML_NO_RECORDS_FOUND'); ?>
					</div>
				</div>
			<?php endif; ?>
		<?php endif; ?>
	</form>

	<?php if (trim($this->params->get('footnote', ''))) : ?>
		<span class="weblinks_footnote"><?php echo $this->params->get('footnote', ''); ?></span>
	<?php endif; ?>

	<?php if (trim($this->article_after_text)) : ?>
		<div class="posttext">
			<?php echo $this->article_after_text; ?>
		</div>
	<?php endif; ?>
</div>

<?php
    if ($modal_needed) {
    	if ($this->bootstrap_version == 0) {
    		SYWLibraries::loadPureModal($this->load_remotely);
    	}

		$layout = new FileLayout('content.wlpmodal');

		$data = array('selector' => 'wlpmodal', 'width' => $this->popup_width, 'height' => $this->popup_height);
		$data['bootstrap_version'] = $this->bootstrap_version;
		$data['load_bootstrap'] = $this->load_bootstrap;

		echo $layout->render($data);
    }
?>

<?php if ($this->remove_whitespaces) : ?>
	<?php ob_get_flush(); ?>
<?php endif; ?>