<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;

/**
 * Weblink Logos Pro dosplay controller
 */
class DisplayController extends BaseController
{

	/**
	 * Construct
	 */
	public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
	{
		$input = Factory::getApplication()->input;

		parent::__construct($config, $factory, $app, $input);
	}

	/**
	 * Method to display a view
	 *
	 * {@inheritDoc}
	 * @see \Joomla\CMS\MVC\Controller\BaseController::display()
	 */
	public function display($cachable = false, $urlparams = false)
	{
	    $vName = $this->input->get('view', 'directory');
	    $this->input->set('view', $vName);
	    
	    if (Factory::getUser()->get('id')) {
	        $cachable = false;
	    }

		$safeurlparams = array(
		    'catid'=>'INT', // ok
		    'id'=>'INT', // ok

		    'category'=>'STRING', // ok
		    'tag'=>'STRING', // ok

		    'anchor'=>'STRING', // ok

		    'limit'=>'UINT', // ok
		    'limitstart'=>'UINT', // ok

		    'return'=>'BASE64', // ok return page after form submission

		    'filter_order'=>'CMD',
		    'filter_order_Dir'=>'CMD',
		    'filter-search'=>'STRING', // ok
		    'filter-match'=>'STRING', // ok

		    'print'=>'BOOLEAN', // ok
		    'lang'=>'CMD', // ok
		    'Itemid' => 'INT'); // ok makes sure that when cached, menu items are different from each other

		parent::display($cachable, $safeurlparams);

		return $this;
	}
}
