<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Cache;

defined('_JEXEC') or die;

use SYW\Library\HeaderFilesCache;

class WeblinksCSSFileCache extends HeaderFilesCache
{
	public function __construct($extension, $params = null)
	{
		parent::__construct($extension, $params);

		$this->extension = $extension;

		$variables = array();

		$prefix = '.wlp_weblinks form'; // use 'form' to isolate the module styles from the view
		$variables[] = 'prefix';
		
		$true_prefix = '.wlp_weblinks';
		$variables[] = 'true_prefix';

		// set all necessary parameters
		$this->params = compact($variables);
	}

	protected function getBuffer()
	{
		// get all necessary parameters
		extract($this->params);

		// 		if (function_exists('ob_gzhandler')) { // TODO not tested
		// 			ob_start('ob_gzhandler');
		// 		} else {
		ob_start();
		//		}

		// set the header
		//$this->sendHttpHeaders('css');

		include JPATH_ROOT . '/media/com_weblinklogospro/styles/weblinks/style.css.php';

		return $this->compress(ob_get_clean());
	}

}
