<?php
/**
 * @package   OSMap
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2007-2014 XMap - Joomla! Vargas - Guillermo Vargas. All rights reserved.
 * @copyright 2016-2024 Joomlashack.com. All rights reserved.
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSMap.
 *
 * OSMap is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSMap is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSMap.  If not, see <https://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die();

if ($this->debug) : ?>
    <div class="osmap-debug-sitemap">
        <h1><?php echo Text::_('COM_OSMAP_DEBUG_ALERT_TITLE'); ?></h1>
        <p><?php echo Text::_('COM_OSMAP_DEBUG_ALERT'); ?></p>
        <?php echo Text::_('COM_OSMAP_SITEMAP_ID'); ?>: <?php echo $this->sitemap->id; ?>
    </div>
<?php endif; ?>

<div class="osmap-items">
    <?php $this->sitemap->traverse([$this, 'registerNodeIntoList']); ?>
    <?php $this->renderSitemap(); ?>
</div>

<?php if ($this->debug) : ?>
    <div class="osmap-debug-items-count">
        <?php echo Text::_('COM_OSMAP_SITEMAP_ITEMS_COUNT'); ?>: <?php echo $this->generalCounter; ?>
    </div>
<?php endif; ?>
