<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Form\Field\GroupedlistField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

class FieldeditField extends GroupedlistField
{
    public $type = 'Fieldedit';

    static $core_fields = null;

    static function getCoreFields()
    {
        if (!isset(self::$core_fields)) {
            self::$core_fields = FieldsHelper::getFields('com_weblinks.weblink');
        }

        return self::$core_fields;
    }

    protected function getGroups()
    {
    	$groups = array();

    	$groups['-'] = array();

    	//$groups['-'][] = HTMLHelper::_('select.option', 'empty', Text::_('COM_WEBLINKLOGOSPRO_VALUE_EMPTY'), 'value', 'text', $disable=false);
        $groups['-'][] = HTMLHelper::_('select.option', 'section', Text::_('COM_WEBLINKLOGOSPRO_VALUE_SECTION'), 'value', 'text', $disable=false);

        // get Joomla! fields
        // test the fields folder first to avoid message warning that the component is missing
        if (Folder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '1')) {

            $fields = self::getCoreFields();

            // organize the fields according to their group

            $fieldsPerGroup = array(
                0 => array()
            );

            $groupTitles = array(
                0 => Text::_('COM_WEBLINKLOGOSPRO_VALUE_NOGROUPFIELD')
            );

            foreach ($fields as $field) {

                if (!array_key_exists($field->group_id, $fieldsPerGroup)) {
                    $fieldsPerGroup[$field->group_id] = array();
                    $groupTitles[$field->group_id] = $field->group_title;
                }

                $fieldsPerGroup[$field->group_id][] = $field;
            }

            // loop trough the groups

            foreach ($fieldsPerGroup as $group_id => $groupFields) {

                if (!$groupFields) {
                    continue;
                }

                $groups[$groupTitles[$group_id]] = array();

                foreach ($groupFields as $field) {
                    if ($group_id == 0) {
                    	$groups[$groupTitles[$group_id]][] = HTMLHelper::_('select.option', 'customfields_'.$field->name, $field->title, 'value', 'text', $disable = false);
                    } else {
                    	$groups[$groupTitles[$group_id]][] = HTMLHelper::_('select.option', $field->id, $field->title, 'value', 'text', $disable = true);
                    }
                }
            }
        }

        // Merge any additional options in the XML definition.
        $groups = array_merge(parent::getGroups(), $groups);

        return $groups;
    }

}
?>
