// Turn radios into btn-group
jQuery(function($) {
	/**
	 * Turn radios into btn-group
	 */
	var container = document.querySelectorAll('.btn-group');
	for (var i = 0; i < container.length; i++) {
		var labels = container[i].querySelectorAll('label');
		for (var j = 0; j < labels.length; j++) {
			labels[j].classList.add('btn');
			var inputValue = $('input[type=radio]', labels[j]).val();
			if ((j % 2) == 1 && inputValue !== '') {
				labels[j].classList.add('btn-outline-danger');
			} if ((j % 2) == 1 && inputValue === '') {
				labels[j].classList.add('btn-outline-primary');
			} else {
				labels[j].classList.add('btn-outline-success');
			}
		}
	}

	var btsGrouped = document.querySelectorAll('.btn-group input[checked=checked]');
	for (var i = 0, l = btsGrouped.length; l>i; i++) {
		var self   = btsGrouped[i],
		    attrId = self.id,
		    label = document.querySelector('label[for=' + attrId + ']');
		if (self.parentNode.parentNode.classList.contains('btn-group-reversed')) {
			if (self.value === 0) {
				label.classList.add('active');
				label.classList.add('btn');
				label.classList.add('btn-outline-success');
			} else {
				label.classList.add('active');
				label.classList.add('btn');
				label.classList.add('btn-outline-danger');
			}
		} else {
			if (self.value === 0) {
				label.classList.add('active');
				label.classList.add('btn');
				label.classList.add('btn-outline-danger');
			} else {
				if (self.value === '') {
					label.classList.add('active');
					label.classList.add('btn');
					label.classList.add('btn-outline-primary');
				} else {
					label.classList.add('active');
					label.classList.add('btn');
					label.classList.add('btn-outline-success');
				}
			}
		}
	}
	
	// Perform columns ordering
	$('a[data-ordering-form]').on('click', function(jqEvent){
		let orderingOrder = $(jqEvent.target).attr('data-ordering-order');
		let orderingDirection = $(jqEvent.target).attr('data-ordering-direction');
		let orderingTask = $(jqEvent.target).attr('data-ordering-task');
		Joomla.tableOrdering(orderingOrder, orderingDirection, orderingTask);
		return false;
	});
	
	// Add the optional confirmation message popup
	if(typeof(COM_GDPR_DELETEPERIOD_CONSENTS_CONFIRMATION) !== 'undefined') {
		$('#toolbar-delete').attr('confirm-message', COM_GDPR_DELETEPERIOD_CONSENTS_CONFIRMATION.replace('%d', gdprCookieConsentDays));
	}
	
	// Always ensure to reset the other switcher button
	$(document).on('click', "fieldset[data-bs-toggle=buttons] label.btn", function(jqEvent) {
		if(jqEvent.target.nodeName.toUpperCase() == 'INPUT' || $(jqEvent.target).attr('disabled')) {
			return true;
		}
		
		var label = $(jqEvent.target).addClass('active');
		var input = $('input[type=radio]', label);

		var otherLabel = label.parents('fieldset').find("label").not(label);
		if (otherLabel.hasClass('active')) {
			otherLabel.removeClass('active btn-success btn-danger btn-primary');
		}
	});

	// Override the default switcher button colors/class for multiple selection switcher buttons
	var multipleSwitchers = $("div.controls > fieldset > label:nth-child(3)");
	multipleSwitchers.each(function(index, elem){
		var parentContainer = $(elem).parent();
		$('label', parentContainer).removeClass('btn-outline-success btn-outline-danger')
		// We are not in the configuration view
		if($('label:first-child > input', parentContainer).val() == 0) {
			$('label', parentContainer).addClass('btn-outline-success');
			$('label:first-child', parentContainer).addClass('btn-outline-danger').removeClass('btn-outline-success');
		} else {
			$('label', parentContainer).addClass('btn-outline-success');
		}
	});
	
	// Ensure that only input labels with 'No' value will be dangered 
	var doubledSwitchers = $("div.controls > fieldset > label:nth-child(2)");
	doubledSwitchers.each(function(index, elem){
		var inputValue = $('input', elem).val();
		if(inputValue != 0 && inputValue != '' && inputValue != '') {
			$(elem).removeClass('btn-outline-danger').addClass('btn-outline-success');
		}
	});
	
	/**
	 * Enables bootstrap popover
	 */
	[].slice.call(document.querySelectorAll('#updatestatus label.hasPopover')).map(function (popoverEl) {
		return new bootstrap.Popover(popoverEl,{
			template : '<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
			trigger : 'hover',
			placement : 'right',
			html : true
		});
	});

	[].slice.call(document.querySelectorAll('label.hasPopover, button.hasPopover, div.hasPopover, span.hasPopover, img.hasPopover')).map(function (popoverEl) {
		return new bootstrap.Popover(popoverEl,{
			template : '<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
			trigger : 'hover',
			placement : 'top',
			html : true
		});
	});
	
	[].slice.call(document.querySelectorAll('thead a.hasPopover')).map(function (popoverEl) {
		return new bootstrap.Popover(popoverEl,{
			template : '<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
			trigger : 'hover',
			placement : 'top',
			html : true
		});
	});
	
	/**
	 * Enables bootstrap tooltip
	 */
	[].slice.call(document.querySelectorAll('label.hasTooltip, img.hasTooltip, a.hasTooltip, span.hasTooltip, a.hasTip, a.hasTip, *[rel=tooltip], a.page-link')).map(function (tooltipEl) {
		return new bootstrap.Tooltip(tooltipEl,{
			trigger : 'hover',
			placement : 'top',
			html : true
		});
	});
	
	/**
	 * Calendars
	 */
	if ($.datepicker) {
		$('input[data-role=calendar]').datepicker({
			dateFormat : 'yy-mm-dd',
			firstDay : 1
		}).prev('span').on('click', function() {
			$(this).datepicker('show');
		});
	}

	/**
	 * Remove empty ordering spans
	 */
	$('.order > span').filter(function() {
		var hasChild = !$('a', this).length;
		return hasChild;
	}).remove();
	// Recover the legacy save order button in async way on the next cycle
	setTimeout(function() {
		$('a.saveorder').removeAttr('onclick').removeAttr('style');
	}, 1);
	
	/**
	 * Remove custom select
	 */ 
	$('table.headerlist select').removeClass('form-select');
	
	// Open the window iframe including the URL to debug the redirects
	$('a.windowopen_iframe').on('click', function(jqEvent) {
		var targetLink = $(this).attr('href');
		window.open(targetLink, '_blank', 'width=1280, height=800, left=100, top=100, location=1, scrollbars=1')
		return false;
	});

	// Remove configuration spacer empty div
	$('span.spacer').parent('div.control-label').next('div.controls').remove();
	
	/**
	 * Accordion panels local storage memoize and set open
	 */
	var defaultAccordionObject = {
		'gdpr_accordion_cpanel' : 'gdpr_stats'
	};
	
	[].slice.call(document.querySelectorAll('div.accordion')).map(function (accordionEl) {
		accordionEl.addEventListener('shown.bs.collapse', function(event) {
			if (!$(event.target).hasClass('card-block')) {
				return;
			}
			event.stopPropagation();
			
			// Trigger window resize to repaint the chart
			if ($(event.target).hasClass('accordion-chart')) {
				$(window).trigger('resize');
			}
			
			var localStorageAccordion = $.jStorage.get('gdprAccordionOpened', defaultAccordionObject);
			localStorageAccordion[this.id] = event.target.id;
			$.jStorage.set('gdprAccordionOpened', localStorageAccordion);

			// Scroll to accordion header if needed
			if (document.body.scrollHeight > window.innerHeight) {
				$('html, body').animate({
					scrollTop : parseInt($("#" + event.target.id).prev().offset().top) - 185
				}, 500);
			}
			// Add open state
			$(event.target).prev().addClass('opened');
		});
		accordionEl.addEventListener('hide.bs.collapse', function(event) {
			if (!$(event.target).hasClass('card-block')) {
				return;
			}
			event.stopPropagation();
			
			// Remove open state
			$(event.target).prev().removeClass('opened');
		});
	});

	$.each($.jStorage.get('gdprAccordionOpened', defaultAccordionObject), function(namespace, element) {
		if ($('#' + element, '#' + namespace).length) {
			$('#' + element, '#' + namespace).addClass('show').prev().addClass('opened');
		}
	});

	/**
	 * Prevent default scrolling hover main accordion body and scroll
	 * programmatically the document
	 */
	$('div.accordion-body').on('wheel', function(jqEvent) {
		if (jqEvent.originalEvent && jqEvent.originalEvent.wheelDelta) {
			if (jqEvent.originalEvent.wheelDelta)
				jqEvent.delta = jqEvent.originalEvent.wheelDelta;

			var newBodyScroll = $(document).scrollTop() - jqEvent.delta;
			$(document).scrollTop(newBodyScroll);
			jqEvent.preventDefault();
			return false;
		}
	});

	// Slide down and hide advanced controls
	var advancedExternal = $('select[name=params\\[external_blocking_mode\\]]');
	if(advancedExternal.val() == 'simple') {
		$('*.external_advanced').parents('div.control-group').hide();
	}
	$(advancedExternal).on('change', function(){
		var selectValue = $(this).val();
		if(selectValue == 'advanced' || selectValue == 'simplebytag') {
			$('*.external_advanced').parents('div.control-group').slideDown();
		} else {
			$('*.external_advanced').parents('div.control-group').slideUp();
		}
	});
	
	var profileButtonsWorkingMode = $('select[name=params\\[userprofile_buttons_workingmode\\]]');
	if(parseInt(profileButtonsWorkingMode.val()) == 1) {
		$('#params_userprofile_self_delete_confirmation').parents('div.control-group').hide();
	}
	$(profileButtonsWorkingMode).on('change', function(){
		if(parseInt($(this).val()) == 1) {
			$('#params_userprofile_self_delete_confirmation').parents('div.control-group').slideUp();
		} else {
			$('#params_userprofile_self_delete_confirmation').parents('div.control-group').slideDown();
		}
	});
	
	// Manage the hide/show of subcontrols for allowall button
	var allowallValue = $('input[name=params\\[allowall_showbutton\\]]:checked').val();
	if(allowallValue == 0) {
		$('*.allowall_ctrls').parents('div.control-group').hide();
	}
	$('input[name=params\\[allowall_showbutton\\]]').parent('label.btn').on('click', function(){
		if ($('input', this).val() == 1) {
			$('*.allowall_ctrls').parents('div.control-group').slideDown();
		} else {
			$('*.allowall_ctrls').parents('div.control-group').slideUp();
		}
	});
	
	
	// Manage the hide/show of subcontrols for auto accept category
	var switchersOptoutCategory = $('input[name=params\\[disable_switchers_optout_category\\]]:checked').val();
	if(switchersOptoutCategory == 0) {
		$('input[name*=auto_accept_categories]').parents('div.control-group').hide();
	}
	$('input[name=params\\[disable_switchers_optout_category\\]]').parent('label.btn').on('click', function(){
		if ($('input', this).val() == 1) {
			$('input[name*=auto_accept_categories]').parents('div.control-group').slideDown();
		} else {
			$('input[name*=auto_accept_categories]').parents('div.control-group').slideUp();
		}
	});
	
	// Manage the hide/show of subcontrols for Google CMP button
	$('input[name=params\\[googlecmp_template\\]]').parent('label.btn').on('click', function(){
		if ($('input', this).val() == 1) {
			$('#params_position').val('center').trigger('change');
			$('#params_position_center_simple_backdrop label:first-child').trigger('click');
		}
	});
	
	// Manage the hide/show of subcontrols for youtube placeholder
	var switchersOnpageUnlock = $('input[name=params\\[placeholder_onpage_unlock\\]]:checked').val();
	if(switchersOnpageUnlock == 0) {
		$('input[name*="auto_detect_youtube"]').parents('div.control-group').hide();
	}
	$('input[name=params\\[placeholder_onpage_unlock\\]]').parent('label.btn').on('click', function(){
		if ($('input', this).val() == 1) {
			$('input[name*="auto_detect_youtube"]').parents('div.control-group').slideDown();
		} else {
			$('input[name*="auto_detect_youtube"]').parents('div.control-group').slideUp();
		}
	});
	
	var checkboxTemplate = $('select[name=params\\[categories_checkbox_template\\]]');
	if(checkboxTemplate.val() != 'cc-checkboxes-switchers') {
		$('#params_categories_checkbox_template_style').parents('div.control-group').hide();
	}
	$(checkboxTemplate).on('change', function(){
		if($(this).val() == 'cc-checkboxes-switchers') {
			$('#params_categories_checkbox_template_style').parents('div.control-group').slideDown();
		} else {
			$('#params_categories_checkbox_template_style').parents('div.control-group').slideUp();
		}
	});
	
	var toolbarPosition = $('select#params_position');
	if(toolbarPosition.val() != 'center') {
		$('*.center_modal_block').parents('div.control-group').hide();
	}
	$(toolbarPosition).on('change', function(){
		if($(this).val() == 'center') {
			$('*.center_modal_block').parents('div.control-group').show();
		} else {
			$('*.center_modal_block').parents('div.control-group').hide();
		}
	});
	
	var chatGPTApi = $('select#params_chatgpt_api');
	if(chatGPTApi.val() != 'chatcompletions') {
		$('#params_chatgpt_api_model').parents('div.control-group').hide();
	}
	$(chatGPTApi).on('change', function(){
		if($(this).val() == 'chatcompletions') {
			$('#params_chatgpt_api_model').parents('div.control-group').slideDown();
		} else {
			$('#params_chatgpt_api_model').parents('div.control-group').slideUp();
		}
	});
	
	// Auto enable the log of IP address if the bulk consent switches on
	$('input[name=params\\[enable_gdpr_bulk_consent\\]]').on('click', function(){
		if($(this).val() == 1) {
			$('#params_log_user_ipaddress label:first-child').trigger('click');
		}
	});
	
	// Auto enable the advanced mode if the on page load switches on
	$('input[name=params\\[placeholder_onpage_unlock\\]]').on('click', function(){
		if($(this).val() == 1) {
			$('#params_external_blocking_mode').val('advanced').trigger('change');
		}
	});
	
	// Auto enable the additional block individual cookies/domains on server
	$('input[name=params\\[track_consent_date\\]]').on('click', function(){
		if($(this).val() == 1) {
			$('#params_block_individual_resources_serverside label:first-child').trigger('click');
		}
	});
	
	// Auto enable the block local cookies on server and switch to listed cookies if the storage block is turned on
	$('input[name=params\\[block_local_storage\\]], input[name=params\\[block_session_storage\\]]').on('click', function(){
		if($(this).val() == 1) {
			$('#params_block_local_cookies_server_side label:first-child').trigger('click');
			$('#params_categories_cookies_blocking_mode').val('listed').trigger('change');
		}
	});
	
	/**
	 * Tab panels local storage memoize and set open
	 */
	var defaultTabObject = {
		'tab_configuration' : 'preferences'
	};
	
	[].slice.call(document.querySelectorAll('#adminForm .nav.nav-tabs')).map(function (tabEl) {
		tabEl.addEventListener('shown.bs.tab', function(event) {
			var localStorageTab = $.jStorage.get('gdprTabOpened', defaultTabObject);
			var assignedID = this.id ? this.id : $(this).parents('div.row').attr('id');
			var assignedValue = $(event.target).data('element') ? $(event.target).data('element') : $(event.target).attr('href').substr(1)
			localStorageTab[assignedID] = assignedValue;
			$.jStorage.set('gdprTabOpened', localStorageTab);
			
			// Add accessibility ARIA 
			$('li.nav-item', this).removeAttr('aria-selected').attr('aria-selected', 'false');
			$('li.nav-item', this).removeAttr('tabindex').attr('tabindex', -1);
			$(event.target).parent('li').attr({'aria-selected':'true', 'tabindex':0});
			
			// Ensure that the label input checked will be active
			$("fieldset[data-bs-toggle=buttons] > label.btn > input:checked").each(function(i, element) {
				var parentLabel = $(element).parent('label.btn');
				if (!parentLabel.hasClass('active')) {
					parentLabel.addClass('active');
				}
			});
		});
	});
	
	// Parse query string to search if any anchor force tab opening
	var hashQueryString = window.location.hash.substr(2);
	if (hashQueryString) {
		var nodeElement = document.querySelector('ul.nav.nav-tabs li a[data-element=' + hashQueryString + ']');
		if(nodeElement) {
			var tabInstance = new bootstrap.Tab(nodeElement);
			tabInstance.show();
		}
	}

	if (hashQueryString == 'licensepreferences') {
		var nodeElement = document.querySelector('a[data-element=preferences]');
		if(nodeElement) {
			var tabInstance = new bootstrap.Tab(nodeElement);
			tabInstance.show();
		}
		$('#params_registration_email-lbl').css('color', 'red');
		$('#params_registration_email').css('border', '2px solid red');
	}

	$.each($.jStorage.get('gdprTabOpened', defaultTabObject), function(namespace, element) {
		var nodeElement = $('a[data-element=' + element + ']', '#' + namespace).get(0);
		if(nodeElement) {
			var tabInstance = new bootstrap.Tab(nodeElement);
			tabInstance.show();
		}
	});
	
	$(document).on('click', 'joomla-field-permissions ul[role=tablist] li', function(jqEvent){
		var tabTargetId = $('a', this).attr('id');
		$.jStorage.set('gdprFieldPermissions', tabTargetId);
	});
	if($.jStorage.get('gdprFieldPermissions')) {
		setTimeout(function(){
			var memoizedTabId = $.jStorage.get('gdprFieldPermissions');
			if($('#' + memoizedTabId).length) {
				$('#' + memoizedTabId).get(0).click();
			}
		}, 150);
	}

	// Add confirmation to the mass mail data breach process
	$('#toolbar-envelope button').removeAttr('onclick').on('click', function(jqEvent) {
		if (document.adminForm.boxchecked.value == 0) {
			alert(COM_GDPR_ERROR_RECORDS_EMPTY_JSMESSAGE);
		} else {
			if (confirm(COM_GDPR_SURE_TO_SEND_EMAIL)) {
				Joomla.submitbutton('users.notifyDataBreach');
			}
		}
	});
	
	// Simulate dropdown for datalist input fields when the arrow is clicked
	$('td.right_details input[name*=fields\\[]').on('click', function(jqEvent){
		var currentVal = $(this).val();
		if(!currentVal) {
			return true;
		}
		var currentElement = $(this);
		// Force the datalist to show again
		$(this).val('');
		
		jqEvent.stopPropagation();
		
		$(document).one('click', function(jqEvent){
			if(!currentElement.val()) {
				currentElement.val(currentVal);
			}
		});
	});
	
	$('td.right_details input[name*=fields\\[] + button.btn').on('click', function(jqEvent){
		$(this).prev('input').val('');
		return false;
	});
	
	// Add a hidden field and copy button for the custom revokable button code
	if(typeof(COM_GDPR_CUSTOM_COPY_CODE) !== 'undefined' && $('#tab_configuration').length) {
		$('#params_custom_revokable_button').after('<input data-role="copyclipboard" type="text" value="&lt;a class=&quot;cc-custom-revoke&quot;&gt;' + COM_GDPR_OPEN_COOKIE_TOOLBAR + '&lt;/a&gt;">' +
												   '<button data-role="copyclipboard" data-success="' + COM_GDPR_CUSTOM_COPIED_CODE + '" class="btn btn-sm btn-success">' + COM_GDPR_CUSTOM_COPY_CODE + '</button>');
	}
	
	// Support for copy Clipoard buttons, new API and legacy API
	if(navigator.clipboard) {
		$('button[data-role=copyclipboard]').on('click', function(jqEvent){
			navigator.clipboard.writeText($('input[data-role=copyclipboard]').val())
			.then(function() {
				var currentText = $(jqEvent.target).text();
				var copiedText = $(jqEvent.target).data('success');
				$(jqEvent.target).text(copiedText).removeClass('btn-success').addClass('btn-warning');
				setTimeout(function(){
					$(jqEvent.target).text(currentText).removeClass('btn-warning').addClass('btn-success');
				}, 2000);
			})
			.catch(function(err) {
			});
			return false;
		});
	} else {
		$('button[data-role=copyclipboard]').on('click', function(jqEvent){
			try {  
				var placeholderInput = $('input[data-role=copyclipboard]').get(0).select();  
				// Now that we've selected the text, execute the copy command  
				var successful = document.execCommand('copy');  
				if(successful) {
					var currentText = $(this).text();
					var copiedText = $(this).data('success');
					$(this).text(copiedText).removeClass('btn-success').addClass('btn-warning');
					setTimeout(function(){
						$(jqEvent.target).text(currentText).removeClass('btn-warning').addClass('btn-success');
					}, 2000);
				}
				// Remove the selections - NOTE: Should use
				// removeRange(range) when it is supported  
				window.getSelection().removeAllRanges();  
			} catch(err) {  
			}
			return false;
		});
	}
	
	// Add the button to reset all consents status in the #__user_profiles table
	if(typeof(COM_GDPR_RESET_ALL_CONSENTS) !== 'undefined' && $('#tab_configuration').length) {
		$('#params_block_privacypolicy').addClass('pull-left').after(
				'<label class="badge bg-danger nospacer resetconsents hasPopover" data-bs-title="' + COM_GDPR_RESET_ALL_CONSENTS_TITLE + '" data-bs-content="' + COM_GDPR_RESET_ALL_CONSENTS_DESC + '" onclick="Joomla.submitbutton(\'config.resetConsents\');"><span class="icon icon-warning-2"></span> ' + COM_GDPR_RESET_ALL_CONSENTS + '</label>' +
				'<label class="badge bg-danger nospacer resetconsents hasPopover" data-bs-title="' + COM_GDPR_RESET_YEARLY_CONSENTS_TITLE + '" data-bs-content="' + COM_GDPR_RESET_YEARLY_CONSENTS_DESC + '" onclick="Joomla.submitbutton(\'config.resetYearlyConsents\');"><span class="icon icon-warning-2"></span> ' + COM_GDPR_RESET_YEARLY_CONSENTS + '</label>'
				);
		[].slice.call(document.querySelectorAll('label.resetconsents')).map(function (popoverEl) {
			return new bootstrap.Popover(popoverEl,{
				template : '<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
				trigger : 'hover',
				placement : 'right',
				html : true
			});
		});
		
		// Manage the hide/show of subcontrols for custom images tags
		var blockPrivacyPolicy = $('input[name=params\\[block_privacypolicy\\]]:checked').val();
		if(blockPrivacyPolicy == 0) {
			$('label.resetconsents').hide();
		}
		$('input[name=params\\[block_privacypolicy\\]]').on('click', function(){
			if($(this).val() == 1) {
				$('label.resetconsents').show();
			} else {
				$('label.resetconsents').hide();
			}
		});
	}
	
	// Go to bottom button
	$('#gobottom').on('click', function(){
		$('html, body').animate({
			scrollTop: document.body.scrollHeight || document.documentElement.scrollHeight,
		}, 700);
	});
	
	// Back to top button
	$('#backtop').on('click', function(){
		$('html, body').animate({
			scrollTop: 0,
		}, 700);
	});
	
	$('input.field-media-input').each(function(index, elem){
	    $(elem).css('visibility','hidden');
	});
	// Observe media field image selection change
	$('div.field-media-preview').each(function(index, elem){
		// Create an observer instance for each element to observe
		var observer = new MutationObserver(function(mutations) {
			var image = $('img', elem);
			if(image.length) {
				let relatedInputField = $(elem).next('div').find('input.field-media-input');
				relatedInputField.val(relatedInputField.val().split('#')[0]);
			}
		});
		observer.observe(elem, { childList: true });
	});
	setTimeout(function(){
	    $('input.field-media-input').each(function(index, elem){
    		elem.value = elem.value.split('#')[0];
    		$(elem).css('visibility','visible');
	    });
	}, 300);
	
	// Override permissions tab retrieve ACL
	$('#permissions select[data-onchange-task]').removeAttr('data-onchange-task').on('change', function(jqEvent) {
	    const {
	    	target
	    } = jqEvent;

	    const icon = document.getElementById(`icon_${target.id}`);
	    icon.removeAttribute('class');
	    icon.setAttribute('class', 'joomla-icon joomla-field-permissions__spinner');

	    const {
	    	value
	    } = target;

	    const id = target.id.replace('params_rules_', '');
	    const lastUnderscoreIndex = id.lastIndexOf('_');
	    const permissionData = {
	    		comp: 'com_gdpr',
	    		action: id.substring(0, lastUnderscoreIndex),
	    		rule: id.substring(lastUnderscoreIndex + 1),
	    		value,
	    		title: 'com_gdpr'
	    };

	    Joomla.removeMessages();

	    Joomla.request({
	    	url: document.querySelector('joomla-field-permissions').getAttribute('data-uri'),
	    	method: 'POST',
	    	data: JSON.stringify(permissionData),
	    	perform: true,
	    	headers: {
	    		'Content-Type': 'application/json'
	    	},
	    	onSuccess: data => {
	    		let response;

		        try {
		          response = JSON.parse(data);
		        } catch (e) {
		          console.log(e);
		        }

		        icon.removeAttribute('class');

		        if (response.data && response.data.result) {
		        	icon.setAttribute('class', 'joomla-icon joomla-field-permissions__allowed');
		        	const badgeSpan = target.parentNode.parentNode.nextElementSibling.querySelector('span');
		        	badgeSpan.removeAttribute('class');
		        	badgeSpan.setAttribute('class', response.data.class);
		        	badgeSpan.innerHTML = response.data.text;
		        }

		        if (typeof response.messages === 'object' && response.messages !== null) {
		        	Joomla.renderMessages(response.messages);
	        		if (response.data && response.data.result) {
		        	  	icon.setAttribute('class', 'joomla-icon joomla-field-permissions__allowed');
		          	} else {
		        	  	icon.setAttribute('class', 'joomla-icon joomla-field-permissions__denied');
		          	}
		        }
	    	},
	    	onError: xhr => {
	    		// Remove the spinning icon.
	    		icon.removeAttribute('style');
	    		Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr, xhr.statusText));
	    		icon.setAttribute('class', 'joomla-icon joomla-field-permissions__denied');
	    	}
	    });
	});
});

/**
 * Compatibility functions for classical save ordering
 */
GdprSaveOrder = function ( n, task ) {
	GdprCheckAllCheckbox( n, task );
};

GdprCheckAllCheckbox = function ( n, task ) {
	task = task ? task : 'saveorder';

	var j, box;

	for ( j = 0; j <= n; j++ ) {
		box = document.adminForm[ 'cb' + j ];

		if ( box ) {
			box.checked = true;
		} else {
			alert( "You cannot change the order of items, as an item in the list is `Checked Out`" );
			return;
		}
	}

	Joomla.submitform( task );
};