<?php
/**
 * @package DJ-Tabs
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email: contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Language\Text;
class DJTabsTableGroups extends Table
{
    public function __construct(&$db) {
        parent::__construct('#__djtabs_groups', 'id', $db);
    }


    function bind($array, $ignore = '')
    {
        if (isset($array['params']) && is_array($array['params'])) {
            $registry = new Registry();
            $registry->loadArray($array['params']);
            $array['params'] = (string)$registry;
        }

        if(empty($array['alias'])) {
            $array['alias'] = $array['title'];
        }

        if(empty($array['image'])) {
            $array['image'] = "";
        }

        if(empty($array['description'])) {
            $array['description'] = "";
        }

        if(empty($array['params'])) {
            $array['params'] = "";
        }

        $array['alias'] = OutputFilter::stringURLSafe($array['alias']);
        if(trim(str_replace('-','',$array['alias'])) == '') {
            $array['alias'] = Factory::getDate()->format("Y-m-d-H-i-s");
        }

        return parent::bind($array, $ignore);
    }

    public function store($updateNulls = false)
    {
        $table = Table::getInstance('Groups', 'DJTabsTable');
        if ($table->load(array('alias'=>$this->alias,'parent_id'=>$this->parent_id)) && ($table->id != $this->id || $this->id==0)) {
            $this->setError(Text::_('COM_DJTABS_ERROR_UNIQUE_ALIAS'));
            return false;
        }
        return parent::store($updateNulls);
    }

}
