<?php

namespace T4\Helper;

use Joomla\CMS\Filesystem\File;

class Joomla
{
	// Create alias class for original call in $filepath, then overload the class
	public static function makeAlias($filepath, $originClassName, $aliasClassName)
	{
		if (!is_file($filepath)) return false;
		$cachePath = JPATH_CACHE . '/t4core/';
		$fileInfo = pathinfo($filepath);
		$target = $cachePath . $fileInfo['basename'];
		$lastEdit = filemtime($filepath);

		if (!is_file($target) || filemtime($target) < $lastEdit) {
			$code = file_get_contents($filepath);
			$code = str_replace('class ' . $originClassName, 'class ' . $aliasClassName, $code);

			File::write($target, $code);
		}

		require_once $target;

		return true;
	}
}
