<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\View\Weblink;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use SYW\Component\WeblinkLogosPro\Site\Helper\WeblinkHelper;

/**
 * View to edit a weblink associated to a user
 */
class HtmlView extends BaseHtmlView
{
	protected $state;

	protected $item;

	protected $return_page;

	protected $form;

	protected $params;

	protected $canSave;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws \Exception
	 */
	public function display($tpl = null)
	{
		$app  = Factory::getApplication();
		$user = Factory::getUser();

		$this->state = $this->get('State');
		$this->item = $this->get('Item');
		$this->params = $app->getParams('com_weblinklogospro');
		$this->canSave = $this->get('CanSave');
		$this->form = $this->get('Form');
		$this->return_page = $this->get('ReturnPage');

		// Check for errors
		if (count($errors = $this->get('Errors'))) {
			throw new \Exception(implode("\n", $errors));
		}

		$this->_prepareDocument();

		$this->bootstrap_version = $this->params->get('bootstrap_version', 'joomla');
		$this->load_bootstrap = false;
		if ($this->bootstrap_version === 'joomla') {
			$this->bootstrap_version = 5;
			$this->load_bootstrap = true;
		} else {
			$this->bootstrap_version = intval($this->bootstrap_version);
		}

		$this->config = ComponentHelper::getParams('com_weblinklogospro');

		$this->edit_fields = $this->config->get('edit_fields', array()); // objects of objects
		if (is_string($this->edit_fields)) {
		    $this->edit_fields = array();
		}
		
		$this->edit_group_fields = $this->config->get('edit_group_fields', array()); // objects of objects
		if (is_string($this->edit_group_fields)) {
		    $this->edit_group_fields = array();
		}
		
		$group_labels = array();
		if (is_object($this->edit_group_fields) && !empty($this->edit_group_fields)) {
		    foreach ($this->edit_group_fields as $edit_group_field) {
		        $group_labels[$edit_group_field->group] = $edit_group_field->label;
		    }
		}
		
		$customfields = array();
		if (Folder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '1')) {
		    
		    if (empty($this->item->id)) {
		        $customfields = FieldsHelper::getFields('com_weblinks.weblink');
		    } else {
		        $customfields = FieldsHelper::getFields('com_weblinks.weblink', $this->item);
		    }
		    
		    // organize the fields according to their group
		    
		    $fieldTypes = FieldsHelper::getFieldTypes();
		    
		    $this->fieldsPerGroup = array(0 => array());
		    $this->groupTitle = array(0 => Text::_('JGLOBAL_FIELDS'));
		    
		    foreach ($customfields as $key => $customfield) {
		        
		        if (!array_key_exists($customfield->type, $fieldTypes)) { // field type is not available
		            continue;
		        }
		        
		        if (!array_key_exists($customfield->group_id, $this->fieldsPerGroup)) {
		            $this->fieldsPerGroup[$customfield->group_id] = array();
		            if ($customfield->group_id > 0 && isset($group_labels[$customfield->group_id]) && $group_labels[$customfield->group_id]) {
		                $this->groupTitle[$customfield->group_id] = Text::_($group_labels[$customfield->group_id]);
		            } else {
		                $this->groupTitle[$customfield->group_id] = $customfield->group_title;
		            }
		        }
		        
		        if ($path = $fieldTypes[$customfield->type]['path']) {
		            FormHelper::addFieldPath($path); // add the lookup path for the field
		        }
		        
		        if ($path = $fieldTypes[$customfield->type]['rules']) {
		            FormHelper::addRulePath($path); // add the lookup path for the rule
		        }
		        
		        $this->fieldsPerGroup[$customfield->group_id][] = $customfield;
		        if ($customfield->group_id != 0) {
		            unset($customfields[$key]);
		        }
		    }
		}
		
		if (!empty($customfields)) {
		    
	        foreach ($this->edit_fields as $key => $field) {
	            
	            if ($field->field != 'section') {
	                
	                $complexname = explode("_", $field->field);
	                if ($complexname[0] == 'customfields') {
	                    
	                    $field_found = false;
	                    
	                    foreach ($customfields as $customfield) {
	                        if ($customfield->name == $complexname[1]) {
	                            $field_found = true;
	                        }
	                    }
	                    
	                    if (!$field_found) {
	                        unset($fields_array->$key);
	                    }
	                }
	            }
	        }
		}		

		$this->captchaEnabled = false;
		$captchaSet = $this->config->get('captcha', Factory::getApplication()->get('captcha', '0'));
		foreach (PluginHelper::getPlugin('captcha') as $plugin) {
			if ($captchaSet === $plugin->name) {
				$this->captchaEnabled = true;
				break;
			}
		}

		$this->canEdit = WeblinkHelper::canUserEdit($this->item, Factory::getUser());

		$this->isWeblinkNew = true;
		if ($this->item->id) {
			$this->isWeblinkNew = false;
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 *
	 * @throws \Exception
	 */
	protected function _prepareDocument()
	{
		$app   = Factory::getApplication();
		$menus = $app->getMenu();
		$title = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', Text::_('COM_WEBLINKLOGOSPRO_DEFAULT_EDITWEBLINK_PAGE_TITLE'));
		}

		$title = $this->params->get('page_title', '');

		if (empty($title))
		{
			$title = $app->get('sitename');
		}
		elseif ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}
}
