<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\View\Directory;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use SYW\Component\WeblinkLogosPro\Site\Cache\DirectoryCSSFileCache;
use SYW\Component\WeblinkLogosPro\Site\Helper\Helper;
use SYW\Library\Cache as SYWCache;
use SYW\Library\Fonts as SYWFonts;
use SYW\Library\Libraries as SYWLibraries;
use SYW\Library\Stylesheets as SYWStylesheets;
use SYW\Library\Utilities as SYWUtilities;
use SYW\Library\Version as SYWVersion;

/**
 * View class for a directory of Weblinklogospro
 */
class HtmlView extends BaseHtmlView
{
	protected $items;
	protected $pagination;
	protected $state;
	protected $params;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 * @return void
	 * @throws \Exception
	 */
	public function display($tpl = null)
	{
		// Get the parameters
		//$params = JComponentHelper::getParams('com_weblinklogospro');

		//$doc = Factory::getDocument();
		$app = Factory::getApplication();
		$wam = $app->getDocument()->getWebAssetManager();
		$this->input = $app->input;

		$this->state = $this->get('State');

		$this->params = $app->getParams('com_weblinklogospro');

// 		if ($this->state->get('firstuse')) {
// 			$pre_selected_category = $this->params->get('preselect_cat', 'none');
// 			if ($pre_selected_category != 'none') {
// 				$this->state->set('category', $pre_selected_category);
// 				$this->input->set('category', $pre_selected_category);
// 			}
// 		}

		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->user = Factory::getUser();

		$this->_prepareDocument();

		$this->pageclass_sfx = trim(htmlspecialchars($this->params->get('pageclass_sfx', '')));

		$this->extra_suffix = 'directory';
		if ($app->getMenu()->getActive()) {
			$this->extra_suffix .= '_'.$app->getMenu()->getActive()->id;
		}

		$this->urlPath = Uri::base().'components/com_weblinklogospro/';

		$this->bootstrap_version = $this->params->get('bootstrap_version', 'joomla');
		$this->load_bootstrap = false;
		if ($this->bootstrap_version === 'joomla') {
		    $this->bootstrap_version = 5; //version_compare(JVERSION, '4.0.0', 'lt') ? 2 : 5;
		    $this->load_bootstrap = true;
		} else {
			$this->bootstrap_version = intval($this->bootstrap_version);
		}

		$this->show_errors = Helper::isShowErrors($this->params);

		$this->remove_whitespaces = Helper::isRemoveWhitespaces($this->params);

		$this->load_remotely = $this->params->get('remote_libraries', 0);

		$this->clear_header_files_cache = Helper::IsClearHeaderCache($this->params);

		// logo creation

		$this->width = $this->params->get('width', 120);
		$this->height = $this->params->get('height', 40);

		$this->restrict_width = $this->params->get('restrict_width', 0);
		$this->center_vertically = $this->params->get('center_vertically', 0);

		$this->filter = $this->params->get('filter', 'none');
		if (strpos($this->filter, '_css') !== false) {
			$this->filter = 'none';
		}
		$this->filter_hover = $this->params->get('filter_hover', 'none');
		if (strpos($this->filter_hover, '_css') !== false) {
			$this->filter_hover = 'none';
		}
		
		$this->thumbnail_mime_type = $this->params->get('thumb_mime_type', '');
		
		$this->allow_remote = true;

		$this->quality_jpg = $this->params->get('quality_jpg', 75);
		$this->quality_png = $this->params->get('quality_png', 3);
		$this->quality_webp = $this->params->get('quality_webp', 80);
		$this->quality_avif = $this->params->get('quality_avif', 80);

		if ($this->quality_jpg > 100) {
			$this->quality_jpg = 100;
		}
		if ($this->quality_jpg < 0) {
			$this->quality_jpg = 0;
		}

		if ($this->quality_png > 9) {
			$this->quality_png = 9;
		}
		if ($this->quality_png < 0) {
			$this->quality_png = 0;
		}

		if ($this->quality_webp > 100) {
			$this->quality_webp = 100;
		}
		if ($this->quality_webp < 0) {
			$this->quality_webp = 0;
		}
		
		if ($this->quality_avif > 100) {
		    $this->quality_avif = 100;
		}
		if ($this->quality_avif < 0) {
		    $this->quality_avif = 0;
		}

		$this->image_qualities = array('jpg' => $this->quality_jpg, 'png' => $this->quality_png, 'webp' => $this->quality_webp, 'avif' => $this->quality_avif);

		$hover_type = $this->params->get('hover_type', 'none'); // hover animation
		if ($hover_type != 'none') {
			$this->hover_type = 'hvr-'.$hover_type;
			//SYWStylesheets::load2DTransitions();
			$transition_method = SYWStylesheets::getTransitionMethod($this->hover_type);
			SYWStylesheets::$transition_method();
		} else {
			$this->hover_type = 'smooth';
		}

		$subdirectory = 'thumbnails/wlp';
		if ($this->params->get('thumb_path', 'images') == 'cache') {
			$subdirectory = 'com_weblinklogospro';
		}
		$this->tmp_path = SYWCache::getTmpPath($this->params->get('thumb_path', 'images'), $subdirectory);

		// links

		$this->popup_width = $this->params->get('popup_x', 600);
		$this->popup_height = $this->params->get('popup_y', 500);

		// unique filenames

		$this->unique_filename_extra = '';
		if ($this->params->get('unique_files', 1)) {
			if ($app->getMenu()->getActive()) {
				$this->unique_filename_extra = 'directory_'.$app->getMenu()->getActive()->id;
			} else {
				$this->unique_filename_extra = 'directory';
			}
		}

		$this->clear_cache = Helper::IsClearPictureCache($this->params);

		if ($this->clear_cache) {
			Helper::clearThumbnails($this->tmp_path, $this->unique_filename_extra);
			
			SYWVersion::refreshMediaVersion('com_weblinklogospro_' . $this->extra_suffix);
		}

		// high resolution images

		$this->create_highres_images = $this->params->get('create_highres', false);

		// hit feedback

		if ($this->params->get('hit_feedback', 0)) {
			//HTMLHelper::_('jquery.framework');
			Helper::loadClickedScript();
		}

		// configuration

		$this->configuration = $this->params->get('logos_layout', 'grid');

// 		$this->overall_width = $this->params->get('overall_width', '');

// 		$this->margin_top = $this->params->get('margin_top', 5);
// 		$this->margin_right = $this->params->get('margin_right', 5);
// 		$this->margin_bottom = $this->params->get('margin_bottom', 5);
// 		$this->margin_left = $this->params->get('margin_left', 5);

		$this->title_html_tag = $this->params->get('title_tag', '4');
		$this->description_html_tag = $this->params->get('description_tag', 'none');
		if ($this->description_html_tag == 'none') {
			$this->description_html_tag = '';
		}

		// keep to make sure overrides still work after update

		$this->letter_count = trim($this->params->get('l_count', ''));
		if (empty($this->letter_count)) {
			$this->letter_count = -1;
		} else {
			$this->letter_count = (int)($this->letter_count);
		}

		$this->strip_tags = $this->params->get('strip_tags', 1);
		$this->keep_tags = trim($this->params->get('keep_tags', ''));
		$this->trigger_events = $this->params->get('trigger_events', false);

		// END keep to make sure overrides still work after update

		$this->caption_classes = '';
		$caption_classes = trim($this->params->get('caption_classes', ''));
		if ($caption_classes) {
			$this->caption_classes = ' '.$caption_classes;
		}

		$this->hits_classes = '';
		$hits_classes = trim($this->params->get('hits_classes', ''));
		if ($hits_classes) {
			$this->hits_classes = ' '.$hits_classes;
		}

		// headings

		$this->show_heading = $this->params->get('s_h', 'h') == 'h' ? false : true;
		$this->show_heading_description = $this->params->get('s_h_desc', 0);
		$this->show_heading_image = $this->params->get('s_h_image', 0);
		$this->heading_html_tag = $this->params->get('h_tag', '2');
		//$this->heading_view_id = $this->params->get('h_views', 'self');

		if ($this->show_heading) {
		    $this->categories_list = $this->get('CategoriesList');
		}

		// pagination

		$layout_suffix = trim($this->params->get('layout_suffix', ''));

		$this->show_pagination = true; // $this->params->get('s_pag', 1);

		$this->show_pagination_results = $this->params->get('s_pag_r', 1);
		$this->show_pagination_results_total = $this->params->get('s_pag_r_t', 1);
		$this->show_pagination_limit = $this->params->get('s_pag_l', 1);
		if ($this->show_pagination_limit) {
			$this->limits = Helper::getLimitsForBox($this->params->get('pag_l', ''));
		}
		//$this->pagination_limit_count = $this->params->get('pag_l_c', '');

		$this->show_cat_picture = $this->params->get('show_cat_pic', 0);
		$this->category_default_picture = $this->params->get('cat_d_pic', '');

		$this->show_tag_picture = $this->params->get('show_tag_pic', 0);
		$this->tag_default_picture = $this->params->get('tag_d_pic', '');
		$this->use_tag_classes = $this->params->get('tag_useclasses', 1);

		$this->pagination_top_index = array('', ''); // filled to avoid overrides to break if search but no index and backward compatibility with overrides
		$this->pagination_bot_index = array('', ''); // filled to avoid overrides to break if search but no index and backward compatibility with overrides

		$this->pagination_layouts = array();
		$this->pagination_data = array();
		$this->pagination_class = array();

		$filters = array();

		$top_filters = $this->params->get('top_filters', null);
		if (!empty($top_filters) && is_array($top_filters)) {
			foreach ($top_filters as $filter) {
				switch ($filter['formfilter']) {
					case 'c' :
						if (!in_array('top_categories', $this->pagination_top_index)) {
							$this->pagination_top_index[] = 'top_categories';
							$filters['top_categories'] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
						break;
					case 't' :
						if (!in_array('top_tags', $this->pagination_top_index)) {
							$this->pagination_top_index[] = 'top_tags';
							$filters['top_tags'] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
						break;
					default : // custom field - value jfield:list:70 where 70 is the id of the field
						$field_temp = explode(':', $filter['formfilter']);
						$field_id = $field_temp[2];
						if (!in_array('top_jfield_' . $field_id, $this->pagination_top_index)) {
							$this->pagination_top_index[] = 'top_jfield_' . $field_id;
							$filters['top_jfield_' . $field_id] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
				}
			}
		}

		// for backward compatibility with overrides
		while (count($this->pagination_top_index) > 2 && $this->pagination_top_index[0] == '') {
			array_shift($this->pagination_top_index);
		}

		$bottom_filters = $this->params->get('bot_filters', null);
		if (!empty($bottom_filters) && is_array($bottom_filters)) {
			foreach ($bottom_filters as $filter) {
				switch ($filter['formfilter']) {
					case 'c' :
						if (!in_array('bot_categories', $this->pagination_bot_index)) {
							$this->pagination_bot_index[] = 'bot_categories';
							$filters['bot_categories'] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
						break;
					case 't' :
						if (!in_array('bot_tags', $this->pagination_bot_index)) {
							$this->pagination_bot_index[] = 'bot_tags';
							$filters['bot_tags'] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
						break;
					default : // custom field - value jfield:list:70 where 70 is the id of the field
						$field_temp = explode(':', $filter['formfilter']);
						$field_id = $field_temp[2];
						if (!in_array('bot_jfield_' . $field_id, $this->pagination_bot_index)) {
							$this->pagination_bot_index[] = 'bot_jfield_' . $field_id;
							$filters['bot_jfield_' . $field_id] = array('style' => $filter['ff_style'], 'label' => $filter['ff_label']);
						}
				}
			}
		}

		// for backward compatibility with overrides
		while (count($this->pagination_bot_index) > 2 && $this->pagination_bot_index[0] == '') {
			array_shift($this->pagination_bot_index);
		}

		$this->field_index_array = array();
		
		// get the pre-selected custom fields, if any
		
		$customfield_filters_arrays = array();
		
		$customfield_filters = $this->params->get('customfieldsfilter'); // string (if default), array or object
		
		if (!empty($customfield_filters) && !is_string($customfield_filters)) {
		    
		    foreach ($customfield_filters as $customfield_filter) {
		        
		        $customfield_filter = (array)$customfield_filter;
		        
		        if ($customfield_filter['field'] !== 'none') {
		            
		            $values = explode(',', $customfield_filter['values']);
		            foreach ($values as $key => $value) {
		                $value = trim($value);
		                if (empty($value)) {
		                    unset($values[$key]);
		                }
		            }
		            
		            if (!empty($values)) {
		                $customfield_filters_arrays[$customfield_filter['field']] = array('values' => $values, 'inex' => $customfield_filter['inex']);
		            }
		        }
		    }
		}

		foreach ($filters as $key => $filter) {
			switch ($key) {
				case 'top_categories': case 'bot_categories':

					$layout = new FileLayout('pagination.wlpcategoryindex');
					if ($layout_suffix) {
						$layout->setSuffixes(array($layout_suffix));
					}

					$data = array('list' => $this->get('CategoriesList'), 'style' => $filter['style'], 'show_picture' => $this->show_cat_picture, 'default_picture' => $this->category_default_picture, 'selection_label' => $filter['label']);
					$data['unselectable'] = $this->params->get('cat_index_unselect', array());
					$data['show_hierarchy'] = $this->params->get('show_cat_hierarchy', 0);
					$data['bootstrap_version'] = $this->bootstrap_version;
					$data['load_bootstrap'] = $this->load_bootstrap;

					$this->pagination_layouts[$key] = $layout;
					$this->pagination_data[$key] = $data;
					$this->pagination_class[$key] = 'category_directory index_filter' . (($filter['style'] == 'selection') ? ' selection' : ' listing');
					break;

				case 'top_tags': case 'bot_tags':

					$layout = new FileLayout('pagination.wlptagindex');
					if ($layout_suffix) {
						$layout->setSuffixes(array($layout_suffix));
					}

					$data = array('list' => $this->get('TagsList'), 'style' => $filter['style'], 'use_tag_classes' => $this->use_tag_classes, 'show_picture' => $this->show_tag_picture, 'default_picture' => $this->tag_default_picture, 'selection_label' => $filter['label']);
					$data['bootstrap_version'] = $this->bootstrap_version;
					$data['load_bootstrap'] = $this->load_bootstrap;

					$this->pagination_layouts[$key] = $layout;
					$this->pagination_data[$key] = $data;
					$this->pagination_class[$key] = 'tag_directory index_filter' . (($filter['style'] == 'selection') ? ' selection' : ' listing');
					break;

				default: // custom fields

					$field_temp = explode('_', $key);

					$field_id = $field_temp[2];
					if (!in_array($field_id, $this->field_index_array)) {
						$this->field_index_array[] = $field_id;
					}

					$field_name = '';
					$options_list = array();
					$multiple = false;

					$all_fields = FieldsHelper::getFields('com_weblinks.weblink');

					foreach ($all_fields as $field) {
						if ($field->id == $field_id) {

							$field_name = $field->name;
							$multiple = $field->fieldparams->get('multiple');
							$options_list = $field->fieldparams->get('options');
							
							// if the index is also a pre-selected field, only show the values that have been pre-selected
							
							if (isset($customfield_filters_arrays[$field->id])) {
							    
							    foreach ($options_list as $prop => $option) {
							        if ($customfield_filters_arrays[$field->id]['inex']) {
							            if (!in_array($option->value, $customfield_filters_arrays[$field->id]['values'])) {
							                unset($options_list->$prop);
							            }
							        } else {
							            if (in_array($option->value, $customfield_filters_arrays[$field->id]['values'])) {
							                unset($options_list->$prop);
							            }
							        }
							    }
							}
							
							break;
						}
					}

					$layout = new FileLayout('pagination.wlplistfield');

					$data = array('id' => $field_id, 'name' => $field_name, 'list' => $options_list, 'multiple' => $multiple, 'style' => $filter['style'], 'selection_label' => $filter['label']);
					$data['bootstrap_version'] = $this->bootstrap_version;
					$data['load_bootstrap'] = $this->load_bootstrap;

					$this->pagination_layouts[$key] = $layout;
					$this->pagination_data[$key] = $data;
					$this->pagination_class[$key] = 'field_directory index_filter' . (($filter['style'] == 'selection') ? ' selection' : ' listing');
			}
		}


		// page display

		$this->actions_style = $this->params->get('actions_style', 'dropdown');
		$this->actions_classes = $this->params->get('actions_classes', '');
		$this->show_print = $this->params->get('print', 0);
		$this->show_search = $this->params->get('search', 0);
		$this->show_search_options = $this->params->get('search_options', 0);

 		$this->article_before_text = $this->get('TextArticleBefore');
 		$this->article_after_text = $this->get('TextArticleAfter');

		// add specific styles
		$user_styles = trim($this->params->get('styles', ''));
		if (!empty($user_styles)) {
			$user_styles = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $user_styles); // minify the CSS code
		}

		// caching the stylesheet
		$cache_css = new DirectoryCSSFileCache('com_weblinklogospro', $this->params);
		$cache_css->addDeclaration($user_styles);

		$result = $cache_css->cache('style_'.$this->extra_suffix.'.css', $this->clear_header_files_cache);

		if ($result) {
			//$doc->addStyleSheet(Uri::base(true).'/media/cache/com_weblinklogospro/style_'.$this->extra_suffix.'.css');
			$wam->registerAndUseStyle('wlp.style_' . $this->extra_suffix, $cache_css->getCachePath() . '/style_' . $this->extra_suffix . '.css', ['relative' => true, 'version' => 'auto']);
		}

		Helper::loadUserStylesheet('directory');

		// mobile

		$this->isMobile = SYWUtilities::isMobile();

		// extra parameters

		$this->limitstart_request_value = $this->input->getInt('limitstart', 0);
		$this->limitstart_request = '&limitstart='.$this->limitstart_request_value;

		$this->category_request = '';
		$this->category_request_value = $this->input->getString('category', '');
		if (!empty($this->category_request_value)) {
			$this->category_request = '&category='.$this->category_request_value;
		}
		$this->pagination->setAdditionalUrlParam('category', $this->category_request_value);

		$this->tag_request = '';
		$this->tag_request_value = $this->input->getString('tag', '');
		if (!empty($this->tag_request_value)) {
			$this->tag_request = '&tag='.$this->tag_request_value;
		}
		$this->pagination->setAdditionalUrlParam('tag', $this->tag_request_value);
		
		// custom fields as filter
		foreach ($this->field_index_array as $field_index) {
		    $field_request_value = 'field_' . $field_index . '_value';
		    $this->$field_request_value = $this->input->getString('field_' . $field_index, '');
		    $this->pagination->setAdditionalUrlParam('field_' . $field_index, $this->$field_request_value);
		}

		$this->search_request = '';
		$this->search_request_value = $this->input->getString('filter-search', '');
		if (!empty($this->search_request_value)) {
			$this->search_request = '&filter-search='.$this->search_request_value;
		}
		$this->pagination->setAdditionalUrlParam('filter-search', $this->search_request_value);

		$this->search_options_request = '';
		$this->search_options_request_value = $this->input->getString('filter-match', 'any');
		if (!empty($this->search_options_request_value)) {
			$this->search_options_request = '&filter-match='.$this->search_options_request_value;
		}
		$this->pagination->setAdditionalUrlParam('filter-match', $this->search_options_request_value);

		$this->print = $this->input->getBool('print', false);
		if ($this->print) { // we are in the popup window
			//$doc->addStyleSheet(Uri::base(true) . '/media/com_weblinklogospro/css/directory/print.css', 'text/css', 'print');
			$wam->registerAndUseStyle('wlp.directory_print', 'com_weblinklogospro/directory/print.css', ['relative' => true, 'version' => 'auto'], ['media' => 'print']);
		}

		// load icon font
		if ($this->params->get('load_icon_font', 1)) {
			SYWFonts::loadIconFont();
		}

		// get the layout
		$layout = $this->input->getWord('layout', '');
		if (empty($layout)) {
			$this->setLayout($this->params->get('view_layout'));
		}

		// load the CSS needed for accessibility
		if ($this->bootstrap_version == 0 || $this->bootstrap_version == 2) {
		    SYWStylesheets::loadAccessibilityVisibilityStyles();
		}

		// display the view
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 * @throws \Exception
	 */
	protected function _prepareDocument()
	{
		$app   = Factory::getApplication();
		$menus = $app->getMenu();
		$title = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu) {
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		} else {
			$this->params->def('page_heading', Text::_('COM_WEBLINKLOGOSPRO_DEFAULT_PAGE_TITLE'));
		}

		$title = $this->params->get('page_title', '');

		if (empty($title)) {
			$title = $app->getCfg('sitename');
		} elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
			$title = Text::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
		} elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
			$title = Text::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description')) {
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords')) {
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots')) {
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}

		// add alternative feed link
		if ($this->params->get('show_feed_link', 1) == 1) {
			$link = '&format=feed&limitstart=';
			$attribs = array('type' => 'application/rss+xml', 'title' => 'RSS 2.0');
			$this->document->addHeadLink(Route::_($link . '&type=rss'), 'alternate', 'rel', $attribs);
			$attribs = array('type' => 'application/atom+xml', 'title' => 'Atom 1.0');
			$this->document->addHeadLink(Route::_($link . '&type=atom'), 'alternate', 'rel', $attribs);
		}
	}

}
