CREATE TABLE IF NOT EXISTS `#__securitycheckpro_users_control` (
`id` INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
`users` VARCHAR(100) NOT NULL,
`contador` INT(3) UNSIGNED NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__securitycheckpro_db`;
CREATE TABLE `#__securitycheckpro_db` (
`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`Product` VARCHAR(35) NOT NULL,
`vuln_type` VARCHAR(35),
`Vulnerableversion` VARCHAR(40) DEFAULT '---',
`modvulnversion` VARCHAR(2) DEFAULT '==',
`Joomlaversion` VARCHAR(30) DEFAULT 'Notdefined',
`modvulnjoomla` VARCHAR(20) DEFAULT '==',
`description` VARCHAR(90),
`vuln_class` VARCHAR(70),
`published` VARCHAR(35),
`vulnerable` VARCHAR(70),
`solution_type` VARCHAR(35) DEFAULT '???',
`solution` VARCHAR(70),
PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__securitycheckpro_db` (`product`,`vuln_type`,`vulnerableversion`,`modvulnversion`,`Joomlaversion`,
`modvulnjoomla`,`description`,`vuln_class`,`published`,`vulnerable`,`solution_type`,`solution`) VALUES 
('Joomla!','core','3.0.0','==','3.0.0','==','Joomla! XSS Vulnerability','Typographical error','Oct 09 2012','Joomla! 3.0.0','update','3.0.1'),
('com_fss','component','1.9.1.1447','<=','3.0.0','>=','Joomla Freestyle Support Component','SQL Injection Vulnerability','Oct 19 2012','Versions prior to 1.9.1.1447','none','No details'),
('com_commedia','component','3.1','<=','3.0.0','>=','Joomla Commedia Component','SQL Injection Vulnerability','Oct 19 2012','Versions prior to 3.1','update','3.2'),
('Joomla!','core','3.0.1','<=','3.0.1','<=','Joomla! Core Clickjacking Vulnerability','Inadequate protection','Nov 08 2012','Joomla! 3.0.1 and 3.0.0 versions','update','3.0.2'),
('com_jnews','component','7.9.1','<','3.0.0','>=','Joomla jNews Component','Arbitrary File Creation Vulnerability','Nov 19 2012','Versions prior to 7.9.1','update','7.9.1'),
('com_bch','component','---','==','3.0.0','>=','Joomla Bch Component','Shell Upload Vulnerability','Dec 26 2012','Not especificed','none','No details'),
('com_aclassif','component','---','==','3.0.0','>=','Joomla Aclassif Component','Cross Site Scripting Vulnerability','Dec 26 2012','Not especificed','none','No details'),
('com_rsfiles','component','1.0.0 Rev 11','==','3.0.0','>=','Joomla RSFiles! Component','SQL Injection Vulnerability','Mar 19 2013','Version 1.0.0 Rev 11','update','1.0.0 Rev 12'),
('Joomla!','core','3.0.2','<=','3.0.2','<=','Joomla! XSS Vulnerability','Inadequate filtering','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.2','<=','Joomla! DOS Vulnerability','Object unserialize method','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.0','>=','Joomla! Information Disclosure Vulnerability','Inadequate permission checking','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.0','>=','Joomla! XSS Vulnerability','Use of old version of Flash-based file uploader','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.0','>=','Joomla! Privilege Escalation Vulnerability','Inadequate permission checking','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('Joomla!','core','3.0.2','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering','Apr 24 2013','Joomla! version 3.0.2 and earlier 3.0.x versions','update','3.1.0'),
('com_jnews','component','8.0.1','<=','3.0.0','>=','Joomla Jnews Component','Cross Site Scripting Vulnerability','May 14 2013','Version 8.0.1 an earlier','update','8.1.x'),
('com_attachments','component','3.1.1','<','3.0.0','>=','Joomla Com_Attachments Component','Arbitrary File Upload Vulnerability','Jul 09 2013','Versions prior to 3.1.1','update','3.1.1'),
('System - Google Maps','plugin','3.1','<','3.0.0','>=','Joomla Googlemaps Plugin','XSS/XML Injection/Path Disclosure/DoS Vulnerabilities','Jul 17 2013','Version 3.1 and maybe above','update','3.1'),
('System - Google Maps','plugin','3.2','<=','3.0.0','>=','Joomla Googlemaps Plugin','XSS/DoS Vulnerabilities','Jul 26 2013','Version 3.2','update','3.x'),
('Joomla!','core','3.1.4','<=','3.0.0','>=','Joomla! Unauthorised Uploads Vulnerability','Inadequate filtering','Jul 31 2013','Joomla! 3.1.4 and earlier 3.x versions','update','3.1.5'),
('com_sectionex','component','2.5.96','<=','3.0.0','>=','Joomla SectionEx Component','SQL Injection Vulnerability','Aug 05 2013','Version 2.5.96 and maybe earlier','update','2.5.104'),
('com_joomsport','component','2.0.1','<','3.0.0','>=','Joomla joomsport Component','Multiple Vulnerabilities','Aug 20 2013','Versions prior to 2.0.1','update','2.0.1'),
('Joomla!','core','3.1.5','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering','Nov 06 2013','Joomla! 3.1.5 and all earlier 3.x versions','update','3.2'),
('Joomla!','core','3.1.5','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering','Nov 06 2013','Joomla! 3.1.5 and all earlier 3.x versions','update','3.2'),
('Joomla!','core','3.1.5','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering','Nov 06 2013','Joomla! 3.1.5 and all earlier 3.x versions','update','3.2'),
('com_flexicontent','component','2.1.3','<=','3.0.0','>=','Joomla Flexicontent Component','Remote Code Execution Vulnerability','Dec 08 2013','Version 2.1.3 and earlier','none','No details'),
('com_mijosearch','component','2.0.1','<=','3.0.0','>=','Joomla MijoSearch Component','Cross Site Scripting/Exposure Vulnerability','Dec 16 2013','Version 2.0.1 and maybe earlier','update','2.0.4'),
('com_acesearch','component','3.0','==','3.0.0','>=','Joomla AceSearch Component','Cross Site Scripting Vulnerability','Jan 06 2014','Version 3.0','none','No details'),
('com_melody','component','1.6.25','<=','3.0.0','>=','Joomla Melody Component','Cross Site Scripting Vulnerability','Jan 10 2014','Version 1.6.25 and maybe earlier','none','No details'),
('com_sexypolling','component','1.0.8','<=','3.0.0','>=','Joomla Sexy Polling Component','SQL Injection Vulnerability','Jan 16 2014','Version 1.0.8 and maybe earlier','update','1.0.9'),
('com_komento','component','1.7.2','<=','3.0.0','>=','Joomla Komento Component','Cross Site Scripting Vulnerability','Jan 24 2014','Version 1.7.2 and maybe earlier','update','1.7.4'),
('com_community','component','2.6','==','3.0.0','>=','Joomla JomSocial Component','Code Execution Vulnerability','Jan 31 2014','Version 2.6','update','3.1.0'),
('Joomla!','core','3.2.2','<=','3.0.0','>=','Joomla! SQL Injection Vulnerability','Inadequate escaping','Mar 06 2014','Joomla! 3.1.0 through 3.2.2','update','3.2.3'),
('Joomla!','core','3.2.2','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate escaping','Mar 06 2014','Joomla! 3.1.2 through 3.2.2','update','3.2.3'),
('com_youtubegallery','component','3.4.0','==','3.0.0','>=','Joomla Youtube Gallery Component','Cross Site Scripting','Mar 15 2014','Version 3.4.0','update','3.8.3'),
('com_pbbooking','component','2.4','==','3.0.0','>=','Joomla Pbbooking Component','Cross Site Scripting','Mar 15 2014','Version 3.4.0','none','No details'),
('com_extplorer','component','2.1.3','==','3.0.0','>=','Joomla eXtplorer Component','Cross Site Scripting','Mar 15 2014','Version 2.1.3','update','2.1.5'),
('com_freichat','component','3.5','<=','3.0.0','>=','Joomla Freichat Component','Cross Site Scripting','Mar 15 2014','Version 3.4.0','none','No details'),
('com_multicalendar','component','4.0.2','==','3.0.0','>=','Joomla Multi Calendar Component','Cross Site Scripting','Mar 15 2014','Version 4.0.2','update','4.8.9'),
('com_kunena','component','3.0.4','==','3.0.0','>=','Joomla Kunena Component','Cross Site scripting Vulnerability','Mar 27 2014','Version 3.0.4','update','3.0.5'),
('com_jchat','component','2.2','==','3.0.0','>=','Joomla JChatSocial Component','Cross Site scripting Vulnerability','Jul 07 2014','Version 2.2 and maybe lower','update','2.3'),
('com_youtubegallery','component','4.1.7','<=','3.0.0','>=','Joomla Youtube Gallery Component','SQL Injection Vulnerability','Jul 17 2014','Version 4.1.7 and maybe lower','update','4.2.0'),
('com_kunena','component','3.0.5','==','3.0.0','>=','Joomla Kunena Component','Cross Site scripting Vulnerability','Jul 30 2014','Version 3.0.5','update','3.0.6'),
('com_kunena','component','3.0.5','==','3.0.0','>=','Joomla Kunena Component','SQL Injection Vulnerability','Jul 30 2014','Version 3.0.5','update','3.0.6'),
('com_spidervideoplayer','component','2.8.3','==','3.0.0','>=','Joomla Spider Video Player Component','SQL Injection Vulnerability','Aug 26 2014','Version 2.8.3','none','No details'),
('com_akeeba','component','3.11.4','<','3.0.0','>=','Joomla Akeeba Backup Component','Not specified','Aug 20 2014','Version 3.11.4 and lower','update','3.11.4'),
('com_spidercalendar','component','3.2.6','<=','3.0.0','>=','Joomla Spider Calendar Component','SQL Injection Vulnerability','Sept 08 2014','Version 3.2.6 and lower','update','3.2.7'),
('com_spidercontacts','component','1.3.6','<=','3.0.0','>=','Joomla Spider Contacts Component','SQL Injection Vulnerability','Sept 10 2014','Version 1.3.6 and lower','update','1.3.7'),
('com_formmaker','component','3.4.1','<','3.0.0','>=','Joomla Spider Form Maker Component','SQL Injection Vulnerability','Sept 12 2014','Version 3.4.0 and lower','update','3.4.1'),
('com_facegallery','component','1.0','==','3.0.0','>=','Joomla Face Gallery Component','SQL Injection / File Download Vulnerabilities','Sept 22 2014','Version 1.0','none','No details'),
('com_macgallery','component','1.5','<=','3.0.0','>=','Joomla Mac Gallery Component','Arbitrary File Download Vulnerability','Sept 22 2014','Version 1.5 and lower','none','No details'),
('Joomla!','core','3.3.4','<','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate escaping','Sep 23 2014','Joomla! 3.3.0 through 3.3.3','update','3.3.4'),
('Joomla!','core','3.3.4','<','3.0.0','>=','Joomla! Unauthorised Logins Vulnerability','Inadequate checking','Sep 23 2014','Joomla! 3.3.0 through 3.3.4','update','3.3.4'),
('Joomla!','core','3.3.4','<=','3.0.0','>=','Joomla! Remote File Inclusion Vulnerability','Inadequate checking','Sep 30 2014','Joomla! 3.3.0 through 3.3.4','update','3.3.5'),
('Joomla!','core','3.3.4','<=','3.0.0','>=','Joomla! Denial of service Vulnerability','Inadequate checking','Sep 30 2014','Joomla! 3.3.0 through 3.3.4','update','3.3.5'),
('com_creativecontactform','component','2.0.0','<=','3.0.0','>=','Joomla Creative Contact Form Component','Shell Upload Vulnerability','Oct 23 2014','Version 2.0.0 and lower','none','No details'),
('com_xcloner-backupandrestore','component','3.5.1','==','3.0.0','>=','Joomla XCloner Component','Command Execution/Password Disclosure Vulnerabilities','Nov 07 2014','Version 3.5.1','update','3.5.2'),
('com_hdflvplayer','component','2.1.0.1','==','3.0.0','>=','Joomla HD FLV Component','SQL Injection Vulnerability','Nov 13 2014','Version 2.1.0.1','none','No details'),
('mod_simpleemailform','module','1.8.5','<=','3.0.0','>=','Simple Email Form Module','Cross site Scripting Vulnerability','Nov 19 2014','Version 1.8.5 and maybe lower','none','No details'),
('com_jclassifiedsmanager','component','2.0.0','<','3.0.0','>=','JClassifiedsManager Component','Cross Site Scripting/SQL Injection Vulnerabilities','Jan 26 2015','Versions prior to 2.0.0','update','2.0.0'),
('com_simplephotogallery','component','1.0','==','3.0.0','>=','Simple Photo Gallery Component','SQL Injection Vulnerability','Mar 16 2015','Version 1.0','update','1.1'),
('com_ecommercewd','component','1.2.5','==','3.0.0','>=','ECommerce-WD Component','SQL Injection Vulnerabilities','Mar 19 2015','Version 1.2.5','update','1.2.6'),
('com_spiderfaq','component','1.1','==','3.0.0','>=','Spider FAQ Component','SQL Injection Vulnerabilities','Mar 22 2015','Version 1.1','none','No details'),
('com_rand','component','1.5','==','3.0.0','>=','Spider Random Article Component','SQL Injection Vulnerabilities','Mar 25 2015','Version 1.5','none','No details'),
('com_gallery_wd','component','1.2.5','==','3.0.0','>=','Gallery WD Component','SQL Injection Vulnerabilities','Mar 30 2015','Version 1.2.5','none','No details'),
('com_contactformmaker','component','1.0.1','==','3.0.0','>=','Form Maker Component','SQL Injection Vulnerabilities','Mar 30 2015','Version 1.0.1','none','No details'),
('com_osproperty','component','2.8.0','<=','3.0.0','>=','OSProperty Component','SQL Injection Vulnerability','Apr 29 2015','Versions prior to 2.8.0 ','update','2.8.0'),
('com_eqfullevent','component','1.0.0','<=','3.0.0','>=','EQ Event Calendar Component','SQL Injection Vulnerability','Jun 8 2015','Version 1.0.0 and lower ','none','No details'),
('Joomla!','core','3.4.1','<=','3.0.0','>=','Joomla! Low level Vulnerability','Not especified','Jul 01 2015','Joomla! 3.x series','update','3.4.2'),
('com_kunena','component','4.0.2','==','3.0.0','>=','Joomla Kunena Component','Cross Site scripting Vulnerability','Jul 03 2015','Version 4.0.2','update','4.0.3'),
('com_j2store','component','3.1.6','==','2.5.0,3.0.0','>=,>=','Joomla J2Store Component','SQL Injection Vulnerabilities','Jul 11 2015','Version 3.1.6','update','3.1.7'),
('com_kunena','component','4.0.3','<=','2.5.0,3.0.0','>=,>=','Joomla Kunena Component','Full Path Disclosure Vulnerability','Jul 17 2015','Version 4.0.3 and lower','none','No details'),
('com_helpdeskpro','component','1.4.0','<','2.5.0,3.0.0','>=,>=','Joomla Helpdesk Pro Component','Multiple Vulnerabilities','Jul 21 2015','Version 1.4.0 and lower','update','1.4.0'),
('mod_jshopping_products_wfl','module','4.10.4','<=','3.0.0','>=','JoomShopping Module','Blind Sql injection Vulnerability','Aug 09 2015','Version 4.10.4 and lower','none','No details'),
('Joomla!','core','3.4.3','<=','3.0.0','>=','Joomla! Cross site scripting Vulnerability','Inadequate checking','Sep 09 2015','Joomla! 3.4 series','update','3.4.4'),
('com_komento','component','2.0.5','<','3.0.0','>=','Joomla Komento Component','Cross Site scripting Vulnerability','Oct 04 2015','Version 2.0.4 and lower','update','2.0.5'),
('Joomla!','core','3.4.4','<=','3.0.0','>=','Joomla! SQL Injection Vulnerability','Inadequate filtering','Oct 22 2015','Joomla! versions 3.2.0 through 3.4.4','update','3.4.5'),
('Joomla!','core','3.4.4','<=','3.0.0','>=','Joomla! ACL violations Vulnerability','Inadequate ACL checks','Oct 22 2015','Joomla! versions 3.2.0 through 3.4.4','update','3.4.5'),
('Joomla!','core','3.4.4','<=','3.0.0','>=','Joomla! ACL violations Vulnerability','Inadequate ACL checks','Oct 22 2015','Joomla! versions 3.0.0 through 3.4.4','update','3.4.5'),
('com_rpl','component','8.9.2','==','3.0.0','>=','Realtyna RPL Component','Multiple SQL Injection Vulnerabilities','Oct 23 2015','Version 8.9.2','update','8.9.3'),
('com_rpl','component','8.9.2','==','3.0.0','>=','Realtyna RPL Component','Persistent XSS And CSRF Vulnerabilities','Oct 23 2015','Version 8.9.2','update','8.9.3'),
('com_jnews','component','8.5.1','<=','2.5.0,3.0.0','>=,>=','Joomla JNews Component','Sql injection Vulnerability','Oct 29 2015','Version 8.5.1 and maybe lower','none','No details'),
('Joomla!','core','3.4.5','<=','3.0.0','>=','Joomla! Remote Code Execution Vulnerability','Browser information not filtered','Dec 14 2015','Joomla! versions 1.5.0 through 3.4.5','update','3.4.6'),
('Joomla!','core','3.4.5','<=','3.0.0','>=','Joomla! CSRF Vulnerability','CSRF','Dec 14 2015','Joomla! versions 3.2.0 through 3.4.5','update','3.4.6'),
('Joomla!','core','3.4.5','<=','3.0.0','>=','Joomla! Directory Traversa Vulnerability','Not sanitise input data','Dec 14 2015','Joomla! versions 3.4.0 through 3.4.5','update','3.4.6'),
('s5_media_player','plugin','2.0','==','2.5.0,3.0.0','>=,>=','Shape 5 MP3 Player Plugin','Local File Disclosure Vulnerability','Dec 14 2015','Version 2.0','none','No details'),
('Joomla!','core','3.4.6','<=','3.0.0','>=','Joomla! Session Hardening','Improved Session handling','Dec 21 2015','Joomla! versions 1.5.0 through 3.4.6','update','3.4.7'),
('Joomla!','core','3.4.6','<=','3.0.0','>=','Joomla! SQL Injection Vulnerability','Inadequate filtering of request data','Dec 21 2015','Joomla! versions 3.0.0 through 3.4.6','update','3.4.7'),
('fsave','plugin','2.0','==','2.5.0,3.0.0','>=,>=','Fsave Plugin','Local File Disclosure Vulnerability','Jan 20 2016','Version 2.0','none','No details'),
('com_pricelist','component','2.3.1','==','3.0.0','>=','Joomla Pricelist Component','Sql injection Vulnerability','Feb 07 2016','Version 2.3.1','update','3.3.0'),
('com_poweradmin','component','2.3.0','<=','3.0.0','>=','Joomla JSN PowerAdmin Component','Remote Command Execution Via CSRF and XSS vulnerabilities','Feb 25 2016','Version 2.3.0 and maybe lower','update','2.3.2'),
('com_easy_youtube_gallery','component','1.0.2','==','3.0.0','>=','Joomla Easy Youtube Gallery Component','SQL Injection vulnerability','Mar 23 2016','Version 1.0.2','none','No details'),
('com_icagenda','component','3.5.15','<=','2.5.0,3.0.0','>=,>=','iCagenda Component','Cross Site Scripting Vulnerability','Mar 23 2015','Version 3.5.5 up to 3.5.15','update','3.5.16'),
('mod_news_pro_gk5','module','1.9.3.4','<','2.5.0,3.0.0','>=,>=','News Show Pro GK5 Module','Sql injection Vulnerability','Apr 04 2016','Not specified','update','1.9.3.4'),
('com_jem','component','2.1.15','<=','2.5.0,3.0.0','>=,>=','Event Manager Component','Cross Site Scripting Vulnerability','May 14 2016','2.x versions','none','No details'),
('com_extplorer','component','2.1.9','==','2.5.0,3.0.0','>=,>=','Extplorer Component','Path traversal Vulnerability','May 16 2016','2.1.9 version','none','No details'),
('com_securitycheck','component','2.8.10','<','2.5.0,3.0.0','>=,>=','Securitycheck Component','XSS and Sql Injection Vulnerabilities','May 31 2016','2.8.9 version and lower','update','2.8.10'),
('com_securitycheckpro','component','2.8.10','<','2.5.0,3.0.0','>=,>=','Securitycheck Pro Component','XSS and Sql Injection Vulnerabilities','May 31 2016','2.8.9 version and lower','update','2.8.10'),
('com_jumi','component','3.0.5','==','2.5.0,3.0.0','>=,>=','Jumi Component','Cross site Scripting Vulnerability','Jun 03 2016','3.0.5','none','No details'),
('com_jobgrokapp','component','3.1-1.2.55','==','3.0.0','>=','Joomla JobGrokApp Component','SQL Injection vulnerability','Jun 07 2016','Version 3.1-1.2.55','none','No details'),
('com_joomdoc','component','4.0.3','==','2.5.0,3.0.0','>=,>=','JoomDoc Component','Path Disclosure Vulnerability','Jun 08 2016','4.0.3','none','No details'),
('com_payplans','component','3.3.6','==','3.0.0','>=','Pay Plans Component','SQL Injection Vulnerability','Jun 14 2016','3.3.6','none','No details'),
('com_affiliate','component','1.0.3','==','2.5.0','>=','Affiliate Component','SQL Injection Vulnerability','Jun 14 2016','1.0.3','none','No details'),
('com_maqmahelpdesk','component','4.2.3','==','3.0.0','>=','Maqma Helpdesk Component','Cross Site scripting Vulnerability','Jun 14 2016','4.2.3','none','No details'),
('com_affiliatetracker','component','2.0.3','==','2.5.0,3.0.0','>=,>=','Affiliate Tracker Component','SQL Injection Vulnerability','Jun 14 2016','2.0.3','none','No details'),
('com_enmasse','component','6.4','<=','3.0.0','>=','En-Masse Component','SQL Injection Vulnerability','Jun 15 2016','Versions 5.1 to 6.4','none','No details'),
('com_bt_media','component','1.0','==','2.5.0,3.0.0','>=,>=','BT Media Component','SQL Injection Vulnerability','Jun 20 2016','1.0','none','No details'),
('com_publisher','component','3.0.11','==','2.5.0,3.0.0','>=,>=','Publisher Component','SQL Injection Vulnerability','Jun 22 2016','3.0.11','none','No details'),
('com_services','component','---','==','3.0.0','>=','Services Component','SQL Injection Vulnerability','Jul 12 2016','Not specified','none','No details'),
('com_branch','component','3.0','==','3.0.0','>=','Branch Component','SQL Injection Vulnerability','Jul 12 2016','3.0','none','No details'),
('com_zhgooglemap','component','8.1.2.0','==','2.5.0,3.0.0','>=,>=','Zh GoogleMap Component','Blind SQL Injection Vulnerability','Jul 15 2016','8.1.2.0','none','No details'),
('com_guru','component','5.0.1','<=','2.5.0,3.0.0','>=,>=','Guru Pro Component','SQL Injection Vulnerability','Jul 14 2016','All versions','none','No details'),
('com_gallery','component','1.1.5','==','3.0.0','>=','Huge IT Gallery Component','Cross Site scripting/SQL Injection vulnerabilities','Jul 26 2016','1.1.5','update','1.1.6'),
('com_catalog','component','1.0.4','==','3.0.0','>=','Huge IT Catalog Component','Cross Site scripting/SQL Injection vulnerabilities','Jul 27 2016','1.0.4','update','1.0.5'),
('com_slider','component','1.0.9','==','3.0.0','>=','Huge IT slider Component','Cross Site scripting/SQL Injection vulnerabilities','Jul 28 2016','1.0.9','none','No details'),
('Joomla!','core','3.6.0','==','3.0.0','>=','Joomla! CSRF Vulnerability','csrf hardening','Aug 03 2016','Joomla! version 3.6.0','update','3.6.1'),
('com_videoflow','component','1.1.5','<=','2.5.0,3.0.0','>=,>=','Video Flow Component','SQL Injection Vulnerability','Aug 06 2016','1.1.3 to 1.1.5','update','1.2.0'),
('com_k2','component','2.7.1','<','2.5.0,3.0.0','>=,>=','K2 Component','Cross Site scripting Vulnerability','Aug 06 2016','Versions prior to 2.7.1','update','2.7.1'),
('com_registrationpro','component','3.2.12','==','3.0.0','>=','Registration Pro Component','SQL Injection vulnerability','Aug 14 2016','Versions 3.2.10 to 3.2.12','update','3.2.13'),
('com_videogallerylite','component','1.0.9','<=','3.0.0','>=','Huge IT Video Gallery Component','SQL Injection vulnerability','Sep 23 2016','1.0.9','update','1.1.0'),
('com_eventbooking','component','2.10.1','==','3.0.0','>=','Event Booking Component','SQL Injection vulnerability','Sep 25 2016','2.10.1','update','2.10.2'),
('com_videogallerylite','component','1.1.1','<=','3.0.0','>=','Huge IT Video Gallery Component','Cross Site Scripting vulnerability','Oct 01 2016','1.0.9','none','No details'),
('com_catalog','component','1.0.7','==','3.0.0','>=','Huge IT Catalog Component','SQL Injection vulnerabilities','Sep 30 2016','1.0.7','none','No details'),
('com_portfoliogallery','component','1.0.6','==','3.0.0','>=','Huge IT Portfolio Gallery Component','SQL Injection vulnerabilities','Oct 01 2016','1.0.6','none','No details'),
('mod_dvfoldercontent','module','1.0.2','==','3.0.0','>=','DVFolderContent Module','Local File Disclosure vulnerabilities','Oct 01 2016','1.0.2','none','No details'),
('com_googlemaps','component','1.0.9','==','3.0.0','>=','Huge IT Googlemaps Component','SQL Injection vulnerabilities','Oct 01 2016','1.0.9','none','No details'),
('Joomla!','core','3.6.3','<=','3.0.0','>=','Joomla! Account Creation','Inadequate checks','Oct 25 2016','Joomla! versions 3.4.4 through 3.6.3','update','3.6.4'),
('Joomla!','core','3.6.3','<=','3.0.0','>=','Joomla! Elevated Privileges','Incorrect use of unfiltered data','Oct 25 2016','Joomla! versions 3.4.4 through 3.6.3','update','3.6.4'),
('Joomla!','core','3.6.3','<=','3.0.0','>=','Joomla! Account Modifications','Incorrect use of unfiltered data','Oct 26 2016','Joomla! versions 3.4.4 through 3.6.3','update','3.6.4'),
('com_kunena','component','5.0.3','<=','3.0.0','>=','Joomla Kunena Component','File upload Vulnerability','Nov 26 2016','Version 4.0.0 to 5.0.3','update','5.0.4'),
('Joomla!','core','3.6.4','<=','3.0.0','>=','Joomla! Elevated Privileges','Incorrect use of unfiltered data','Dec 13 2016','Joomla! versions 1.6.0 to 3.6.4','update','3.6.5'),
('Joomla!','core','3.6.4','<=','3.0.0','>=','Joomla! Shell upload','Incorrect filesystem checks','Dec 13 2016','Joomla! versions 3.0.0 to 3.6.4','update','3.6.5'),
('Joomla!','core','3.6.4','<=','3.0.0','>=','Joomla! Information disclosure','Incorrect ACL checks','Dec 13 2016','Joomla! versions 3.0.0 to 3.6.4','update','3.6.5'),
('com_dtregister','component','3.1.12','<','3.0.0','>=','DT Register Component','SQL Injection Vulnerability','Dec 16 2016','Versions prior to 3.1.12','update','3.1.12'),
('com_rpl','component','8.9.2','==','3.0.0','>=','RPL Component','SQL Injection Vulnerability','Dec 21 2016','Version 8.9.2','update','8.9.5'),
('com_kunena','component','5.0.5','<','3.0.0','>=','Joomla Kunena Component','XSS Vulnerability','Jan 04 2017','Version 5.0.2 to 5.0.5','update','5.0.5'),
('com_rsmonials','component','2.2','<=','3.0.0','>=','Joomla RsMonials Component','XSS Vulnerability','Jan 11 2017','Version 2.2 and previous','none','No details'),
('com_storelocator','component','2.3.1.0','==','3.0.0','>=','Joomla Store Locator Component','Cross site scripting Vulnerability','Feb 01 2017','Version 2.3.1.0','none','No details'),
('com_jtagcalendar','component','6.2.4','==','3.0.0','>=','Joomla JTAG Calendar Component','SQL Injection Vulnerability','Feb 01 2017','Version 6.2.4','none','No details'),
('com_joominaflileselling','component','2.2','==','3.0.0','>=','Joomla Joominaflileselling Component','SQL Injection Vulnerability','Feb 14 2017','Version 2.2','none','No details'),
('com_soccerbet','component','4.1.5','==','3.0.0','>=','Joomla Soccer Bet Component','SQL Injection Vulnerability','Feb 14 2017','Version 4.1.5','none','No details'),
('com_vikbooking','component','1.7','==','3.0.0','>=','Joomla Vik Booking Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.7','none','No details'),
('com_onisquotes','component','2.5','==','3.0.0','>=','Joomla Onisquotes Component','SQL Injection Vulnerability','Feb 14 2017','Version 2.5','none','No details'),
('com_sponsorwall','component','7.0','==','3.0.0','>=','Joomla Sponsor Wall Component','SQL Injection Vulnerability','Feb 14 2017','Version 7.0','none','No details'),
('com_onispetitions','component','2.5','==','3.0.0','>=','Joomla onisPetitions Component','SQL Injection Vulnerability','Feb 14 2017','Version 2.5','none','No details'),
('com_onismusic','component','2','==','3.0.0','>=','Joomla onisMusic Component','SQL Injection Vulnerability','Feb 14 2017','Version 2','none','No details'),
('com_jemessenger','component','1.2.2','==','3.0.0','>=','Joomla JE Messenger Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.2.2','none','No details'),
('com_jequoteform','component','1.4','==','3.0.0','>=','Joomla JE QuoteForm Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.4','none','No details'),
('com_jegridfolio','component','---','==','3.0.0','>=','Joomla JE Grid Folio Component','SQL Injection Vulnerability','Feb 14 2017','Version not specified','none','No details'),
('com_jeticket','component','1.2','==','3.0.0','>=','Joomla JE Ticket System Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.2','none','No details'),
('com_jeportfolio','component','1.2','==','3.0.0','>=','Joomla JE Portfolio Creator Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.2','none','No details'),
('com_jeformcr','component','1.8','==','3.0.0','>=','Joomla JE Form Creator Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.8','none','No details'),
('com_jeshop','component','1.3','==','3.0.0','>=','Joomla JE Shop Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.3','none','No details'),
('com_jeclassifyads','component','1.2','==','3.0.0','>=','Joomla JE Classify Ads Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.2','none','No details'),
('com_jegallery','component','1.3','==','3.0.0','>=','Joomla JE Gallery Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.3','none','No details'),
('com_jedirectory','component','1.7','==','3.0.0','>=','Joomla JE Directory Ads Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.7','none','No details'),
('com_jepropertyfinder','component','1.6.3','==','3.0.0','>=','Joomla JE Property Finder Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.6.3','none','No details'),
('com_jequizmanagement','component','2.3','==','3.0.0','>=','Joomla JE Quiz Component','SQL Injection Vulnerability','Feb 14 2017','Version 2.3','none','No details'),
('com_hbooking','component','1.9.9','==','3.0.0','>=','Joomla Hbooking Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.9.9','none','No details'),
('com_jetour','component','2.0','==','3.0.0','>=','Joomla JE Tour Component','SQL Injection Vulnerability','Feb 14 2017','Version 2.0','none','No details'),
('com_jevideorate','component','1.0','==','3.0.0','>=','Joomla JE Video Rate Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.0','none','No details'),
('com_jeauction','component','1.6','==','3.0.0','>=','Joomla JE Auction Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.6','none','No details'),
('com_jeauto','component','1.5','==','3.0.0','>=','Joomla JE Auto Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.5','none','No details'),
('com_jeawdsong','component','1.8','==','3.0.0','>=','Joomla JE Awd Song Component','SQL Injection Vulnerability','Feb 14 2017','Version 1.8','none','No details'),
('com_geocontent','component','4.5','==','3.0.0','>=','Joomla Geocontent Component','Cross site scripting Vulnerability','Feb 14 2017','Version 4.5','none','No details'),
('com_fastball','component','3.2.8','==','3.0.0','>=','Joomla Fastball Component','SQL Injection Vulnerability','Feb 14 2017','Version 3.2.8','none','No details'),
('com_gameserver','component','3.4','==','3.0.0','>=','Joomla Gameserver! Component','SQL Injection Vulnerability','Feb 14 2017','Version 3.4','none','No details'),
('com_muscol','component','3.0.3','==','3.0.0','>=','Joomla Music Collection Component','SQL Injection Vulnerability','Feb 14 2017','Version 3.0.3','none','No details'),
('com_jsplocation','component','2.2','==','3.0.0','>=','Joomla JSP Store Locator Component','SQL Injection Vulnerability','Feb 20 2017','Version 2.2','none','No details'),
('com_spiderfacebook','component','1.6.1','==','3.0.0','>=','Joomla Spider Facebook Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.6.1','none','No details'),
('com_spiderfaq','component','1.3.1','==','3.0.0','>=','Joomla Spider FAQ Lite Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.3.1','none','No details'),
('com_jembedall','component','1.4','==','3.0.0','>=','Joomla JEmbedAll Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.4','none','No details'),
('com_spidercatalog','component','1.8.10','==','3.0.0','>=','Joomla Spider Catalog Lite Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.8.10','none','No details'),
('com_joomblog','component','1.3.1','==','3.0.0','>=','Joomla Joomblog Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.3.1','none','No details'),
('com_wmt_content_timeline','component','1.0','==','3.0.0','>=','Joomla WMT Content Timeline Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.0','none','No details'),
('com_groovygallery','component','1.0.0','==','3.0.0','>=','Joomla Groovy Gallery Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.0.0','none','No details'),
('com_spidercalendar','component','3.2.16','==','3.0.0','>=','Joomla Spider Calendar Lite Component','SQL Injection Vulnerability','Feb 20 2017','Version 3.2.16','none','No details'),
('com_teamdisplay','component','1.2.1','==','3.0.0','>=','Joomla Team Display Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.2.1','none','No details'),
('com_anief','component','1.5','==','3.0.0','>=','Joomla Anief Component','SQL Injection Vulnerability','Feb 21 2017','Version 1.5','none','No details'),
('com_djcatalog2','component','1.5','==','3.0.0','>=','Joomla DjCatalog2 Component','SQL Injection Vulnerability','Feb 21 2017','Version 1.5','none','No details'),
('com_mostwantedrealestate','component','1.1.0','==','3.0.0','>=','Joomla Most Wanted Real Estate Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.1.0','none','No details'),
('com_googlemaplocator','component','4.4','==','3.0.0','>=','Joomla Google Map Store Locator Component','SQL Injection Vulnerability','Feb 22 2017','Version 4.4','none','No details'),
('com_joomloc','component','4.1.3','==','3.0.0','>=','Joomla Joomloc-CAT Component','SQL Injection Vulnerability','Feb 22 2017','Version 4.1.3','none','No details'),
('com_joomloclite','component','1.3.2','==','3.0.0','>=','Joomla Most Wanted Real Estate Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.3.2','none','No details'),
('com_awdwall','component','4.0','==','3.0.0','>=','Joomla JoomWALL Component','SQL Injection Vulnerability','Feb 22 2017','Version 4.0','none','No details'),
('com_osproperty','component','3.0.8','==','3.0.0','>=','Joomla OS Property Component','SQL Injection Vulnerability','Feb 22 2017','Version 3.0.8','none','No details'),
('com_bazaar','component','3.0','==','3.0.0','>=','Joomla Bazaar Platform Component','SQL Injection Vulnerability','Feb 22 2017','Version 3.0','none','No details'),
('com_viewcontent','component','1.6','==','3.0.0','>=','Joomla View Content Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.6','none','No details'),
('com_docman','component','1.6','==','3.0.0','>=','Joomla Docman Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.6','none','No details'),
('com_dcrc','component','1.6','==','3.0.0','>=','Joomla DCRC Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.6','none','No details'),
('com_topics','component','1.6','==','3.0.0','>=','Joomla Topics Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.6','none','No details'),
('com_maqmahelpdesk','component','4.2.7','==','3.0.0','>=','Joomla MaQma Helpdesk Component','SQL Injection Vulnerability','Feb 22 2017','Version 4.2.7','none','No details'),
('com_maxcomment','component','1.6','==','3.0.0','>=','Joomla Maxcomment Component','SQL Injection Vulnerability','Feb 22 2017','Version 1.6','none','No details'),
('com_eshop','component','2.5.1','==','3.0.0','>=','Joomla Eshop Component','SQL Injection Vulnerability','Feb 22 2017','Version 2.5.1','none','No details'),
('com_docmanpaypal','component','3.1','==','3.0.0','>=','Joomla PayPal IPN for DOCman Component','SQL Injection Vulnerability','Feb 22 2017','Version 3.1','none','No details'),
('com_jhotelreservation','component','6.0.2','==','3.0.0','>=','Joomla J-HotelPortal Component','SQL Injection Vulnerability','Feb 24 2017','Version 6.0.2','none','No details'),
('com_rsgallery2','component','1.6','==','3.0.0','>=','Joomla RSGallery2 Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.6','none','No details'),
('com_contentmap','component','1.3.8','==','3.0.0','>=','Joomla ContentMap Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.3.8','none','No details'),
('com_jbusinessdirectory','component','4.6.8','==','3.0.0','>=','Joomla J-BusinessDirectory Component','SQL Injection Vulnerability','Feb 24 2017','Version 4.6.8','none','No details'),
('com_eventix','component','1.0','==','3.0.0','>=','Joomla Eventix Events Calendar Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.0','none','No details'),
('com_booklibrary','component','3.6.1','==','3.0.0','>=','Joomla BookLibrary Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.6.1','none','No details'),
('com_rsappt_pro3','component','4.0.1','==','3.0.0','>=','Joomla AppointmentBookingPro Component','SQL Injection Vulnerability','Feb 24 2017','Version 4.0.1','none','No details'),
('com_jhotelreservation','component','6.0.2','==','3.0.0','>=','Joomla J-MultipleHotelReservation Standard Component','SQL Injection Vulnerability','Feb 24 2017','Version 6.0.2','none','No details'),
('com_directorix','component','1.1.1','==','3.0.0','>=','Joomla Directorix Directory Manager Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.1.1','none','No details'),
('com_jcruisereservation','component','3.0','==','3.0.0','>=','Joomla J-CruiseReservation Standard Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.0','none','No details'),
('com_realestatemanager','component','3.9','==','3.0.0','>=','Joomla RealEstateManager Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.9','none','No details'),
('com_vehiclemanager','component','3.9','==','3.0.0','>=','Joomla VehicleManager Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.9','none','No details'),
('com_magicdealsweb','component','1.2.0','==','3.0.0','>=','Joomla Magic Deals Web Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.2.0','none','No details'),
('com_booklibrary','component','3.5','==','3.0.0','>=','Joomla MediaLibrary Basic Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.5','none','No details'),
('com_userextranet','component','1.3.1','==','3.0.0','>=','Joomla UserExtranet Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.3.1','none','No details'),
('com_multitier','component','3.1','==','3.0.0','>=','Joomla MultiTier Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.1','none','No details'),
('com_k2store','component','3.8.2','==','3.0.0','>=','Joomla Store for K2 Component','SQL Injection Vulnerability','Feb 24 2017','Version 3.8.2','none','No details'),
('com_redshop','component','1.5','==','3.0.0','>=','Joomla RedShop Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.5','none','No details'),
('com_jajobboard','component','1.5','==','3.0.0','>=','Joomla JaJobBoard Component','SQL Injection Vulnerability','Feb 24 2017','Version 1.5','none','No details'),
('com_securitycheck','component','2.8.18','<','3.0.0','>=','Joomla Securitycheck Component','XSS Vulnerability','Jan 24 2017','Version 2.8.18 and lower','update','2.8.18'),
('com_securitycheckpro','component','2.8.18','<','3.0.0','>=','Joomla Securitycheck Pro Component','XSS Vulnerability','Jan 24 2017','Version 2.8.18 and lower','update','2.8.18'),
('com_rsmonials','component','2.2','<=','3.0.0','>=','Joomla Rsmonials Component','XSS Vulnerability','Jan 11 2017','Version 2.2 and lower','none','No details'),
('com_altauserpoints','component','1.1','==','3.0.0','>=','Joomla AltaUserpoints Component','SQL Injection Vulnerability','Mar 05 2017','Version 1.1','none','No details'),
('com_os_cck','component','1.1','==','3.0.0','>=','Joomla Content ConstructionKit Component','SQL Injection Vulnerability','Mar 05 2017','Version 1.1','none','No details'),
('com_aysquiz','component','1.0','==','3.0.0','>=','Joomla AYS Quiz Component','SQL Injection Vulnerability','Mar 05 2017','Version 1.0','none','No details'),
('com_monthlyarchive','component','3.6.4','==','3.0.0','>=','Joomla Monthly archive Component','SQL Injection Vulnerability','Mar 05 2017','Version 3.6.4','none','No details'),
('com_jux_eventon','component','1.0.1','==','3.0.0','>=','Joomla JUX EventOn Component','SQL Injection Vulnerability','Mar 05 2017','Version 1.0.1','none','No details'),
('com_product','component','2.2','==','3.0.0','>=','Joomla com_product Component','SQL Injection Vulnerability','Mar 10 2017','Version 2.2','none','No details'),
('com_advertisementboard','component','3.0.4','==','3.0.0','>=','Joomla Advertisement Board Component','SQL Injection Vulnerability','Mar 14 2017','Version 3.0.4','none','No details'),
('com_simplemembership','component','3.3.3','==','3.0.0','>=','Joomla Simple Membership Component','SQL Injection Vulnerability','Mar 14 2017','Version 3.3.3','none','No details'),
('com_alfcontact','component','3.2.3','==','3.0.0','>=','Joomla ALFContact Component','SQL Injection Vulnerability','Mar 14 2017','Version 3.2.3','none','No details'),
('com_vikrentcar','component','1.11','==','3.0.0','>=','Joomla Vik Rent Car Component','SQL Injection Vulnerability','Mar 15 2017','Version 1.11','none','No details'),
('com_vikrentitems','component','1.3','==','3.0.0','>=','Joomla Vik Rent Items Component','SQL Injection Vulnerability','Mar 15 2017','Version 1.3','none','No details'),
('com_vikappointments','component','1.5','==','3.0.0','>=','Joomla Vik Rent Appointments Component','SQL Injection Vulnerability','Mar 15 2017','Version 1.5','none','No details'),
('com_jcart','component','2.0','==','3.0.0','>=','Joomla jCart for Opencart Component','SQL Injection Vulnerability','Mar 20 2017','Version 2.0','none','No details'),
('com_opencart','component','2.0','==','3.0.0','>=','Joomla JooCart Component','SQL Injection Vulnerability','Mar 20 2017','Version 2.0','none','No details'),
('com_extrasearch','component','2.2.8','==','3.0.0','>=','Joomla Extra search Component','SQL Injection Vulnerability','Mar 21 2017','Version 2.2.8','none','No details'),
('com_modern_booking','component','1.0','==','3.0.0','>=','Joomla Modern Booking Component','SQL Injection Vulnerability','Mar 23 2017','Version 1.0','none','No details'),
('com_focalpoint','component','1.2.3','==','3.0.0','>=','Joomla Focal Point Component','SQL Injection Vulnerability','Mar 24 2017','Version 1.2.3','none','No details'),
('com_jobgroklist','component','3.1-1.2.58','==','3.0.0','>=','Joomla JobGrok Listing Component','SQL Injection Vulnerability','Apr 03 2017','Version 3.1-1.2.58','none','No details'),
('com_jobgrokapp','component','3.1-1.2.55','==','3.0.0','>=','Joomla JobGrok Application Component','SQL Injection Vulnerability','Apr 03 2017','Version 3.1-1.2.55','none','No details'),
('com_joomloclite','component','1.3.3','==','3.0.0','>=','Joomla Joomloc-Lite Component','SQL Injection Vulnerability','Mar 13 2017','Version 1.3.3','update','1.4.1'),
('com_joomloc','component','4.1.3','==','3.0.0','>=','Joomla Joomloc-CAT Component','SQL Injection Vulnerability','Mar 13 2017','Version 4.1.3','update','4.2.1'),
('com_osproperty','component','3.0.9','==','3.0.0','>=','Joomla OS Property Component','SQL Injection Vulnerability','Mar 14 2017','Version 3.0.9','update','3.10.0'),
('com_booklibrary','component','3.6.14','==','3.0.0','>=','Joomla BookLibrary Component','SQL Injection Vulnerability','Mar 17 2017','Version 3.6.14','update','3.6.15'),
('com_vehiclemanager','component','3.9.4','==','3.0.0','>=','Joomla Vehicle manager Component','SQL Injection Vulnerability','Mar 17 2017','Version 3.9.4','update','3.9.5'),
('mod_repowa','module','1.0','==','3.0.0','>=','Joomla Responsive Portfolio Wall Module','XSS Vulnerability Vulnerability','Mar 18 2017','Version 1.0','update','1.1'),
('mod_ap_portfolio','module','3.3.1','<=','3.0.0','>=','Joomla AP Portfolio Wall Module','XSS Vulnerability Vulnerability','Mar 18 2017','Version 3.3.1 and lower','update','3.3.2'),
('com_realstatemanager','component','3.9.7','==','3.0.0','>=','Joomla Real Estate manager Component','SQL Injection Vulnerability','Mar 22 2017','Version 3.9.7','update','3.9.8'),
('com_booklibrary','component','3.5.4','==','3.0.0','>=','Joomla MeadiaLibrary Component','SQL Injection Vulnerability','Mar 22 2017','Version 3.5.4','update','3.5.5'),
('com_rsappt-pro','component','4.0.1','==','3.0.0','>=','Joomla AppointmentBookingPro Component','SQL Injection Vulnerability','Mar 22 2017','Version 4.0.1','update','4.0.2'),
('com_modern_booking','component','1.0','==','3.0.0','>=','Joomla Modern Booking Component','SQL Injection Vulnerability','Apr 09 2017','Version 1.0','none','No details'),
('com_directorix','component','1.1.1','==','3.0.0','>=','Joomla Directorix Directory Manager Component','SQL Injection Vulnerability','Mar 20 2017','Version 1.1.1','none','No details'),
('com_jcruisereservation','component','3.0','==','3.0.0','>=','Joomla J-CruiseReservation Standard Component','SQL Injection Vulnerability','Mar 15 2017','Version 3.0','none','No details'),
('com_mostwantedrealestate','component','1.1.0','==','3.0.0','>=','Joomla Most Wanted Real Estate Component','SQL Injection Vulnerability','Mar 15 2017','Version 1.1.0','none','No details'),
('com_googlemaplocator','component','3.0','==','3.0.0','>=','Joomla Google Map Store Locator Component','SQL Injection Vulnerability','Mar 13 2017','Version 3.0','none','No details'),
('com_docmanpaypal','component','3.1','==','3.0.0','>=','Joomla PayPal IPN for DOCman Component','SQL Injection Vulnerability','Mar 13 2017','Version 3.1','none','No details'),
('com_eventix','component','1.0','==','3.0.0','>=','Joomla Eventix Events Calendar Component','SQL Injection Vulnerability','Mar 13 2017','Version 1.0','none','No details'),
('com_magicdealsweb','component','1.2.0','==','3.0.0','>=','Joomla Magic Deals Web Component','SQL Injection Vulnerability','Mar 13 2017','Version 1.2.0','none','No details'),
('com_multitier','component','3.1','==','3.0.0','>=','Joomla Multitier Component','SQL Injection Vulnerability','Mar 08 2017','Version 3.1','none','No details'),
('com_userextranet','component','1.3.1','==','3.0.0','>=','Joomla UserExtranet Component','SQL Injection Vulnerability','Mar 08 2017','Version 1.3.1','none','No details'),
('com_guesser','component','1.0.4','==','3.0.0','>=','Joomla Guesser Component','SQL Injection Vulnerability','Mar 06 2017','Version 1.0.4','none','No details'),
('com_recipe','component','2.2','==','3.0.0','>=','Joomla Recipe Manager Component','SQL Injection Vulnerability','Mar 06 2017','Version 2.2','none','No details'),
('com_abstract','component','2.1','==','3.0.0','>=','Joomla Abstract Manager Component','SQL Injection Vulnerability','Mar 06 2017','Version 2.1','none','No details'),
('com_k2ajaxsearch','component','2.2','==','3.0.0','>=','Joomla AJAX Search for K2 Component','SQL Injection Vulnerability','Mar 06 2017','Version 2.2','none','No details'),
('com_jegridfolio','component','---','==','3.0.0','>=','Joomla JE Grid Folio Component','SQL Injection Vulnerability','Feb 20 2017','Version not specified','none','No details'),
('com_jepropertyfinder','component','1.6.3','==','3.0.0','>=','Joomla Property Finder Component','SQL Injection Vulnerability','Feb 20 2017','Version 1.6.3','none','No details'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! Information disclosure','Inadequate filtering','Apr 25 2017','Joomla! versions 1.5.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! XSS vulnerability','Mail sent using the JMail API leaked','Apr 25 2017','Joomla! versions 3.2.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! XSS vulnerability','Inadequate filtering','Apr 25 2017','Joomla! versions 3.2.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! XSS vulnerability','Inadequate filtering','Apr 25 2017','Joomla! versions 1.5.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! XSS vulnerability','Inadequate escaping','Apr 25 2017','Joomla! versions 3.2.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! ACL violation','Inadequate filtering','Apr 25 2017','Joomla! versions 1.6.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! ACL violation','Inadequate mime type checks','Apr 25 2017','Joomla! versions 3.2.0 through 3.6.5','update','3.7.0'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! Information disclosures','Multiple files caused full path disclosures','Apr 25 2017','Joomla! versions 3.4.0 through 3.6.5','update','3.7.0'),
('com_jdbexport','component','3.2.10','==','3.0.0','>=','Joomla jDBexport Component','Cross Site Scripting/Path Disclosure Vulnerabilities','Apr 28 2017','Version 3.2.10','none','No details'),
('com_myportfolio','component','3.0.2','==','3.0.0','>=','Joomla MyPortfolio Component','SQL Injection Vulnerability','Apr 28 2017','Version 3.0.2','none','No details'),
('com_jgrid','component','4.44','==','3.0.0','>=','Joomla JGrid Component','SQL Injection Vulnerability','May 02 2017','Version 4.44','none','No details'),
('Joomla!','core','3.7.0','==','3.0.0','>=','Joomla! SQL Injection Vulnerability','Inadequate filtering','May 17 2017','Joomla! versions 3.7.0','update','3.7.1'),
('com_videoflow','component','1.2.0','==','3.0.0','>=','Joomla VideoFlow Component','SQL Injection Vulnerability','May 24 2017','Version 1.2.0','none','No details'),
('com_kunena','component','5.0.9','<','3.0.0','>=','Joomla Kunena Component','Cross Site scripting Vulnerability','May 24 2017','Version 4.0.0 through 5.0.8','update','5.0.9'),
('com_payage','component','2.0.6','<','3.0.0','>=','Joomla Payage Component','SQL Injection Vulnerability','Jun 22 2017','Version 2.0.5 and lower','update','2.0.6'),
('com_hikashop','component','3.1.0','==','3.0.0','>=','Joomla Hikashop Business Component','SQL Injection Vulnerability','Jun 22 2017','Version 3.1.0','update','3.1.1'),
('Joomla!','core','3.7.2','<=','3.0.0','>=','Joomla! Information disclosure Vulnerability','Inadequate filtering','Jul 04 2017','versions 1.7.3-3.7.2','update','3.7.3'),
('Joomla!','core','3.7.2','<=','3.0.0','>=','Joomla! XSS Vulnerability','Missing CSRF token checks and improper input validation','Jul 04 2017','versions 1.7.3-3.7.2','update','3.7.3'),
('Joomla!','core','3.6.5','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering of multibyte characters','Jul 04 2017','versions 1.5.0 through 3.6.5','update','3.7.3'),
('Joomla!','core','3.7.3','<=','3.0.0','>=','Joomla! core','Lack of Ownership Verification','Jul 25 2017','versions 1.0.0 through 3.7.3','update','3.7.4'),
('Joomla!','core','3.7.3','<=','3.0.0','>=','Joomla! XSS Vulnerability','Inadequate filtering of potentially malicious HTML tags','Jul 25 2017','versions 1.5.0 through 3.7.3','update','3.7.4'),
('com_ccnewsletter','component','2.1.9','==','3.0.0','>=','CCNewsLetter Component','SQL Injection Vulnerability','Aug 01 2017','Version 2.1.9','none','No details'),
('com_extplorer','component','2.1.9','<=','3.0.0','>=','Extplorer Component','Directory Transversal Vulnerability','Aug 04 2017','Version 2.1.9 and previous','none','No details'),
('com_calendarplanner','component','1.0.1','==','3.0.0','>=','Calendar Planner Component','SQL Injection Vulnerability','Aug 24 2017','Version 1.0.1','update','1.0.2'),
('mod_byebyepassword','module','1.0.4','<=','3.0.0','>=','Bye bye Password Module','Information Disclosure Vulnerability','Aug 24 2017','Version 1.0.4 and lower','none','No details'),
('com_zcalendar','component','4.3.6','<=','3.0.0','>=','Zcalendar Component','SQL Injection Vulnerability','Aug 26 2017','Version 4.3.6 and lower','update','4.3.7'),
('com_ccnewsletter','component','2.1.9','<=','3.0.0','>=','Ccnewsletter Component','SQL Injection Vulnerability','Aug 26 2017','Version 2.1.9 and lower','update','2.2.0'),
('com_lmsking','component','3.2.3.19','<=','3.0.0','>=','LMS King Component','SQL Injection Vulnerability','Aug 30 2017','Version 3.2.319 and lower','update','3.2.3.20'),
('com_twitchtv','component','1.1','==','3.0.0','>=','Twitch tv Component','SQL Injection Vulnerability','Aug 30 2017','Version 1.1','none','No details'),
('com_kissgallery','component','1.0.0','==','3.0.0','>=','Kissgallery Component','SQL Injection Vulnerability','Aug 30 2017','Version 1.0.0','none','No details'),
('com_registrationpro','component','4.1.3','==','3.0.0','>=','Event Registration Pro Component','SQL Injection Vulnerability','Sep 07 2017','Version 4.1.3','none','No details'),
('com_rpl','component','1.0.0','>=','3.0.0','>=','Realtyna RPL Component','SQL Injection Vulnerability','Sep 07 2017','All versions','none','No details'),
('com_simgenealogy','component','2.1.8','<','3.0.0','>=','Simgenealogy Component','SQL Injection Vulnerability','Sep 10 2017','Version 2.1.7 and previous','update','2.1.8'),
('com_payplans','component','3.6.3','<','3.0.0','>=','Payplans Component','Price modification Vulnerability','Sep 13 2017','Version 3.6.2 and previous','update','3.6.3'),
('com_joomanager','component','2.0.0','<=','3.0.0','>=','Joomanager Component','Arbitrary File Download Vulnerability','Sep 14 2017','2.0.0 and previous','none','No details'),
('Joomla!','core','3.7.5','<=','3.0.0','>=','Joomla! Information disclosures','Bug in SQL query','Sep 19 2017','Joomla! versions 3.7.0 through 3.7.5','update','3.8.0'),
('Joomla!','core','3.7.5','<=','3.0.0','>=','Joomla! LDAP Information disclosures','Inadequate escaping in LDAP autenthication plugin','Sep 19 2017','Joomla! versions 1.5.0 through 3.7.5','update','3.8.0'),
('com_userextranet','component','1.3.2','<=','3.0.0','>=','UserExtranet Component','SQL Injection Vulnerability','Sep 21 2017','1.3.2 and previous','update','1.3.3'),
('com_surveyforce','component','3.2.4','==','3.0.0','>=','Survey Force Deluxe Component','SQL Injection Vulnerability','Sep 21 2017','3.2.4','update','3.2.5'),
('com_spmoviedb','component','1.3','==','3.0.0','>=','SP Movie Database Component','SQL Injection Vulnerability','Sep 22 2017','1.3','update','1.4'),
('com_ns_downloadshop','component','2.2.6','==','3.0.0','>=','NS Download Shop Component','SQL Injection Vulnerability','Oct 01 2017','Version 2.2.6','none','No details'),
('com_zhyandexmap','component','6.1.1.0','==','3.0.0','>=','Zh YandexMap Component','SQL Injection Vulnerability','Oct 01 2017','Version 6.1.1.0','update','6.2.0.0'),
('com_price_alert','component','3.0.4','<=','3.0.0','>=','Price Alert for Virtuemart Component','SQL Injection Vulnerability','Oct 18 2017','Version 3.0.4 and previous','none','No details'),
('com_ajaxquiz','component','1.8.0','==','3.0.0','>=','Ajax Quiz Component','SQL Injection Vulnerability','Oct 18 2017','Version 1.8.0','none','No details'),
('plugin_googlemap3','plugin','3.5.2','<=','3.0.0','>=','Google Maps by Reumer','Malicious update','Oct 21 2017','Version 3.5','update','3.5.2'),
('com_hdwplayer','component','4.0.0','<=','3.0.0','>=','HDW Player Component','RCE Vulnerability','Oct 26 2017','Version 4.0.0 and all previous','none','No details'),
('com_jsjobs','component','1.1.8','==','3.0.0','>=','Js Jobs Component','RCE Vulnerability','Oct 26 2017','Version 1.1.8','update','1.1.9'),
('Joomla!','core','3.8.1','<=','3.0.0','>=','Joomla! LDAP Information Disclosure','Inadequate escaping in the LDAP authentication plugin','Nov 07 2017','Joomla! versions 1.5.0 through 3.8.1','update','3.8.2'),
('Joomla!','core','3.8.1','<=','3.0.0','>=','Joomla! 2-factor-authentication bypass vulnerability','---','Nov 07 2017','Joomla! versions 3.2.0 through 3.8.1','update','3.8.2'),
('Joomla!','core','3.8.1','<=','3.0.0','>=','Joomla! Information Disclosure vulnerability','logic bug in com_fields','Nov 07 2017','Joomla! versions 3.7.0 through 3.8.1','update','3.8.2'),
('com_virtuemart','component','3.2.4','==','3.0.0','>=','Virtuemart Component','XSS Vulnerability','Dec 04 2017','Version 3.2.4','update','3.2.6'),
('com_jbuildozer','component','1.4.1','==','3.0.0','>=','JBuildozer Component','SQL Injection Vulnerability','Dec 20 2017','Version 1.4.1','none','No details'),
('com_jevideogallery','component','3.0.5','==','3.0.0','>=','JEXTN Video Gallery Component','SQL Injection Vulnerability','Dec 20 2017','Version 3.0.5','none','No details'),
('com_nge','component','2.1.0','==','3.0.0','>=','NextGen Editor Component','SQL Injection Vulnerability','Dec 20 2017','Version 2.1.0','none','No details'),
('com_bigfileuploader','component','1.0.2','==','3.0.0','>=','Big File uploader Editor Component','File upload Vulnerability','Dec 20 2017','Version 1.0.2','none','No details'),
('com_bookpro','component','1.0','==','3.0.0','>=','JB Visa Component','SQL Injection Vulnerability','Jan 06 2018','Version 1.0','none','No details'),
('com_b2jcontact','component','2.1.14','<=','3.0.0','>=','B2j Contact Component','Several Vulnerabilities','Dec 20 2017','Version 2.1.14 and lower','update','2.1.15'),
('com_myproject','component','2.0','==','3.0.0','>=','My Projects Component','SQL Injection Vulnerability','Dec 20 2017','Version 2.0','update','2.1'),
('com_userbench','component','1.0','==','3.0.0','>=','User Bench Component','SQL Injection Vulnerability','Jan 01 2018','Version 1.0','update','1.1'),
('com_easydiscuss','component','4.0.20','<=','3.0.0','>=','Easy Discuss Component','XSS Vulnerability','Jan 08 2018','Version 4.0.20 and previous','update','4.0.21'),
('com_guru','component','5.0.15','<=','3.0.0','>=','Guru Pro Component','SQL Injection Vulnerability','Jan 08 2018','Version 5.0.15 and previous','update','5.0.16'),
('com_ajaxquiz','component','2.0','<=','3.0.0','>=','Ajax Quiz Component','SQL Injection Vulnerability','Jan 09 2018','Version 2.0 and lower','update','2.1'),
('com_enmasse','component','1.0','>=','3.0.0','>=','En Masse Component','SQL Injection Vulnerability','Jan 15 2018','all known versions','none','No details'),
('com_simplephotogallery','component','3.5.0','<=','3.0.0','>=','Simple Image Gallery (free) Component','XSS Vulnerability','Jan 30 2018','Version 3.5.0 and previous','update','3.6.0'),
('com_jtagmembersdirectory','component','5.3.7','==','3.0.0','>=','Jtag Members Directory Component','Arbitrary file upload Vulnerability','Jan 30 2018','Version 5.3.7','none','No details'),
('com_jssupportticket','component','1.1.0','==','3.0.0','>=','JS Support Ticket Component','Cross site request forgery Vulnerability','Jan 30 2018','Version 1.1.0','none','No details'),
('Joomla!','core','3.8.3','<=','3.0.0','>=','Joomla! XSS vulnerability','Lack of escaping in module chromes','Jan 30 2018','Joomla! versions 3.0.0 through 3.8.3','update','3.8.4'),
('Joomla!','core','3.8.3','<=','3.0.0','>=','Joomla! XSS vulnerability','Inadequate input filtering in com_fields','Jan 30 2018','Joomla! versions 3.7.0 through 3.8.3','update','3.8.4'),
('Joomla!','core','3.8.3','<=','3.0.0','>=','Joomla! XSS vulnerability','Inadequate input filtering in Uri class','Jan 30 2018','Joomla! versions 1.5.0 through 3.8.3','update','3.8.4'),
('Joomla!','core','3.8.3','<=','3.0.0','>=','Joomla! SQL Injection vulnerability','Lack of type casting in SQL statement','Jan 30 2018','Joomla! versions 3.7.0 through 3.8.3','update','3.8.4'),
('com_jce','component','2.5.25','==','3.0.0','>=','JCE Editor Component','Cross site scripting Vulnerability','Feb 02 2018','Version 2.5.25','update','2.5.26'),
('com_jssupportticket','component','1.1.0','==','3.0.0','>=','JS Support Ticket Component','Cross site scripting Vulnerability','Feb 21 2018','Version 1.1.0','update','1.1.1'),
('com_jsjobs','component','1.1.9','<=','3.0.0','>=','JS Jobs Component','SQL Injection Vulnerability','Feb 21 2018','Version 1.1.9 and previous','update','1.2.0'),
('com_ccnewsletter','component','2.2.2','<=','3.0.0','>=','ccnewsletter Component','SQL Injection Vulnerability','Feb 21 2018','Version 2.2.2 and previous','update','2.2.3'),
('com_jimtawl','component','2.2.6','==','3.0.0','>=','Jimtawl Component','Arbitrary File upload Vulnerability','Feb 23 2018','Version 2.2.6','update','2.2.7'),
('com_zhgooglemap','component','8.4.0.0','<=','3.0.0','>=','ZH GoogleMap Component','Sql Injection Vulnerability','Feb 23 2018','Version 8.4.0.0 and previous','update','8.4.1.0'),
('com_zhyandexmap','component','6.2.1.0','<=','3.0.0','>=','ZH YandexMap Component','Sql Injection Vulnerability','Feb 23 2018','Version 6.2.1.0 and previous','update','6.3.1.0'),
('com_zhbaidumap','component','3.0.0.1','<=','3.0.0','>=','ZH BaiduMap Component','Sql Injection Vulnerability','Feb 23 2018','Version 3.0.0.1 and previous','update','3.0.1.0'),
('com_jsptickets','component','1.1','<=','3.0.0','>=','JSP Tickets Component','Sql Injection Vulnerability','Feb 23 2018','Version 1.1 and previous','update','1.2'),
('com_solidres','component','2.5','<=','3.0.0','>=','Solidres Component','Sql Injection Vulnerability','Feb 25 2018','Version 2.5 and previous','update','2.5.1'),
('com_timetable','component','1.6','<=','3.0.0','>=','Timetable Responsive Schedule Component','Sql Injection Vulnerability','Feb 25 2018','Version 1.6 and previous','update','1.7'),
('com_jsplocation','component','2.4','<=','3.0.0','>=','JSP Store Locator Component','Sql Injection Vulnerability','Feb 25 2018','Version 2.4 and previous','update','2.5'),
('com_smartshoutbox','component','2.9.5','<=','3.0.0','>=','Smart Shoutbox Component','Sql Injection Vulnerability','Feb 25 2018','Version 2.9.5 and previous','update','3.0.0'),
('plg_sige','plugin','3.2.3','<=','3.0.0','>=','Kubik-Rubik Simple Image Gallery Extended Plugin','Cross site scripting Vulnerability','Feb 26 2018','Version 3.2.3 and previous','update','3.3.0'),
('com_saxumastro','component','4.0.14','<=','3.0.0','>=','Saxum Astro Component','Sql Injection Vulnerability','Feb 26 2018','Version 4.0.14 and previous','none','No details'),
('com_saxumnumerology','component','3.0.4','<=','3.0.0','>=','Saxum Numerology Component','Sql Injection Vulnerability','Feb 26 2018','Version 3.0.4 and previous','none','No details'),
('com_saxumpicker','component','3.2.10','<=','3.0.0','>=','Saxum Picker Component','Sql Injection Vulnerability','Feb 26 2018','Version 3.2.10 and previous','none','No details'),
('com_biblestudy','component','9.1.1','<=','3.0.0','>=','Proclaim Component','Arbitrary file upload Vulnerability','Feb 27 2018','Version 9.1.1 and previous','update','9.1.2'),
('com_socialpinboard','component','2.0','==','3.0.0','>=','Joomla! Pinterest Clone Social Pinboard Component','Sql Injection Vulnerability','Feb 28 2018','Version 2.0','none','No details'),
('com_osproperty','component','3.12.8','<=','3.0.0','>=','OS Property Component','Sql Injection Vulnerability','Feb 28 2018','Version 3.12.8 and previous','update','3.12.9'),
('com_realpin','component','1.5.04','<=','3.0.0','>=','Realpin Component','Sql Injection Vulnerability','Mar 01 2018','Version 1.5.04 and previous','none','No details'),
('com_media_library','component','4.0.12','<=','3.0.0','>=','Media Library Free Component','Sql Injection Vulnerability','Mar 01 2018','Version 4.0.12 and previous','none','No details'),
('com_jsautoz','component','1.0.9','<=','3.0.0','>=','JS Autoz Component','Sql Injection Vulnerability','Mar 03 2018','Version 1.0.9 and previous','none','No details'),
('com_jticketing','component','2.0.16','<=','3.0.0','>=','Jticketing Component','Sql Injection Vulnerability','Mar 03 2018','Version 2.0.16 and previous','update','2.0.18'),
('com_invitex','component','3.0.5','<=','3.0.0','>=','InviteX Component','Sql Injection Vulnerability','Mar 03 2018','Version 3.0.5 and previous','update','3.0.6'),
('com_abook','component','3.1.3','<=','3.0.0','>=','Alexandria Book Library Component','Sql Injection Vulnerability','Mar 05 2018','Version 3.1.3 and previous','none','No details'),
('com_jmsmusic','component','1.1.1','<=','3.0.0','>=','JM Music Component','Sql Injection Vulnerability','Mar 05 2018','Version 1.1.1 and previous','none','No details'),
('com_formmaker','component','3.6.14','<=','3.0.0','>=','Form Maker Component','Sql Injection Vulnerability','Mar 05 2018','Version 3.6.14 and previous','update','3.6.15'),
('com_jgive','component','2.0.9','<=','3.0.0','>=','JGive Component','Sql Injection Vulnerability','Mar 05 2018','Version 2.0.9 and previous','update','2.0.11'),
('com_ekrishta','component','2.9','<=','3.0.0','>=','Ek Rishta Component','Sql Injection Vulnerability','Mar 07 2018','Version 2.9 and previous','none','No details'),
('com_prayercenter','component','3.0.2','<=','3.0.0','>=','PrayerCenter Component','Sql Injection Vulnerability','Mar 07 2018','Version 3.0.2 and previous','none','No details'),
('com_cwtags','component','2.0.8','<=','3.0.0','>=','CW Tags Component','Sql Injection Vulnerability','Mar 07 2018','Version 2.0.8 and previous','none','No details'),
('com_squadmanagement','component','1.0.3','<=','3.0.0','>=','SquadManagement Component','Sql Injection Vulnerability','Mar 07 2018','Version 1.0.3 and previous','none','No details'),
('com_neorecruit','component','4.2.1','<=','3.0.0','>=','NeoRecruit Component','Sql Injection Vulnerability','Mar 07 2018','Version 4.2.1 and previous','update','4.2.2'),
('com_checklist','component','1.1.1.003','<=','3.0.0','>=','Checklist Component','Sql Injection Vulnerability','Mar 07 2018','Version 1.1.1.003 and previous','update','1.1.1.004'),
('com_simplecalendar','component','3.1.9','<=','3.0.0','>=','Simple Calendar Component','Sql Injection Vulnerability','Mar 08 2018','Version 3.1.9 and previous','none','No details'),
('com_bookpro','component','2.3','==','3.0.0','>=','JB Bus Component','Sql Injection Vulnerability','Mar 08 2018','Version 2.3','none','No details'),
('com_dtracker','component','3.0','==','3.0.0','>=','File Download Tracker Component','Sql Injection Vulnerability','Mar 08 2018','Version 3.0','none','No details'),
('com_jquickcontact','component','1.3.2.3','<=','3.0.0','>=','JQuickContact Component','Sql Injection Vulnerability','Mar 08 2018','Version 1.3.2.3 and previous','update','1.3.2.4'),
('com_fastball','component','10.0.0','<=','3.0.0','>=','Fastball Component','Sql Injection Vulnerability','Mar 08 2018','All versions','none','No details'),
('com_dtregister','component','3.2.7','<=','3.0.0','>=','DT REgister Component','Sql Injection Vulnerability','Mar 08 2018','Version 3.2.7 and previous','none','No details'),
('com_jomestate','component','3.7','<=','3.0.0','>=','JomEstate Component','Sql Injection Vulnerability','Mar 13 2018','Version 3.7 and previous','update','3.8'),
('Joomla!','core','3.8.5','<=','3.0.0','>=','Joomla! Sql Injection vulnerability','Lack of type casting of a variable in SQL statement of user Notes','Mar 13 2018','Joomla!  versions 3.5.0 through 3.8.5','update','3.8.6'),
('com_kunena','component','5.0.13','<=','3.0.0','>=','Kunena Component','Other Vulnerability','Mar 14 2018','Version 5.0.13 and previous','update','5.0.14'),
('com_gmap','component','4.2.3','<=','3.0.0','>=','Google Map Landkarten Component','Sql Injection Vulnerability','Mar 20 2018','Version 4.2.3 and previous','none','No details'),
('com_attachments','component','3.2.5','<=','3.0.0','>=','Attachments Component','Sql Injection Vulnerability','Mar 20 2018','Version 3.2.5 and previous','none','No details'),
('com_visualcalendar','component','3.1.5','<=','3.0.0','>=','Visual Calendar Component','Sql Injection Vulnerability','Mar 20 2018','Version 3.1.5 and previous','update','3.1.6'),
('com_cpeventcalendar','component','3.0.2','<=','3.0.0','>=','CP Event Calendar Component','Sql Injection Vulnerability','Mar 26 2018','Version 3.0.2 and previous','update','3.0.3'),
('com_acymailing','component','5.9.5','<=','3.0.0','>=','Acymailing Component','Csv Injection Vulnerability','Mar 26 2018','Version 5.9.5 and previous','update','5.9.5'),
('com_acysms','component','3.5.0','<=','3.0.0','>=','Acysms Component','Csv Injection Vulnerability','Mar 29 2018','Version 3.5.0 and previous','update','3.5.1'),
('com_jsjobs','component','1.2.0','<=','3.0.0','>=','Js Jobs Component','Cross site scripting Vulnerability','Mar 31 2018','Version 1.2.0 and previous','update','1.2.1'),
('com_prayercenter','component','3.0.2','<=','3.0.0','>=','Prayercenter Component','Sql injection Vulnerability','Mar 31 2018','Version 3.0.2 and previous','update','3.0.3'),
('com_virtuemart','component','3.2.12','<=','3.0.0','>=','Virtuemart Component','Cross site scripting Vulnerability','Apr 07 2018','Version 3.2.12 and previous','update','3.2.14'),
('com_gridbox','component','2.4.0','<=','3.0.0','>=','Gridbox Component','Multiple Vulnerabilities','Apr 10 2018','Version 2.4.0 and previous','none','No details'),
('com_jdownloads','component','3.2.58','<=','3.0.0','>=','JDownloads Component','Cross site scripting Vulnerability','Apr 10 2018','Version 3.2.58 and previous','update','3.2.59'),
('com_cwtags','component','2.0.8','<=','3.0.0','>=','CW Tags Component','Sql injection Vulnerability','Apr 10 2018','Version 2.0.8 and previous','update','2.1.1'),
('com_convertforms','component','2.0.3','<=','3.0.0','>=','Convert Forms Component','Csv Injection Vulnerability','Apr 13 2018','Version 2.0.3 and previous','update','2.0.4'),
('com_nexevocontact','component','1.0.1','<=','3.0.0','>=','Nexevo contact form Component','Backdoor Vulnerability','May 15 2018','Version 1.0.1 and previous','none','No details'),
('Joomla!','core','3.8.7','<=','3.0.0','>=','Joomla! multiple vulnerabilities','9 security vulnerabilities','May 22 2018','Joomla!  versions 1.5.0 through 3.8.7','update','3.8.8'),
('com_ekrishta','component','2.10','==','3.0.0','>=','EkRishta Component','Sql injection Vulnerability','Jun 13 2018','Version 2.10','none','No details'),
('com_cb','component','2.1.4','<=','3.0.0','>=','Community Builder Component','XSS Vulnerability','Jun 14 2018','Version 2.1.4 and previous','update','2.1.5'),
('com_jomres','component','9.11.2','==','3.0.0','>=','Jomres Component','CSRF Vulnerability','Jun 19 2018','Version 9.11.2','none','No details'),
('Joomla!','core','3.8.8','<=','3.0.0','>=','Joomla! multiple vulnerabilities','2 security vulnerabilities','Jun 26 2018','Joomla! versions 1.5.0 through 3.8.8','update','3.8.9'),
('com_medialibrary','component','4.0.12','<=','3.0.0','>=','MediaLibrary Free Component','SQL Injection Vulnerability','Jul 06 2018','Version 4.0.12 and previous','update','4.0.21'),
('com_advertisementboard','component','3.1.0','<=','3.0.0','>=','Advertisement Board Component','SQL Injection Vulnerability','Jul 06 2018','Version 3.1.0 and previous','update','3.4.1'),
('com_kunena','component','5.1.1','<=','3.0.0','>=','Kunena Component','Attachments Vulnerability','Jul 16 2018','Version 5.0.0 through 5.1.1','update','5.1.2'),
('com_jbusinessdirectory','component','4.9.3','<=','3.0.0','>=','J-Business Directory Component','SQL Injection Vulnerability','Aug 12 2018','Version 4.9.3 and previous','update','4.9.4'),
('com_jcomments','component','3.0.5','<=','3.0.0','>=','JComments Component','Input Validation Vulnerability','Aug 17 2018','Version 3.0.5 and previous','update','3.0.6'),
('com_mobile','component','2.1.24','==','3.0.0','>=','Mobilejoomla Component','Malicious redirects Vulnerability','Aug 17 2018','Version 2.1.24','update','2.1.25'),
('Joomla!','core','3.8.11','<=','3.0.0','>=','Joomla! multiple vulnerabilities','3 security vulnerabilities','Aug 28 2018','Joomla! versions 1.5.0 through 3.8.11','update','3.8.12'),
('com_virtuemart_magiczoomplus','component','4.9.4','<=','3.0.0','>=','Magiczoomplus for Virtuemart Component','Multiple Vulnerabilities','Sep 17 2018','Version 4.9.4 and previous','update','4.9.6'),
('com_magiczoomplus','component','3.3.4','<=','3.0.0','>=','Magiczoomplus for Joomla Component','Multiple Vulnerabilities','Sep 17 2018','Version 3.3.4 and previous','update','3.3.6'),
('com_timetableschedule','component','3.6.8','==','3.0.0','>=','Timetable Schedule Component','SQL Injection vulnerability','Oct 01 2018','Version 3.6.8','none','No details'),
('com_articleman','component','4.3.9','==','3.0.0','>=','Article Factory Manager Component','SQL Injection vulnerability','Oct 01 2018','Version 4.3.9','none','No details'),
('com_aindexdictionaries','component','1.0','==','3.0.0','>=','AlphaIndex Dictionaries Component','SQL Injection vulnerability','Oct 01 2018','Version 1.0','none','No details'),
('com_rbids','component','4.3.8','==','3.0.0','>=','Reverse Auction Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 4.3.8','none','No details'),
('com_collectionfactory','component','4.1.9','==','3.0.0','>=','Collection Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 4.1.9','none','No details'),
('com_swapfactory','component','2.2.1','==','3.0.0','>=','Swap Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 2.2.1','none','No details'),
('com_extroform','component','2.1.5','==','3.0.0','>=','eXtroForms Component','SQL Injection vulnerability','Oct 01 2018','Version 2.1.5','none','No details'),
('com_dutchfactory','component','2.0.2','==','3.0.0','>=','Dutch Auction Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 2.0.2','none','No details'),
('com_socialfactory','component','3.8.3','==','3.0.0','>=','Social Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 3.8.3','none','No details'),
('com_jobsfactory','component','2.0.4','==','3.0.0','>=','Jobs Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 2.0.4','none','No details'),
('com_questions','component','1.4.3','==','3.0.0','>=','Questions Component','SQL Injection vulnerability','Oct 01 2018','Version 1.4.3','none','No details'),
('com_pennyfactory','component','2.0.4','==','3.0.0','>=','Penny Auction Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 2.0.4','none','No details'),
('com_rafflefactory','component','3.5.2','==','3.0.0','>=','Raffle Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 3.5.2','none','No details'),
('com_pofos','component','1.6.1','==','3.0.0','>=','Responsive Portfolio Component','SQL Injection vulnerability','Oct 01 2018','Version 1.6.1','none','No details'),
('com_auctionfactory','component','4.5.5','==','3.0.0','>=','Auction Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 4.5.5','none','No details'),
('com_microdealfactory','component','2.0.4','==','3.0.0','>=','Micro Deal Factory Component','SQL Injection vulnerability','Oct 01 2018','Version 2.0.4','none','No details'),
('jckeditor','plugin','6.4.4','==','3.0.0','>=','JCK Editor Plugin','SQL Injection vulnerability','Oct 01 2018','Version 6.4.4','none','No details'),
('cwattachments','plugin','1.0.6','==','3.0.0','>=','CW Article Attachments Plugin','SQL Injection vulnerability','Oct 01 2018','Version 1.0.6','none','No details'),
('Joomla!','core','3.8.12','<=','3.0.0','>=','Joomla! multiple vulnerabilities','4 security vulnerabilities','Oct 09 2018','Joomla! versions 1.5.0 through 3.8.12','update','3.8.13'),
('com_kunena','component','5.1.5','<','3.0.0','>=','Kunena Component','Two low vulnerabilities','Oct 22 2018','Version 3.0 through 5.1.4','update','5.1.5'),
('com_jimtawl','component','2.2.7','==','3.0.0','>=','Jimtawl Component','Sql Injection vulnerabilitiy','Nov 18 2018','Version 2.2.7','update','2.2.8'),
('com_kunena','component','5.1.7','<','3.0.0','>=','Kunena Component','Xss vulnerability','Nov 21 2018','Version 5.1.6 and lower','update','5.1.7'),
('com_jephotogallery','component','1.1','==','3.0.0','>=','JE Photo Gallery Component','Sql Injection vulnerabilitiy','Dec 04 2018','Version 1.1','none','No details'),
('com_muscol','component','3.0.3','<=','3.0.0','>=','Music collection Component','Sql Injection vulnerabilitiy','Dec 04 2018','Version 3.0.3','update','3.0.6'),
('com_jomres','component','9.14.0','<=','3.0.0','>=','Joomres Component','Third party vulnerabilitiy','Dec 07 2018','Version 9.14.0 and lower','update','9.15.0'),
('com_kunena','component','5.1.7','<=','3.0.0','>=','Kunena Component','Tree XSS vulnerabilities','Jan 03 2019','Version 5.1.7 and lower','update','5.1.8'),
('com_joomcrm','component','1.1.1','==','3.0.0','>=','JoomCRM Component Component','Sql Injection vulnerabilitiy','Jan 15 2019','Version 1.1.0','update','1.1.2'),
('com_jpprojects','component','1.1.3.2','==','3.0.0','>=','JoomProject Component','Information Disclosure vulnerabilitiy','Jan 15 2019','Version 1.1.3.2','update','1.1.3.3'),
('mod_jw_srfr','module','3.5.0','<=','3.0.0','>=','Simple RSS Feed Reader Module','Open Redirect vulnerability','Jan 15 2019','Version 3.6.0','none','No details'),
('Joomla!','core','3.9.1','<=','3.0.0','>=','Joomla! multiple vulnerabilities','4 low vulnerabilities','Jan 15 2019','Joomla 2.5.0 through 3.9.1','update','3.9.2'),
('com_jcruisereservation','component','6.0.2','==','3.0.0','>=','J-CruiseReservation Component','Sql Injection vulnerability','Jan 21 2019','Version 6.0.2','update','6.0.4'),
('com_easyshop','component','1.2.3','==','3.0.0','>=','EasyShop Component','Local file inclusion vulnerability','Feb 04 2019','Version 1.2.3','update','1.2.4'),
('Joomla!','core','3.9.2','<=','3.0.0','>=','Joomla! multiple vulnerabilities','6 low vulnerabilities','Feb 12 2019','Joomla 2.5.0 through 3.9.2','update','3.9.3'),
('com_edocman','component','1.11.7','==','3.0.0','>=','Edocman Component','Sql Injection vulnerability','Feb 23 2019','Version 1.11.7','update','1.11.8'),
('com_kunena','component','5.1.10','<','3.0.0','>=','Kunena Component','XSS vulnerabilities','Mar 05 2019','Version 5.1.0 through 5.1.10','update','5.1.10'),
('Joomla!','core','3.9.3','<=','3.0.0','>=','Joomla! multiple vulnerabilities','3 low vulnerabilities and one high vulnerability','Mar 13 2019','Joomla 3.0.0 through 3.9.3','update','3.9.4'),
('com_jevents','component','3.4.50','<','3.0.0','>=','JEvents Component','Multiple vulnerabilities','Mar 17 2019','Version 3.4.49 and maybe lower','update','3.4.50'),
('com_acymailing','component','5.10.6','==','3.0.0','>=','Acymailing Component','Multiple vulnerabilities','Mar 26 2019','Version 5.10.6','update','5.10.7'),
('Joomla!','core','3.9.4','<=','3.0.0','>=','Joomla! multiple vulnerabilities','one moderate, one low and one high vulnerabilities','Apr 09 2019','Joomla 3.0.0 through 3.9.4','update','3.9.5'),
('com_bookpro','component','2.3','==','3.0.0','>=','JB Bus Component','SQL Injection vulnerability','Apr 12 2019','Version 2.3','update','2.4'),
('com_kunena','component','5.1.12','<','3.0.0','>=','Kunena Component','XSS vulnerability','Apr 23 2019','Version 5.1.3 through 5.1.12','update','5.1.12.1'),
('com_phocagallery','component','4.3.17','<','3.0.0','>=','Phoca Gallery Component','XSS vulnerability','Apr 26 2019','Version 4.3.15 prior','update','4.3.17'),
('Joomla!','core','3.9.5','<=','3.0.0','>=','Joomla! core','Xss vulnerability','May 072019','Joomla 1.7.0 through 3.9.5','update','3.9.6'),
('com_rsform','component','2.2.0','==','3.0.0','>=','RSForm! Pro Component','Csv injection vulnerability','May 13 2019','Version 2.2.0','update','2.2.1'),
('com_rsmembership','component','1.22.10','<=','3.0.0','>=','RSMembership! Component','Csv injection vulnerability','May 13 2019','Version 1.22.10 and lower','update','1.22.11'),
('com_rsevents','component','2.2.0','<=','3.0.0','>=','RSEvents! Pro Component','Csv injection vulnerability','May 13 2019','Version 2.2.0 and lower','update','2.2.1'),
('com_oziogallery','component','5.0.1','==','3.0.0','>=','Oziogallery Component','Xss vulnerability','May 14 2019','Version 5.0.1','update','5.0.2'),
('com_loginguard','component','3.1.1','<=','3.0.0','>=','Akeeba LoginGuard Component','Information disclosure vulnerability','May 18 2019','Version 3.1.1 and lower','update','3.2.0'),
('com_extplorer','component','2.1.12','<=','3.0.0','>=','Extplorer Component','Several vulnerabilities','May 20 2019','Version 2.1.12 and maybe lower','update','2.1.13'),
('com_comprofiler','component','2.4.1','<=','3.0.0','>=','Community Builder Component','jQuery vulnerability','May 22 2019','Version 2.4.1 and lower','update','2.4.2'),
('com_akeeba','component','6.4.2.1','<=','3.0.0','>=','Akeeba Backup Component','Xss vulnerability','Jun 03 2019','Versions 5.3.0.b1 to 6.4.2.1 inclusive','update','6.5.1'),
('Joomla!','core','3.9.6','<=','3.0.0','>=','Joomla! core','Several vulnerabilities','Jun 11 2019','Joomla 3.6.0 through 3.9.6','update','3.9.7'),
('Joomla!','core','3.9.8','<=','3.0.0','>=','Joomla! core','Remote code execution Vulnerability','Jul 09 2019','Joomla 3.9.7 through 3.9.8','update','3.9.9'),
('com_easydiscuss','component','4.1.9','==','3.0.0','>=','Easy discuss Component','Sql injection vulnerability','Aug 09 2019','version 4.1.9','update','4.1.10'),
('Joomla!','core','3.9.10','<=','3.0.0','>=','Joomla! core','Hardening com_contact contact form','Aug 13 2019','Joomla 1.6.2 through 3.9.10','update','3.9.11'),
('com_jssupportticket','component','1.1.5','==','3.0.0','>=','JS support ticket Component','Directory Traversal vulnerability','Aug 13 2019','version 1.1.5','update','1.1.7'),
('com_jssupportticket','component','1.1.6','==','3.0.0','>=','JS support ticket Component','Sql injection vulnerability','Aug 13 2019','version 1.1.6','update','1.1.7'),
('com_kunena','component','5.1.14','<','3.0.0','>=','Kunena Component','XSS vulnerability','Aug 15 2019','Version 5.0.x through 5.1.14','update','5.1.4'),
('com_jdownloads','component','3.2.64','<=','3.0.0','>=','JDownloads Component','Sql injection Vulnerability','Aug 26 2018','Version 3.2.64 and previous','update','3.2.65'),
('com_payplans','component','4.0','==','3.0.0','>=','Payplans Component','Information disclosure Vulnerability','Sep 13 2018','Version 4.0','update','4.0.13'),
('Joomla!','core','3.9.11','<=','3.0.0','>=','Joomla! core','XSS in core logo','Sep 25 2019','Joomla 3.0.0 through 3.9.11','update','3.9.12'),
('com_jsjobs','component','1.2.6','<=','3.0.0','>=','Js Jobs Component','Other Vulnerabilities','Oct 14 2019','Version 1.1.5, 1.1.6, 1.2.5 and 1.2.6','update','1.2.7'),
('Joomla!','core','3.9.12','<=','3.0.0','>=','Joomla! core','Two vulnerabilities','Nov 05 2019','Joomla 3.2.0 through 3.9.12','update','3.9.13'),
('com_j2store','component','3.3.9','<=','3.0.0','>=','J2Store Component','Xss vulnerability','Nov 14 2019','Version 3.3.9 and previous','none','No details'),
('Joomla!','core','3.9.13','<=','3.0.0','>=','Joomla! core','Two vulnerabilities','Dec 18 2019','Joomla 2.5.0 through 3.9.13','update','3.9.14'),
('Joomla!','core','3.9.14','<=','3.0.0','>=','Joomla! core','Three low vulnerabilities','Jan 28 2020','Joomla 3.0.0 through 3.9.14','update','3.9.15'),
('Joomla!','core','3.9.15','<=','3.0.0','>=','Joomla! core','Six low vulnerabilities','Mar 10 2020','Joomla 1.7.0 through 3.9.15','update','3.9.16'),
('com_simplecalendar','component','3.1.9','<=','3.0.0','>=','Simple Calendar Component','Sql injection Vulnerability','Mar 24 2020','Version 3.1.9 and lower','update','3.2.1'),
('com_acym','component','6.9.2','<','3.0.0','>=','Acymailing 6 Component','File upload Vulnerability','Mar 24 2020','Version 6','update','6.9.2'),
('com_gmapfp','component','3.30','==','3.0.0','>=','GMapFP Component','Other Vulnerability','Apr 14 2020','Version 3.30','update','3.52'),
('Joomla!','core','3.9.16','<=','3.0.0','>=','Joomla! core','Three low vulnerabilities','Apr 22 2020','Joomla 2.5.0 through 3.9.16','update','3.9.18'),
('Joomla!','core','3.9.18','<=','3.0.0','>=','Joomla! core','Five low vulnerabilities','Jun 03 2020','Joomla 2.5.0 through 3.9.18','update','3.9.19'),
('Joomla!','core','3.9.19','<=','3.0.0','>=','Joomla! core','Several vulnerabilities','Jul 14 2020','Joomla 2.5.0 through 3.9.19','update','3.9.20'),
('Joomla!','core','3.9.20','<=','3.0.0','>=','Joomla! core','Three low vulnerabilities','Aug 25 2020','Joomla 2.5.0 through 3.9.20','update','3.9.21'),
('com_pago','component','2.5.9.0','==','3.0.0','>=','paGO Commerce Component','SQL Injection','Nov 02 2020','Version 2.5.9.0','none','No details'),
('Joomla!','core','3.9.22','<=','3.0.0','>=','Joomla! core','Seven low vulnerabilities','Nov 11 2020','Joomla 1.7.0 through 3.9.22','update','3.9.23'),
('Joomla!','core','3.9.23','<=','3.0.0','>=','Joomla! core','Three low vulnerabilities','Jan 12 2020','Joomla 3.0.0 through 3.9.23','update','3.9.24'),
('Joomla!','core','3.9.24','<=','3.0.0','>=','Joomla! core','Nine low vulnerabilities','Mar 03 2020','Joomla 2.5.0 through 3.9.24','update','3.9.25'),
('Joomla!','core','3.9.25','<=','3.0.0','>=','Joomla! core','Two low vulnerabilities','Apr 13 2020','Joomla 3.0.0 through 3.9.25','update','3.9.26'),
('com_publisher','component','3.0.19','==','3.0.0','>=','Publisher Component','Xss vulnerability','Apr 21 2021','Version 3.0.19','update','3.0.20'),
('com_yoorecipe','component','1.0.0','>=','3.0.0','>=','Yoorecipe Component','Sql Injection vulnerability','Apr 21 2021','All versions','none','No details');

DROP TABLE IF EXISTS `#__securitycheckpro_sessions`;
CREATE TABLE IF NOT EXISTS `#__securitycheckpro_sessions` (
`userid` INT(4) UNSIGNED NOT NULL,
`session_id` VARCHAR(200) NOT NULL,
`username` VARCHAR(150) NOT NULL,
`ip` VARCHAR(26) NOT NULL,
`user_agent` VARCHAR(300) NOT NULL,
PRIMARY KEY (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__securitycheckpro_update_database` (
`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`version` VARCHAR(10),
`last_check` DATETIME,
`message` VARCHAR(300),
PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__securitycheckpro_update_database` (`version`) VALUES ('1.2.4');

CREATE TABLE IF NOT EXISTS `#__securitycheckpro_url_inspector_logs` (
`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`ip` VARCHAR(35) NOT NULL,
`uri` VARCHAR(100),
`forbidden_words` VARCHAR(300) NOT NULL,
`date_added` DATETIME,
PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__securitycheckpro_url_inspector_logs`;
CREATE TABLE IF NOT EXISTS `#__securitycheckpro_url_inspector_logs` (
`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`ip` VARCHAR(100) NOT NULL,
`uri` VARCHAR(100),
`forbidden_words` VARCHAR(300) NOT NULL,
`date_added` DATETIME,
PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__securitycheckpro_trackactions` (
`id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
`message` TEXT,
`log_date` DATETIME NOT NULL DEFAULT '1970-01-01 00:00:00',
`extension` VARCHAR(50) NOT NULL DEFAULT '',
`user_id` INT(11) NOT NULL DEFAULT '0',
`ip_address` VARCHAR(40) NOT NULL DEFAULT '0.0.0.0',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__securitycheckpro_trackactions_extensions` (
 `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
 `extension` VARCHAR(100) NOT NULL DEFAULT '',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT IGNORE INTO `#__securitycheckpro_trackactions_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users');

CREATE TABLE IF NOT EXISTS `#__securitycheckpro_trackactions_tables_data` (
`id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
`type_title` varchar(255) NOT NULL DEFAULT '',
`type_alias` varchar(255) NOT NULL DEFAULT '',
`title_holder` varchar(255) DEFAULT NULL,
`table_values` varchar(255) DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT IGNORE INTO `#__securitycheckpro_trackactions_tables_data` (`id`, `type_title`, `type_alias`, `title_holder`, `table_values`) VALUES
(1, 'article', 'com_content.article', 'title', '{"table_type":"Content","table_prefix":"JTable"}'),
(2, 'article', 'com_content.form', 'title', '{"table_type":"Content","table_prefix":"JTable"}'),
(3, 'banner', 'com_banners.banner', 'name', '{"table_type":"Banner","table_prefix":"BannersTable"}'),
(4, 'user_note', 'com_users.note', 'subject', '{"table_type":"Note","table_prefix":"UsersTable"}'),
(5, 'media', 'com_media.file', 'name', '{"table_type":"","table_prefix":""}'),
(6, 'category', 'com_categories.category', 'title', '{"table_type":"Category","table_prefix":"JTable"}'),
(7, 'menu', 'com_menus.menu', 'title', '{"table_type":"Menu","table_prefix":"JTable"}'),
(8, 'menu_item', 'com_menus.item', 'title', '{"table_type":"Menu","table_prefix":"JTable"}'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'name', '{"table_type":"Newsfeed","table_prefix":"NewsfeedsTable"}'),
(10, 'link', 'com_redirect.link', 'old_url', '{"table_type":"Link","table_prefix":"RedirectTable"}'),
(11, 'tag', 'com_tags.tag', 'title', '{"table_type":"Tag","table_prefix":"TagsTable"}'),
(12, 'style', 'com_templates.style', 'title', '{"table_type":"","table_prefix":""}'),
(13, 'plugin', 'com_plugins.plugin', 'name', '{"table_type":"Extension","table_prefix":"JTable"}'),
(14, 'component_config', 'com_config.component', 'name', '{"table_type":"","table_prefix":""}'),
(15, 'contact', 'com_contact.contact', 'name', '{"table_type":"Contact","table_prefix":"ContactTable"}'),
(16, 'module', 'com_modules.module', 'title', '{"table_type":"Module","table_prefix":"JTable"}'),
(17, 'access_level', 'com_users.level', 'title', '{"table_type":"Viewlevel","table_prefix":"JTable"}'),
(18, 'banner_client', 'com_banners.client', 'name', '{"table_type":"Client","table_prefix":"BannersTable"}');