<?php 
/** 
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage links
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Html as GdprHelpersHtml;

// Ordering drag'n'drop management
$saveOrderingUrl = null;
if ($this->orders['order'] == 's.ordering') {
	$saveOrderingUrl = 'index.php?option=com_gdpr&task=record.saveOrder&format=json&ajax=1';
	HTMLHelper::_('draggablelist.draggable');
}
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table class="full headerlist">
		<tr>
			<td class="left">
			</td>
			<td class="right d-flex justify-content-end">
				<div class="input-group d-none d-md-flex flex-end">
					<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_STATE');?>"><span class="icon-filter"></span> <?php echo Text::_('COM_GDPR_STATE' ); ?></span>
					<label class="visually-hidden" for="filter_state"><?php echo Text::_('JLIB_HTML_SELECT_STATE');?></label>
					<?php
						echo $this->lists['state'];
					?>
					<label class="visually-hidden" for="limit"><?php echo Text::_('JGLOBAL_LIST_LIMIT');?></label>
					<?php
						echo $this->pagination->getLimitBox();
					?>
				</div>
			</td>
		</tr>
	</table>

	<table id="adminList" class="adminlist table table-striped table-hover">
	<thead>
		<tr>
			<th style="width:1%">
				<?php echo Text::_('COM_GDPR_NUM' ); ?>
			</th>
			<th style="width:1%">
				<input type="checkbox" name="checkall-toggle" value="" class="form-check-input" onclick="Joomla.checkAll(this)" />
			</th>
			
			<th>
				<?php echo Text::_('COM_GDPR_RECORD_STRUCTURE' ); ?>
			</th>
			<th>
				<?php echo Text::_('COM_GDPR_RECORD_TREATMENT_NAME' ); ?>
			</th>
			<th class="d-none d-md-table-cell">
				<?php echo Text::_('COM_GDPR_RECORD_TREATMENT_REASON' ); ?>
			</th>
			<th class="d-none d-md-table-cell">
				<?php echo Text::_('COM_GDPR_RECORD_TARGET_USERS' ); ?>
			</th>
			<th class="d-none d-md-table-cell">
				<?php echo Text::_('COM_GDPR_RECORD_PERSONAL_DATA_CATEGORY' ); ?>
			</th>
			<th class="d-none d-lg-table-cell">
				<?php echo Text::_('COM_GDPR_RECORD_PERSONAL_DATA_TYPE' ); ?>
			</th>
			<th class="d-none d-lg-table-cell order">
				<?php echo HTMLHelper::_('grid.sort',   'COM_GDPR_ORDER', 's.ordering', @$this->orders['order_Dir'], @$this->orders['order'], 'record.display'); ?>
				<?php 
					if(isset($this->orders['order']) && $this->orders['order'] == 's.ordering'):
						echo GdprHelpersHtml::order($this->items, 'filesave.png', 'record.saveOrder'); 
					endif;
				 ?>
			</th>
			<th>
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_PUBLISHED', 's.published', @$this->orders['order_Dir'], @$this->orders['order'], 'record.display' ); ?>
			</th>
		</tr>
	</thead>
	<tbody <?php if ($saveOrderingUrl) :?> class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($this->orders['order_Dir']); ?>" <?php endif; ?>>
	<?php
	$canCheckin = $this->user->authorise('core.manage', 'com_checkin');
	$k = 0;
	for ($i=0, $n=count( $this->items ); $i < $n; $i++) {
		$row = $this->items[$i];
		$link =  'index.php?option=com_gdpr&task=record.editEntity&cid[]='. $row->id ;
		$fields = json_decode($row->fields);
		$taskPublishing	= !isset($row->published) || !$row->published ? 'record.publish' : 'record.unpublish';
		$altPublishing 	= !isset($row->published) || !$row->published ? Text::_( 'COM_GDPR_PUBLISH' ) : Text::_( 'COM_GDPR_UNPUBLISH' );
		
		$checked = null;
		// Access check.
		if($this->user->authorise('core.edit', 'com_gdpr')) {
			$checked = $row->checked_out && $row->checked_out != $this->user->id ?
			HTMLHelper::_('jgrid.checkedout', $i, Factory::getContainer()->get(\Joomla\CMS\User\UserFactoryInterface::class)->loadUserById($row->checked_out)->name, $row->checked_out_time, 'record.', $canCheckin) . '<input type="checkbox" style="display:none" data-enabled="false" id="cb' . $i . '" name="cid[]" value="' . $row->id . '"/>' :
			HTMLHelper::_('grid.id', $i, $row->id);
		} else {
			$checked = '<input type="checkbox" style="display:none" data-enabled="false" id="cb' . $i . '" name="cid[]" value="' . $row->id . '"/>';
		}
		
		if($this->user->authorise('core.edit.state', 'com_gdpr')) {
			$published = '<a href="index.php?option=com_gdpr&task=' . $taskPublishing . '&cid[]=' . $row->id . '">';
			$published .= !isset($row->published) || $row->published == 0 ? '<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-publish_x.png" width="16" height="16" border="0"/>' :
																			'<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-tick.png" width="16" height="16" border="0"/>';
			$published .= '</a>';
		} else {
			$published = '<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-tick.png" width="16" height="16" border="0"/>';
		}
		
		?>
		<tr>
			<td style="width:1%" align="center">
				<?php echo $this->pagination->getRowOffset($i); ?>
			</td>
			<td style="width:1%" align="center">
				<?php echo $checked; ?>
			</td>
		
			<td>
				<?php
				if ( ($row->checked_out && ( $row->checked_out != $this->user->id)) || !$this->user->authorise('core.edit', 'com_gdpr') ) {
					echo $fields->structure;
				} else {
					?>
					<a href="<?php echo $link; ?>" title="<?php echo Text::_('COM_GDPR_EDIT_RECORD' ); ?>">
						<span class="icon-pencil" aria-hidden="true"></span>
						<?php echo $fields->structure; ?>
					</a>
					<?php
				}
				?>
			</td>
			<td class="sortable-adminlist-medium">
				<span class="badge bg-info"><?php echo $fields->treatment_name; ?></span>
			</td>
			<td class="sortable-adminlist-medium d-none d-md-table-cell">
				<span class="badge bg-warning"><?php echo $fields->treatment_reason; ?></span>
			</td>
			<td class="sortable-adminlist-large d-none d-md-table-cell">
				<span class="badge bg-primary"><?php echo $fields->target_users; ?></span>
			</td>
			<td class="sortable-adminlist-medium d-none d-md-table-cell">
				<span class="badge bg-primary"><?php echo $fields->personal_data_category; ?></span>
			</td>
			<td class="sortable-adminlist-large d-none d-lg-table-cell">
				<span class="badge bg-primary"><?php echo $fields->personal_data_type; ?></span>
			</td>
			
			<td class="order d-none d-lg-table-cell sortable-adminlist-small">
				<?php 
				$ordering = $this->orders['order'] == 's.ordering'; 
				$disabled = $ordering ?  '' : 'disabled="disabled"'; 
				
				$iconClass = '';
				if (!$this->user->authorise('core.edit', 'com_gdpr')) {
					$iconClass = ' inactive';
				}
				elseif (!$ordering) {
					$iconClass = ' inactive tip-top hasTooltip" title="' . HTMLHelper::tooltipText('JORDERINGDISABLED');
				}
				?>
				<div style="display:inline-block" class="sortable-handler<?php echo $iconClass ?>">
					<span class="icon-menu" aria-hidden="true"></span>
				</div>
				
				<span class="moveup" aria-hidden="true"><?php echo $this->pagination->orderUpIcon( $i, true, 'record.moveorder_up', 'COM_GDPR_MOVE_UP', $ordering); ?></span>
				<span class="movedown" aria-hidden="true"><?php echo $this->pagination->orderDownIcon( $i, $n, true, 'record.moveorder_down', 'COM_GDPR_MOVE_DOWN', $ordering); ?></span>
				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>"  <?php echo $disabled; ?>  class="ordering_input" style="text-align: center" />
			</td>
			
			<td>
				<?php echo $published;?>
			</td>
		</tr>
		<?php
	}
	?>
	</tbody>
	<tfoot>
		<td colspan="100%">
			<?php echo $this->pagination->getListFooter(); ?>
		</td>
	</tfoot>
	</table>

	<input type="hidden" name="option" value="<?php echo $this->option;?>" />
	<input type="hidden" name="task" value="record.display" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo @$this->orders['order'];?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo @$this->orders['order_Dir'];?>" />
</form>