<?php 
/** 
 * @package GDPR::CHECKBOX::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage checkbox
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Editor\Editor;

$editor = Editor::getInstance(Factory::getApplication()->getConfig()->get('editor'));
?>
<form action="index.php" method="post" name="adminForm" id="adminForm"> 
	<div class="card card-default accordion-group">
		<div class="card-header accordion-heading opened">
			<div class="accordion-toggle noaccordion">
				<h4><span class="icon-pencil" aria-hidden="true"></span><?php echo Text::_( 'COM_GDPR_COOKIEDESCRIPTION_DETAILS' ); ?></h4>
			</div>
		</div>
		<div id="details" class="card-body card-block accordion-body">
	      	<div class="accordion-inner">
				<table class="admintable">
					<tbody>
						<tr>
							<td class="key left_title">
								<label for="placeholder" class="hasPopover" data-bs-content="<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_COOKIE_DESC' ); ?>">
									<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_COOKIE' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<input aria-describedby="name_arialbl" class="inputbox-large" type="text" id="cookie" name="cookie" data-validation="required" value="<?php echo $this->record->cookie;?>" />
								<small id="name_arialbl" class="form-text text-muted"><?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_COOKIE_DESC')?></small>
							</td>
						</tr>
						
						<tr>
							<td class="key left_title">
								<label for="name" class="hasPopover" data-bs-content="<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY_DESC' ); ?>">
									<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<?php echo $this->lists['categories'];?>
							</td>
						</tr>
						
						<tr>
							<td class="key left_title">
								<label for="description" class="hasPopover" data-bs-content="<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML_DESC' ); ?>">
									<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<div aria-describedby="descriptionhtml_arialbl">
									<?php echo $editor->display('descriptionhtml', $this->record->descriptionhtml, '600px', '400px', '70', '15', true); ?>
								</div>
								<small id="descriptionhtml_arialbl" class="form-text text-muted"><?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML_DESC')?></small>
							</td>
						</tr>

						<tr>
							<td class="key left_title">
								<label for="description" class="hasPopover" data-bs-content="<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION_DESC' ); ?>">
									<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<input type="text" class="inputbox-large" id="cookie" name="expiration" value="<?php echo $this->record->expiration;?>" />
							</td>
						</tr>

						<tr>
							<td class="key left_title">
								<label for="description" class="hasPopover" data-bs-content="<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_ALIAS_DESC' ); ?>">
									<?php echo Text::_('COM_GDPR_COOKIEDESCRIPTIONS_ALIAS' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<input type="text" class="inputbox-large" id="cookie" name="alias" value="<?php echo $this->record->alias;?>" />
							</td>
						</tr>
						
						<tr>
							<td class="key left_title">
								<label>
									<?php echo Text::_('COM_GDPR_PUBLISHED' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<fieldset class="radio btn-group" data-bs-toggle="buttons">
									<?php echo $this->lists['published']; ?>
								</fieldset>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>		
	
	<div class="clr"></div>
 
	<input type="hidden" name="option" value="<?php echo $this->option;?>" /> 
	<input type="hidden" name="id" value="<?php echo $this->record->id; ?>" />
	<input type="hidden" name="task" value="" /> 
</form>