/**
 * CPanel main JS APP class, manage chart generation
 * 
 * @package GDPR::CPANEL::administrator::components::com_gdpr 
 * @subpackage js 
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
*/
//'use strict';
(function ($) {
    var CPanel = function(targetSelector) {
    	/**
		 * Reference to ChartJS lib object
		 * 
		 * @access private
		 * @var Object
		 */
    	var chartJS = new Array();
    	
    	/**
		 * Charts options
		 * 
		 * @access private
		 * @var Object
		 */
    	var chartOptions = {animation:true, scaleFontSize: 11, scaleOverride: true, scaleSteps:1, scaleStepWidth: 50};
    	
    	/**
		 * Chart data to render, copy from global injected scope
		 * 
		 * @access private
		 * @var Object
		 */
    	var chartData = {};
    	
    	/**
		 * Element target to render chart
		 * 
		 * @access private
		 * @var HTMLElement
		 */
    	var context;

		/**
		 * Escape CSS selectors
		 * 
		 * @access private
		 * @var HTMLElement
		 */
    	var plgGdprCssEscape = function(value) {
    		var string = String(value);
    		var length = string.length;
    		var index = -1;
    		var codeUnit;
    		var result = '';
    		var firstCodeUnit = string.charCodeAt(0);
    		
    		// Skip values starting with a number
    		if(firstCodeUnit >= 48 && firstCodeUnit <= 57) {
    			return value;
    		}
    		
    		while (++index < length) {
    			codeUnit = string.charCodeAt(index);
    			if (codeUnit == 0x0000) {
    				result += '\uFFFD';
    				continue;
    			}
    			
    			if (
    					(codeUnit >= 0x0001 && codeUnit <= 0x001F) || codeUnit == 0x007F ||
    					(index == 0 && codeUnit >= 0x0030 && codeUnit <= 0x0039) ||
    					(
    							index == 1 &&
    							codeUnit >= 0x0030 && codeUnit <= 0x0039 &&
    							firstCodeUnit == 0x002D
    					)
    			) {
    				result += '\\' + codeUnit.toString(16) + ' ';
    				continue;
    			}
    			
    			if (
    					index == 0 &&
    					length == 1 &&
    					codeUnit == 0x002D
    			) {
    				result += '\\' + string.charAt(index);
    				continue;
    			}
    			
    			if (
    					codeUnit >= 0x0080 ||
    					codeUnit == 0x002D ||
    					codeUnit == 0x005F ||
    					codeUnit >= 0x0030 && codeUnit <= 0x0039 ||
    					codeUnit >= 0x0041 && codeUnit <= 0x005A ||
    					codeUnit >= 0x0061 && codeUnit <= 0x007A
    			) {
    				result += string.charAt(index);
    				continue;
    			}
    			result += '\\' + string.charAt(index);
    		}
    		return result;
    	};

        /**
		 * Interact with ChartJS lib to generate charts
		 * 
		 * @access private
		 * @return Void
		 */
        function generateLineChart(context, elem, animation) {
        	var elemIndex = $(elem).attr('id');
        	chartData = {};
        	
        	// Instance Chart object lib
        	chartJS[elemIndex] = new Chart(context);
        	
        	// Max value encountered
        	var maxValue = 10;
        	
        	// Normalize chart data to render
        	chartData.labels = new Array();
        	chartData.datasets = new Array();
        	var subDataSet = new Array();
        	var latestTranslation = '';
            $.each(gdprChartData[elemIndex], function(label, value){
            	var labelSuffix = label.replace(/([A-Z])/g, "_$1").toUpperCase()
            	chartData.labels[chartData.labels.length] = latestTranslation = eval('COM_GDPR_' + labelSuffix + '_CHART');
            	
            	// Special data bind retrieve for categories
            	if($.inArray(latestTranslation, ['cat1', 'cat2', 'cat3', 'cat4']) != -1) {
            		var categoryTextTranslationName = $('li[data-bind=' + plgGdprCssEscape(latestTranslation) + ']').data('name');
            		chartData.labels[chartData.labels.length - 1] = categoryTextTranslationName;
            	}
            	
            	subDataSet[subDataSet.length] = parseInt(value);
            	if(value > maxValue) {
            		maxValue = value;
            	}
            });
            
            if(subDataSet.length == 1) {
            	chartData.labels[chartData.labels.length] = chartData.labels[chartData.labels.length -1]; 
            	subDataSet[subDataSet.length] = parseInt(maxValue);
            }
            
            // Override scale
            var konstant = 1;
            if(maxValue > 100) {
            	konstant = 10;
            }
            if(maxValue > 1000) {
            	konstant = 80;
            }
            if(maxValue > 10000) {
            	konstant = 500;
            }
            if(maxValue > 100000) {
            	konstant = 5000;
            }
            chartOptions.scaleStepWidth = parseInt((maxValue * konstant) / (maxValue / 10)); 
            chartOptions.scaleSteps = parseInt((maxValue / chartOptions.scaleStepWidth) + 1);
            
            chartData.datasets[0] = {
            		fillColor : "rgba(151,187,205,0.5)",
					strokeColor : "rgba(151,187,205,1)",
					pointColor : "rgba(151,187,205,1)",
					pointStrokeColor : "#fff",
					data : subDataSet
            };
        	
            // Override options
            chartOptions.animation = animation;
            
            // Paint chart on canvas
        	chartJS[elemIndex].Line(chartData, chartOptions);
        };
        
        /**
		 * Function dummy constructor
		 * 
		 * @access private
		 * @param String contextSelector
		 * @method <<IIFE>>
		 * @return Void
		 */
        (function __construct() {
            // Get target canvas context 2d to render chart
        	if(!!document.createElement('canvas').getContext) {
        		var resizeRepaintCanvas = function(animation) {
        			$.each(targetSelector, function(k, elem){
						if($(elem).length) {
        					// Get context
							context = $(elem).get(0).getContext('2d');
							// Get HTMLCanvasElement
							var canvas = $(elem).get(0);
							// Get parent container width
        					var containerWidth = $(canvas).parent().width();
        					// Set dinamically canvas width
        					canvas.width  = containerWidth;
        					canvas.height = 180;
        					// Repaint canvas contents
        					generateLineChart(context, elem, animation);
        				}
        			}); 
        		}
        		
        		// Start generation
        		setTimeout(function(){
            		resizeRepaintCanvas(true);
            	}, 300);
        		
        		$(document).on('click', '#menu-collapse', function(event){
            		setTimeout(function(){
            			resizeRepaintCanvas();
            		}, 300);
            	});
        		
        		$(window).on('resize', function(){
        			resizeRepaintCanvas();
        		});
        	}
        }).call(this);
    }

    // On DOM Ready
    $(function () {
        var gdprCPanel = new CPanel(['#chart_gdpr_canvas', '#chart_gdpr_cookies_canvas']);
    });
})(jQuery);