<?php
namespace JExtstore\Component\Gdpr\Administrator\Table;
/**
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage tables
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception\Exceptions;

/**
 * Tracking of links redirected by the plugin
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage tables
 * @since 1.6
 */
class RecordTable extends Table {
	use Exceptions;
	
	/**
	 * @public int Primary key
	 */
	public $id = null;
	
	/**
	 * @public JSON string
	 */
	public $fields = null;
	
	/**
	 * @var int
	 */
	public $checked_out = null;
	
	/**
	 * @var datetime
	 */
	public $checked_out_time = null;
	
	/**
	 * @var int
	 */
	public $published = 1;
	
	/**
	 * @var int
	 */
	public $ordering = 0;
	
	/**
	 * Load Table override
	 * @override
	 *
	 * @see JTable::load()
	 */
	public function load($idEntity = null, $reset = true) {
		// If not $idEntity set return empty object
		if($idEntity) {
			if(!parent::load ( $idEntity )) {
				return false;
			}
		}
	
		// Decode the JSON field structure
		if($this->fields) {
			$this->fields = json_decode($this->fields, true);
		}

		return true;
	}
	
	/**
	 * Bind Table override
	 * @override
	 * 
	 * @see JTable::bind()
	 */
	public function bind($fromArray, $ignore = array(), $saveTask = false, $sessionTask = false) {
		parent::bind($fromArray);
		
		// Encode the JSON field structure
		if($saveTask) {
			$this->fields = json_encode($this->fields);
		}
		
		return true;
	}
	
	/**
	 * Check Table override
	 * @override
	 *
	 * @see JTable::check()
	 */
	public function check() {
		// Validation for JSON fields
		$decodedFields = json_decode($this->fields);
		
		// Structure required
		if (! $decodedFields->structure) {
			$this->setException ( Text::_('COM_GDPR_VALIDATION_ERROR' ) );
			return false;
		}
		
		// Treatment_name required
		if (!$decodedFields->treatment_name) {
			$this->setException ( Text::_('COM_GDPR_VALIDATION_ERROR' ) );
			return false;
		}
		
		return parent::check();
	}
	
	/**
	 * Class constructor
	 * @param DatabaseDriver $db DatabaseDriver object.
	 * @param DispatcherInterface  $dispatcher  Event dispatcher for this table
	 *
	 * return Object&
	 */
	public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null) {
		parent::__construct ( '#__gdpr_record', 'id', $db, $dispatcher );
		
		// Support null values for datetime field
		$this->_supportNullValue = true;
	}
}