<?php
namespace JExtstore\Component\Gdpr\Administrator\Model;
/**
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage models
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\HTML\HTMLHelper;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Html as GdprHelpersHtml;
use JExtstore\Component\Gdpr\Administrator\Framework\Model as GdprModel;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception as GdprException;

/**
 * Links model concrete implementation <<testable_behavior>>
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage models
 * * @since 1.0
 */
class RecordModel extends GdprModel {
	/**
	 * Build list entities query
	 * 
	 * @access protected
	 * @return string
	 */
	protected function buildListQuery() {
		// WHERE
		$where = array ();
		$whereString = null;
		$orderString = null;

		// STATE FILTER
		if ($filter_state = $this->state->get ( 'state' )) {
			if ($filter_state == 'P') {
				$where [] = 's.published = 1';
			} else if ($filter_state == 'U') {
				$where [] = 's.published = 0';
			}
		}
		// Always include only published rows in the exported report
		if(in_array($this->app->getInput()->get('task'), array('record.exportXlsRecord', 'record.exportOdsRecord'))) {
			$where [] = 's.published = 1';
		}
		
		if (count ( $where )) {
			$whereString = "\n WHERE " . implode ( "\n AND ", $where );
		}
		
		// ORDERBY
		if ($this->state->get ( 'order' )) {
			$orderString = "\n ORDER BY " . $this->state->get ( 'order' ) . " ";
		}
		
		// ORDERDIR
		if ($this->state->get ( 'order_dir' )) {
			$orderString .= $this->state->get ( 'order_dir' );
		}
		
		$query = "SELECT s.*" .
				 "\n FROM #__gdpr_record AS s" .
				 $whereString . 
				 $orderString;
		return $query;
	}

	/**
	 * Main get data methods
	 * 
	 * @access public
	 * @return array
	 */
	public function getData(): array {
		// Build query
		$query = $this->buildListQuery ();
		try {
			$dbQuery = method_exists ( $this->dbInstance, 'createQuery' ) ? $this->dbInstance->createQuery () : $this->dbInstance->getQuery ( true );
			$dbQuery->setQuery ( $query )->setLimit ( $this->getState ( 'limit' ), $this->getState ( 'limitstart' ) );
			$this->dbInstance->setQuery ( $dbQuery );
			$result = $this->dbInstance->loadObjectList ();
		} catch (GdprException $e) {
			$this->app->enqueueMessage($e->getMessage(), $e->getExceptionLevel());
			$result = array();
		} catch (\Exception $e) {
			$gdprException = new GdprException($e->getMessage(), 'error');
			$this->app->enqueueMessage($gdprException->getMessage(), $gdprException->getExceptionLevel());
			$result = array();
		}
		return $result;
	}
	
	/**
	 * Storing entity by ORM table
	 *
	 * @access public
	 * @param bool $updateNulls
	 * @return mixed
	 */
	public function storeEntity($updateNulls = true) {
		return parent::storeEntity($updateNulls);
	}
	
	/**
	 * Return select lists used as filter for listEntities
	 *
	 * @access public
	 * @return array
	 */
	public function getFilters(): array {
		$filters = array();
		
		$filters ['state'] = GdprHelpersHtml::state( $this->getState ( 'state' ) );
		
		return $filters;
	}
	
	/**
	 * Return select lists used as filter for editEntity
	 *
	 * @access public
	 * @param Object $record
	 * @return array
	 */
	public function getLists($record = null): array {
		$lists = parent::getLists($record);

		// Grid states
		//$lists ['evaluate_params'] = HTMLHelper::_ ( 'select.booleanlist', 'evaluate_params', null, $record->evaluate_params );
		
		return $lists;
	}
}