<?php
namespace JExtstore\Component\Gdpr\Administrator\Field;
/**  
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */ 
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

/**
 * Form Field for categories tree
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @since 1.0
 */
class UsercategoriesField extends ListField {
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $type = 'usercategories';
	
	/**
	 * Method to get the field input markup for a generic list.
	 * Use the multiple attribute to enable multiselect.
	 *
	 * @return string The field input markup.
	 *
	 * @since 11.1
	 */
	protected function getInput() {
		// Initialize variables.
		$html = array ();
		$attr = '';
	
		// Default option translation
		$defaultTranslation = $this->element ['translation'] ? Text::_($this->element ['translation']) : Text::_('COM_GDPR_NO_CATEGORY');
	
		// Initialize some field attributes.
		$attr .= $this->element ['class'] ? ' class="form-select ' . ( string ) $this->element ['class'] . '"' : ' class="form-select"';
	
		// To avoid user's confusion, readonly="true" should imply
		// disabled="true".
		if (( string ) $this->element ['readonly'] == 'true' || ( string ) $this->element ['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}
	
		$attr .= $this->element ['size'] ? ' size="' . ( int ) $this->element ['size'] . '"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';
	
		// Initialize JavaScript field attributes.
		$attr .= $this->element ['onchange'] ? ' onchange="' . ( string ) $this->element ['onchange'] . '"' : '';
	
		// Get the field options.
		$options = ( array ) $this->getOptions ($defaultTranslation);
	
		$html = HTMLHelper::_ ( 'select.genericlist', $options, $this->name, trim ( $attr ), 'value', 'text', $this->value, $this->id );
	
		return $html;
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   11.1
	 */
	protected function getOptions($defaultTranslation = null) {
		$options = array();
		$options[] = HTMLHelper::_('select.option', '0', Text::_('COM_GDPR_NO_CATEGORY'), 'value', 'text');
		$options = array_merge($options, HTMLHelper::_('category.options', 'com_users'));
		
		return $options;
	}
}