<?php
namespace JExtstore\Component\Gdpr\Administrator\Field;
/**  
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */ 
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

/**
 * Form Field for ACL Groups
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @since 2.0
 */
class ChatgptField extends FormField {
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $type = 'chatgpt';
	
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $contentType = '';

	/**
	 * Method to attach a Form object to the field.
	 *
	 * @param   \SimpleXMLElement  $element  The SimpleXMLElement object representing the `<field>` tag for the form field object.
	 * @param   mixed              $value    The form field value to validate.
	 * @param   string             $group    The field name group control value. This acts as as an array container for the field.
	 *                                       For example if the field has name="foo" and the group value is set to "bar" then the
	 *                                       full field name would end up being "bar[foo]".
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.7.0
	 */
	public function setup(\SimpleXMLElement $element, $value, $group = null) {
		$params = ComponentHelper::getParams ( 'com_gdpr' );
		$apiKey = trim($params->get ( 'chatgpt_apikey', '' ));
		if(!$apiKey) {
			return false;
		}
		
		parent::setup($element, $value, $group);
		
		// Setup the content type
		$this->contentType = $this->element['contenttype'];
		
		return true;
	}
	
	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput() {
		$params = ComponentHelper::getParams ( 'com_gdpr' );
		$apiKey = trim($params->get ( 'chatgpt_apikey', '' ));
		$chatgptApi = $params->get('chatgpt_api', 'completions');
		$chatgptApiModel = $params->get('chatgpt_api_model', 'gpt-3.5-turbo');
		$maxTokens = $params->get ( 'max_tokens', 2048 );
		$temperature = $params->get ( 'temperature', 1 );
		
		if(!$apiKey) {
			return '';
		}
		
		if($this->contentType == 'cookie') {
			$currentFieldPrompt = $params->get ( 'chatgptpromptcookie', '' );
			$app = Factory::getApplication();
			$appNonce = $app->get('csp_nonce', null);
			$nonce = $appNonce ? ' nonce="' . $appNonce . '"' : '';
			$cookiePromptDefault = Text::sprintf(Text::_('COM_GDPR_CHATGPT_DEFAULT_COOKIE_PROMPT', true), Uri::root(false));
			$privacyPromptDefault = Text::sprintf(Text::_('COM_GDPR_CHATGPT_DEFAULT_PRIVACY_PROMPT', true), Uri::root(false));
			$generateText = Text::_('COM_GDPR_CHATGPT_GENERATE_BUTTON_TEXT', true);
			$generatingText = Text::_('COM_GDPR_CHATGPT_GENERATING_BUTTON_TEXT', true);
			$jsInject = <<<JS
					<script type="module"$nonce>
							if (document.querySelector('script[type=importmap]')) {
							  import('editor-api')
							    .then(editorApiModule => {
							    	window.gdprEditorReference = editorApiModule.JoomlaEditor;
							    })
							    .catch(error => {
							    	console.error('An error occurred while loading the module: ', error);
							    });
							}
	                        function gdprChatGPTGenerate(event) {
								event.preventDefault();

								// Prevent overlapping requests
								if(event.target.classList.contains('gdpr-chatgpt-generating')) {
									return false;
								}

		                        let apiKey = '$apiKey';
								let promptText = this.nextElementSibling.value;
	                        	let promptTextWithoutHTmlTags = promptText.replace(/(<([^>]+)>)/gi, '');
	                        	let chatgptApi = '$chatgptApi';

								if(!promptTextWithoutHTmlTags) {
									const contentType = event.target.dataset.type;
									if(contentType == 'params_cookie_policy_contents') {
										promptTextWithoutHTmlTags = '$cookiePromptDefault';
									} else {
										promptTextWithoutHTmlTags = '$privacyPromptDefault';
									}
								}
								
	                            var chatgptHeaders = new Headers();
	                            chatgptHeaders.append('Content-Type', 'application/json');
	                            chatgptHeaders.append('Authorization', 'Bearer ' + apiKey);
	                            
	                            function aiResponse(aiResp) {
									hideLoader('gdpr-chatgpt-loader');
									if(aiResp.error) {
										alert(aiResp.error.message);
										return false;
									}

									if(chatgptApi == 'completions') {
										var output = aiResp.choices[0].text;
									} else {
										var output = aiResp.choices[0].message.content;
									}

									// For inserting AI text
									const editor = event.target.dataset.type;
									if(typeof(window.gdprEditorReference) !== 'undefined' && window.gdprEditorReference.getActive()) {
										var editorReference = window.gdprEditorReference.get(editor);
										editorReference.replaceSelection(output.trim());
									} else {
										if (window.Joomla && window.Joomla.editors && window.Joomla.editors.instances && Object.prototype.hasOwnProperty.call(window.Joomla.editors.instances, editor)) {
											window.Joomla.editors.instances[editor].replaceSelection(output.trim());
										}
									}
	                            }
	                            
								(function addLoader() {
									event.target.classList.add('gdpr-chatgpt-generating');
									event.target.innerHTML = '$generatingText';
		                            event.target.insertAdjacentHTML('afterbegin', "<span class='gdpr-chatgpt-loader spinner-border spinner-border-sm me-2' role='status' aria-hidden='true'></span>");
								})()
								
	                            function hideLoader(loaderClassName) {
									var elements = document.querySelectorAll('span.' + loaderClassName);
									elements.forEach(element => {
										element.parentElement.classList.remove('gdpr-chatgpt-generating');
										element.parentElement.innerHTML = '$generateText';
									});
	                            }
	                            
								if(chatgptApi == 'completions') {
									var requestOptions = {
										method: 'POST',
										headers: chatgptHeaders,
										body: JSON.stringify({
											'prompt': promptTextWithoutHTmlTags,
											'model': 'gpt-3.5-turbo-instruct',
											'max_tokens': $maxTokens,
											'temperature': $temperature
										}),
										redirect: 'follow'
									};
									var chatgptApiUrl = 'https://api.openai.com/v1/completions'; 
								} else {
									var requestOptions = {
		                                method: 'POST',
		                                headers: chatgptHeaders,
		                                body: JSON.stringify({
											'messages' : [
												{
													'role' : 'user',
													'content' : promptTextWithoutHTmlTags
												}
											],
			                                'model': '$chatgptApiModel',
			                                'max_tokens': $maxTokens,
			                                'temperature': $temperature
			                            }),
		                                redirect: 'follow'
		                            };
									var chatgptApiUrl = 'https://api.openai.com/v1/chat/completions'; 
								}

	                            fetch(chatgptApiUrl, requestOptions)
	                                .then(response => response.json())
	                                .then(aiResponse)
	                                .catch(function(error) {
										hideLoader('gdpr-chatgpt-loader');
										alert(error);
									});

								return false;
	                        }
	                        
							document.addEventListener('DOMContentLoaded', (e) => {
		                        var elements = document.querySelectorAll('button.gdpr-chatgpt');
								elements.forEach(element => {
								  element.addEventListener('click', gdprChatGPTGenerate);
								});
							});
					</script>
JS;
		} else {
			$currentFieldPrompt = $params->get ( 'chatgptpromptprivacy', '' );
			$jsInject = '';
		}
		
		
		$return = $jsInject;
		$return .= 	'<button data-type="params_' . $this->contentType . '_policy_contents" class="btn btn-primary mt-2 gdpr-chatgpt">' . Text::_ ( 'COM_GDPR_CHATGPT_GENERATE_BUTTON_TEXT' ) . '</button>';
		$return .= 	'<textarea class="form-control gdpr-chatgpt-prompt" name="params[chatgptprompt' . $this->contentType . ']" id="generator-attr-chatgpt-prompt-' . $this->contentType . '" placeholder="' . Text::_ ( 'COM_GDPR_CHATGPT_GENERATE_HINT' ) . '">' . $currentFieldPrompt . '</textarea>';
		
		return $return;
	}
}