<?php
/**
 * @package DJ-Tabs
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email: contact@dj-extensions.com
 */

defined('_JEXEC') or die( 'Restricted access' );
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
class DjTabsViewgroup extends HtmlView
{
	protected $form;
	protected $item;
	protected $state;

	public function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');

		$this->addToolbar();
		
		$this->bs_classes = DJTabsAdminHelper::getBSClasses();
		
		parent::display($tpl);
	}
	
	protected function addToolbar()
	{
		Factory::getApplication()->input->set('hidemainmenu', true);
	
		$isNew		= ($this->item->id == 0);

		$text = $isNew ? Text::_( 'COM_DJTABS_NEW' ) : Text::_( 'COM_DJTABS_EDIT' );
		ToolbarHelper::title(   Text::_( 'COM_DJTABS_GROUP' ).': <small><small>[ ' . $text.' ]</small></small>', 'generic.png' );

		ToolbarHelper::apply('group.apply', 'JTOOLBAR_APPLY');
		ToolbarHelper::save('group.save', 'JTOOLBAR_SAVE');
		ToolbarHelper::custom('group.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
		ToolbarHelper::custom('group.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
		ToolbarHelper::cancel('group.cancel', 'JTOOLBAR_CANCEL');
	}

}


