<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5.x
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.0.1.0-PRO - 2024-01-29
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\{Plugin\CMSPlugin, Factory, Uri\Uri};
use Joomla\Event\DispatcherInterface;
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Helper\EasyJoomlaBackupHelper;
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Model\CreateModel;

/**
 * Class PlgSystemEasyJoomlaBackupCronjob
 *
 * @version 5.0.0.1-PRO
 * @since   5.0.0.0-PRO
 */
class PlgSystemEasyJoomlaBackupCronjob extends CMSPlugin
{
    /**
     * PlgSystemEasyJoomlaBackupCronjob constructor
     *
     * @param DispatcherInterface $subject
     * @param array               $config
     *
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    public function __construct(DispatcherInterface $subject, array $config)
    {
        parent::__construct($subject, $config);
    }

    /**
     * The backup process via a cronjob is executed in the trigger onAfterRoute
     *
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    public function onAfterRoute(): void
    {
        if (Factory::getApplication()->isClient('administrator')) {
            return;
        }

        $tokenRequest = Factory::getApplication()->getInput()->get('ejbtoken', null, 'STRING');

        if (!empty($tokenRequest)) {
            $token = (string)$this->params->get('token');

            if ($tokenRequest === $token) {
                $this->backupCreate($this->getBackupType());
                Factory::getApplication()->redirect(Uri::getInstance()::current());
            }
        }
    }

    /**
     * Creates the backup archive in dependence on the submitted type
     *
     * @param string $type
     *
     * @throws Exception
     * @version 5.0.0.1-PRO
     * @since   5.0.0.0-PRO
     */
    private function backupCreate(string $type): void
    {
        EasyJoomlaBackupHelper::increaseServerLimits();

        $model = new CreateModel();
        $status = $model->createBackup($type, 'plugin');

        $model->dropboxUploadAutomatic('plugin');
        $model->sendNotification('plugin', $status);
        $model->removeBackupFilesMax();
    }

    /**
     * Gets the backup type for the execution
     *
     * @return string
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    private function getBackupType(): string
    {
        $type = Factory::getApplication()->getInput()->get('ejbtype', null, 'INTEGER');

        if (empty($type) || (!in_array($type, [1, 2, 3], true))) {
            $type = (int)$this->params->get('type');
        }

        if ($type === 2) {
            return 'databasebackup';
        }

        if ($type === 3) {
            return 'filebackup';
        }

        return 'fullbackup';
    }
}
