<?php
/**
 * ------------------------------------------------------------------------
 * Logo Slider  Module for Joomla
 * ------------------------------------------------------------------------
 * Copyright (C) 2014-2018 LogicHunt, All Rights Reserved.
 * license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: LogicHunt
 * Websites: http://logichunt.com
 * ------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$app = JFactory::getApplication();
$doc = JFactory::getDocument();


$basepath = JUri::root(true).'/modules/' . $module->module . '/assets/';

// Load OWL StyleSheet
$doc->addStyleSheet($basepath.'lib/owl223/assets/owl.carousel.min.css');
$doc->addStyleSheet($basepath.'lib/owl223/assets/owl.theme.default.min.css');


// Load Tooltip
if($tooltip_en) {
    $doc->addStyleSheet($basepath.'lib/tooltipster/css/tooltipster.bundle.css');
}

// Load Main StyleSheet
$style_name = 'style.css';
$doc->addStyleSheet($basepath.'css/'.$style_name);

//Load Override StyleSheet
$templatepath = 'templates/'.$app->getTemplate().'/css/'.$module->module.'.css';

if(file_exists(JPATH_SITE . '/' . $templatepath)) {
	$doc->addStyleSheet(JURI::root(true).'/'.$templatepath);
}

//script
JHtml::_('jquery.framework');
//$doc->addScript('https://code.jquery.com/jquery-1.12.4.min.js');
$doc->addScript($basepath.'lib/owl223/owl.carousel.min.js');
if($tooltip_en) {
    $doc->addScript($basepath.'lib/tooltipster/js/tooltipster.bundle.min.js');
}


// Main Script
//$doc->addScript($basepath.'js/lgxscript.js');
