<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die;

// Explicitly declare the type of content
//header("Content-type: text/css; charset=UTF-8");
?>

.wlp_<?php echo $true_suffix; ?> h1 { /* page heading */
	display: inline-block;
}

.wlp_<?php echo $true_suffix; ?> .pretext { /* article before */
	margin-bottom: 20px;
}

.wlp_<?php echo $true_suffix; ?> .posttext { /* article after */
	margin-top: 20px;
	clear: both;
}

.wlp_<?php echo $true_suffix; ?> .icons ul.list {
	list-style: none;
	padding: 0;
	margin: 0;
	float: right;
}

html[dir="rtl"] .wlp_<?php echo $true_suffix; ?> .icons ul.list {
	float: left;
}

.wlp_<?php echo $true_suffix; ?> .icons ul.list > li {
	display: inline-block;
	padding: 0 5px;
}

.wlp_<?php echo $true_suffix; ?> .icons ul.list > li:last-child {
	padding: 0 0 0 5px;
}

html[dir="rtl"] .wlp_<?php echo $true_suffix; ?> .icons ul.list > li:last-child {
	padding: 0 5px 0 0;
}

.wlp_<?php echo $true_suffix; ?> .weblinks_footnote {
	display: inline-block;
	font-size: .6em;
	line-height: 1em;
	clear: both;
}

	.wlp_<?php echo $suffix; ?> ul.weblink_items {
		display: -webkit-box;
		display: -ms-flexbox;
		display: flex;

		list-style: none;
		margin: 0;
	    padding: 0;
	    clear: both;
	}

	.wlp_<?php echo $suffix; ?> ul.weblink_items.grid {
		-webkit-flex-direction: row;
		-ms-flex-direction: row;
		flex-direction: row;

		-webkit-flex-wrap: wrap;
		-ms-flex-wrap: wrap;
		flex-wrap: wrap;

		<?php if ($items_align == 'fs') : ?>
	    	-webkit-box-pack: start;
			-webkit-justify-content: flex-start;
	    	-ms-flex-pack: start;
	        justify-content: flex-start;
	    <?php elseif ($items_align == 'fe') : ?>
	    	-webkit-box-pack: end;
			-webkit-justify-content: flex-end;
	    	-ms-flex-pack: end;
	        justify-content: flex-end;
	    <?php elseif ($items_align == 'c') : ?>
	    	-webkit-box-pack: center;
			-webkit-justify-content: center;
	    	-ms-flex-pack: center;
	        justify-content: center;
	    <?php elseif ($items_align == 'sb') : ?>
	    	-webkit-box-pack: justify;
	    	-webkit-justify-content: space-between;
	        -ms-flex-pack: justify;
	        justify-content: space-between;
	    <?php elseif ($items_align == 'se') : ?>
	    	-webkit-box-pack: space-evenly;
			-webkit-justify-content: space-evenly;
			-ms-flex-pack: space-evenly;
	        justify-content: space-evenly;
	    <?php else : ?>
	    	-webkit-justify-content: space-around;
			-ms-flex-pack: distribute;
	        justify-content: space-around;
	    <?php endif; ?>

	    <?php if ($items_valign == 'fs') : ?>
	    	-webkit-box-align: start;
	    	-ms-flex-align: start;
	    	align-items: flex-start;
	    <?php elseif ($items_valign == 'fe') : ?>
	    	-webkit-box-align: end;
	    	-ms-flex-align: end;
	    	align-items: flex-end;
	    <?php else : ?>
	    	-webkit-box-align: center;
	    	-ms-flex-align: center;
	    	align-items: center;
		<?php endif; ?>
	}

	.wlp_<?php echo $suffix; ?> ul.weblink_items.list {
		-webkit-box-orient: vertical;
		-webkit-box-direction: normal;
		-webkit-flex-direction: column;
		-ms-flex-direction: column;
		flex-direction: column;

	    <?php if ($items_valign_list == 'fs') : ?>
	    	-webkit-box-align: start;
	    	-ms-flex-align: start;
	    	align-items: flex-start;
	    <?php elseif ($items_valign_list == 'fe') : ?>
	    	-webkit-box-align: end;
	    	-ms-flex-align: end;
	    	align-items: flex-end;
	    <?php elseif ($items_valign_list == 'c') : ?>
	    	-webkit-box-align: center;
	    	-ms-flex-align: center;
	    	align-items: center;
		<?php else : ?>
	    	-webkit-box-align: stretch;
	    	-ms-flex-align: stretch;
	    	align-items: stretch;
		<?php endif; ?>
	}

		.wlp_<?php echo $suffix; ?> ul.weblink_items li.weblink_item {
		    list-style: none;
			padding: 0;
		    display: inline-block;
		    text-align: initial;
		}

		.wlp_<?php echo $suffix; ?> ul.weblink_items.list li.weblink_item {
		    display: block;
		    overflow: hidden;
		}

			.wlp_<?php echo $suffix; ?> ul.weblink_items li .weblink_item_wrapper {
				overflow: hidden;
				margin: <?php echo $margin_top; ?>px <?php echo $margin_right; ?>px <?php echo $margin_bottom; ?>px <?php echo $margin_left; ?>px;
				position: relative;

		    	-webkit-box-sizing: border-box;
				-moz-box-sizing: border-box;
				box-sizing: border-box;

				<?php if ($overall_bgcolor != 'transparent') : ?>
					background-color: <?php echo $overall_bgcolor; ?>;
				<?php endif; ?>

				<?php if ($card_shadow) : ?>
            		-moz-box-shadow: 0 0 8px rgba(0, 0, 0, 0.5);
            		-webkit-box-shadow: 0 0 8px rgba(0, 0, 0, 0.5);
            		box-shadow: 0 0 8px rgba(0, 0, 0, 0.5);
            	<?php endif; ?>

            	<?php if ($card_radius > 0) : ?>
            		-moz-border-radius: <?php echo $card_radius; ?>px;
            		-webkit-border-radius: <?php echo $card_radius; ?>px;
            		border-radius: <?php echo $card_radius; ?>px;
            	<?php endif; ?>

				<?php if ($card_border_width > 0) : ?>
					border: <?php echo $card_border_width; ?>px solid <?php echo $card_border_color; ?>;
				<?php endif; ?>

				<?php if ($overall_bgcolor != 'transparent' || $card_shadow || $card_border_width > 0) : ?>
					padding: <?php echo $padding; ?>px;
				<?php endif; ?>
			}

			.wlp_<?php echo $suffix; ?> ul.weblink_items.grid li .weblink_item_wrapper {
				<?php if ($overall_width) : ?>
					max-width: <?php echo $overall_width; ?>px;
					<?php if ($force_width) : ?>
						min-width: <?php echo $overall_width; ?>px;
					<?php endif; ?>
				<?php elseif ($width > 0) : ?>
					<?php if (!$restrict_width_to_image) : ?>
						width: <?php echo $computed_width; ?>px;
					<?php else : ?>
						max-width: <?php echo $computed_width; ?>px;
					<?php endif; ?>
				<?php endif; ?>
			}

			.wlp_<?php echo $suffix; ?> ul.weblink_items.list li .weblink_item_wrapper {

				<?php if ($overall_width) : ?>
					max-width: <?php echo $overall_width; ?>px;
					<?php if ($force_width) : ?>
						min-width: <?php echo $overall_width; ?>px;
					<?php endif; ?>
				<?php endif; ?>

				display: -webkit-box;
    			display: -ms-flexbox;
				display: flex;

				<?php if ($content_valign == 'middle') : ?>
					-webkit-box-align: center;
        			-ms-flex-align: center;
					align-items: center;
				<?php elseif ($content_valign == 'bottom') : ?>
					-webkit-box-align: end;
        			-ms-flex-align: end;
					align-items: flex-end;
				<?php else : ?>
				 	-webkit-box-align: start;
        			-ms-flex-align: start;
					align-items: flex-start;
				<?php endif; ?>

				<?php if ($text_wrap) : ?>
					-webkit-flex-wrap: wrap;
					-ms-flex-wrap: wrap;
					flex-wrap: wrap;
				<?php endif; ?>

				<?php if (!$logo_solo) : ?>
					padding: 0 <?php echo $padding; ?>px <?php echo $padding; ?>px 0; /* emulated gap */
				<?php endif; ?>
			}

			<?php if (!$logo_solo) : ?>
				html[dir="rtl"] .wlp_<?php echo $suffix; ?> ul.weblink_items.list li .weblink_item_wrapper {
					padding: 0 0 <?php echo $padding; ?>px <?php echo $padding; ?>px; /* emulated gap */
				}
			<?php endif; ?>

            	.wlp_<?php echo $suffix; ?> ul.weblink_items li .edition {
            		position: absolute;
            		top: 10px;
            		right: 10px;
            		z-index: 10;
            	}

            	html[dir="rtl"] .wlp_<?php echo $suffix; ?> ul.weblink_items li .edition {
            		left: 10px;
            		right: 0;
            	}

				.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo {
				    text-align: center;
					<?php if ($logo_bgcolor != 'transparent') : ?>
						background-color: <?php echo $logo_bgcolor; ?>;
						padding: <?php echo $padding; ?>px;
					<?php endif; ?>
					margin: 0 auto;
				}

				<?php if (($width > 0 && !$restrict_width_to_image) || !$logo_solo) : ?>
					.wlp_<?php echo $suffix; ?> ul.weblink_items.list li .logo {
						<?php if ($width > 0 && !$restrict_width_to_image) : ?>
							width: <?php echo $width; ?>px;
						<?php endif; ?>
						<?php if (!$logo_solo) : ?>
							margin: <?php echo $padding; ?>px 0 0 <?php echo $padding; ?>px; /* emulated gap */
						<?php endif; ?>
					}
				<?php endif; ?>

				html[dir="rtl"] .wlp_<?php echo $suffix; ?> ul.weblink_items.list li .logo {
					-webkit-box-orient: horizontal;
					-webkit-box-direction: reverse;
					-ms-flex-direction: row-reverse;
					flex-direction: row-reverse;

					<?php if (!$logo_solo) : ?>
						margin: <?php echo $padding; ?>px <?php echo $padding; ?>px 0 0; /* emulated gap */
					<?php endif; ?>
				}

					.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_caption {
						margin-top: <?php echo $padding; ?>px;
						font-size: <?php echo ($font_size / 100); ?>em;
					}

					.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link {
						position: relative;

						display: -webkit-box;
						display: -ms-flexbox;
						display: flex;
						
						-webkit-box-pack: center;
        				-ms-flex-pack: center;
            			justify-content: center;

						<?php if ($height > 0 && !$restrict_width_to_image) : ?>
							height: <?php echo $height; ?>px;
						<?php endif; ?>

					    filter: alpha(opacity=<?php echo ($opacity * 100); ?>);
					    opacity: <?php echo $opacity; ?>;
					}

						.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a {
							display: inline-block;
							position: relative;
							font-size: 0;
							<?php if ($width > 0) : ?>
								<?php if (!$restrict_width_to_image) : ?>
									width: <?php echo $width; ?>px;
								<?php else : ?>
									max-width: <?php echo $width; ?>px;
								<?php endif; ?>
							<?php endif; ?>
							<?php if ($height > 0 && !$restrict_width_to_image) : ?>
								height: <?php echo $height; ?>px;
							<?php endif; ?>
						}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a img {
								max-height: 100%;
								border: 0;
								<?php if ($restrict_width_to_image) : ?>
									position: relative;
								<?php else : ?>
									position: absolute;
									left: 50%;
									<?php if ($center_vertically) : ?>
										top: 50%;
										transform: translate(-50%, -50%);
									<?php else : ?>
										transform: translateX(-50%);
									<?php endif; ?>
								<?php endif; ?>
							}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link.smooth a img {
								-webkit-transition: opacity .4s ease; transition: opacity .4s ease;
							}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a img.original {
								opacity: 1; filter: alpha(opacity=100);
							}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a img.hover {
								opacity: 0; filter: alpha(opacity=0);
								z-index: 2;
								<?php if ($restrict_width_to_image) : ?>
									position: absolute;
									left: 50%;
									<?php if ($center_vertically) : ?>
										top: 50%;
										transform: translate(-50%, -50%);
									<?php else : ?>
										transform: translateX(-50%);
									<?php endif; ?>
								<?php endif; ?>
							}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a:hover img.hover,
							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a:focus img.hover {
								opacity: 1; filter: alpha(opacity=100);
							}

							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a:hover img.original,
							.wlp_<?php echo $suffix; ?> ul.weblink_items li .logo_link a:focus img.original {
								opacity: 0; filter: alpha(opacity=0);
							}

				.wlp_<?php echo $suffix; ?> ul.weblink_items li .description {
					font-size: <?php echo ($font_size / 100); ?>em;
					text-align: left;
				}

				html[dir="rtl"] .wlp_<?php echo $suffix; ?> ul.weblink_items li .description {
					text-align: right;
				}

				.wlp_<?php echo $suffix; ?> ul.weblink_items.list li .description {
					-webkit-box-flex: 1;
    				-ms-flex: 1;
					flex: 1;

					<?php if (!$logo_solo) : ?>
						margin: <?php echo $padding; ?>px 0 0 <?php echo $padding; ?>px; /* emulated gap */
					<?php endif; ?>
				}

				<?php if (!$logo_solo) : ?>
					html[dir="rtl"] .wlp_<?php echo $suffix; ?> ul.weblink_items.list li .description {
						margin: <?php echo $padding; ?>px <?php echo $padding; ?>px 0 0; /* emulated gap */
					}
				<?php endif; ?>

				.wlp_<?php echo $suffix; ?> ul.weblink_items.grid li .description {
					text-align: <?php echo $content_align; ?>;
					padding-top: <?php echo $padding; ?>px;
				}

					.wlp_<?php echo $suffix; ?> ul.weblink_items li .title {
						margin-top: 0;
						word-wrap: normal;
					}

					.wlp_<?php echo $suffix; ?> ul.weblink_items li .hits {
						display: inline-block;
					}

.wlp_<?php echo $suffix; ?> .pagination_wrapper {
	clear: both;
	width: 100%;
	padding: 10px 0;
}

	.wlp_<?php echo $suffix; ?> .pagination_wrapper .pull-right,
	.wlp_<?php echo $suffix; ?> .pagination_wrapper .float-right,
	.wlp_<?php echo $suffix; ?> .pagination_wrapper .float-end {
		margin-left: 5px;
	}

	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .pagination_wrapper .pull-right,
	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .pagination_wrapper .float-right,
	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .pagination_wrapper .float-end {
		margin-left: 0;
		margin-right: 5px;
	}

	.wlp_<?php echo $suffix; ?> .pagination_wrapper .counterpagination,
	.wlp_<?php echo $suffix; ?> .pagination_wrapper .countertotal {
		text-align: center;
	}

	.wlp_<?php echo $suffix; ?> .searchblock,
	.wlp_<?php echo $suffix; ?> .clearblock {
		display: inline-block;
		margin-bottom: 5px;
	}

	.wlp_<?php echo $suffix; ?> .searchblock .options label {
		font-size: 0.85em;
	}

	.wlp_<?php echo $suffix; ?> .index_filter.listing {
		clear: both;
	}

	.wlp_<?php echo $suffix; ?> .pagination_limit,
	.wlp_<?php echo $suffix; ?> .index_filter.selection {
		float: right;
		margin: 0 0 5px 5px;
	}

	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .pagination_limit,
	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .index_filter.selection {
		float: left;
		margin: 0 5px 5px 0;
	}

	.wlp_<?php echo $suffix; ?> .index_filter.selection > label {
		vertical-align: inherit;
		padding: 0 5px 0 0;
		margin: 0;
		display: inline-block;
	}

	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .index_filter.selection > label {
		padding: 0 0 0 5px;
	}

	.wlp_<?php echo $suffix; ?> .pagination_limit select,
	.wlp_<?php echo $suffix; ?> .index_filter.selection select {
		display: inline-block;
		margin: 0;
		width: auto;
	}

	.wlp_<?php echo $suffix; ?> .index_filter.listing ul {
		text-align: center;
		list-style: none;
		margin: 0;
		padding: 0;
	}

	.wlp_<?php echo $suffix; ?> .index_filter.listing ul[data-label]::before {
		content: attr(data-label);
		padding: 0 5px 0 0;
	}

	html[dir="rtl"] .wlp_<?php echo $suffix; ?> .index_filter.listing ul[data-label]::before {
		padding: 0 0 0 5px;
	}

		.wlp_<?php echo $suffix; ?> .index_filter.listing ul li {
		    list-style-type: none;
			display: inline-block;
			margin: 2px;
		}

			.wlp_<?php echo $suffix; ?> .index_filter.listing li.selected a {
				font-weight: bolder;
				text-decoration: underline;
			}

			.wlp_<?php echo $suffix; ?> .index_filter.listing li a {
				display: inline-block;
			}

			.wlp_<?php echo $suffix; ?> .index_filter.listing li a img {
				vertical-align: middle;
				max-width: 32px;
				max-height: 32px;
				margin-right: 2px;
			}

			.wlp_<?php echo $suffix; ?> .index_filter.listing li a .nocategorypicture {
				display: inline-block;
				background-color: transparent;
				vertical-align: middle;
				width: 32px;
				height: 32px;
				margin-right: 2px;
			}

/* label links */

.wlp_<?php echo $suffix; ?> .label span,
.wlp_<?php echo $suffix; ?> .label .icon {
	vertical-align: middle;
}

.wlp_<?php echo $suffix; ?> .label a,
.wlp_<?php echo $suffix; ?> .label a:hover,
.wlp_<?php echo $suffix; ?> .label a:focus {
	color: #fff;
}