<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

/** @var \SYW\Component\WeblinkLogosPro\Site\View\Weblink\HtmlView $this */

$wam = Factory::getApplication()->getDocument()->getWebAssetManager();

// jQuery (through the Joomla framework) is required for the form to work

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator');

if ($this->load_bootstrap) {
	HTMLHelper::_('bootstrap.tab');
	HTMLHelper::_('bootstrap.tooltip', '.hasTooltip');
}

if ($this->params->get('load_chosen_script', 0)) {
	HTMLHelper::_('formbehavior.chosen', 'select');
}

$lang = Factory::getLanguage();
$lang->load('com_weblinklogospro', JPATH_SITE);

FormHelper::addFieldPrefix('SYW\Library\Field');

$wam->addInlineScript("Joomla.submitbutton = function(task) {
	if (task == 'weblink.cancel' || document.formvalidator.isValid(document.getElementById('form-weblink'))) {
		Joomla.submitform(task, document.getElementById('form-weblink'));
	}
}");

if ($this->bootstrap_version > 0) {
    
    $script = '';

    if ($this->bootstrap_version < 5) {
        HTMLHelper::_('jquery.framework');
        
    	$script .= 'jQuery(function($) { ';
    		$script .= '$("#weblinkTab a").click(function (e) { ';
    			$script .= 'e.preventDefault(); ';
    			$script .= '$(this).tab("show"); ';
    		$script .= '}); ';
    	$script .= '}); ';
    }

	// accessibility not handled by Bootstrap
	if ($this->bootstrap_version == 2 || $this->bootstrap_version == 3) {
		$script .= 'document.addEventListener("readystatechange", function(event) { ';
			$script .= 'if (event.target.readyState === "complete") { ';
				$script .= 'var tabs = document.querySelectorAll("ul.nav-tabs li"); ';
				$script .= 'for (var i = 0; i < tabs.length; i++) { ';
					$script .= 'tabs[i].addEventListener("click", function() { ';
						$script .= 'for (var j = 0; j < tabs.length; j++) { ';
							$script .= 'tabs[j].firstChild.setAttribute("aria-selected", "false"); ';
						$script .= '} ';
						$script .= 'this.firstChild.setAttribute("aria-selected", "true"); ';
					$script .= '}); ';
				$script .= '} ';
			$script .= '} ';
		$script .= '}); ';
	}

	if ($script) {
	    $wam->addInlineScript($script);
	}
} else {

	$style = '.tab-pane { display: none; padding: 15px; } ';
	$style .= '.tab-pane.active { display: inherit; } ';
	$style .= 'ul.nav-tabs { margin: 0; padding: 0; list-style: none; overflow: hidden; } ';
	$style .= 'ul.nav-tabs li { display: inline-block; cursor: pointer; opacity: .7; } ';
	$style .= 'ul.nav-tabs li.active { opacity: 1; } ';
	$style .= 'ul.nav-tabs li a { padding: 10px 15px; cursor: pointer; } ';

	$wam->addInlineStyle($style);

	$script = 'document.addEventListener("readystatechange", function(event) { ';
		$script .= 'if (event.target.readyState === "complete") { ';
			$script .= 'var tabs = document.querySelectorAll("ul.nav-tabs li"); ';
			$script .= 'for (var i = 0; i < tabs.length; i++) { ';
				$script .= 'tabs[i].addEventListener("click", function() { ';
					$script .= 'var tab_panes = document.querySelectorAll(".tab-pane"); ';
					$script .= 'for (var j = 0; j < tab_panes.length; j++) { ';
						$script .= 'tab_panes[j].classList.remove("active"); ';
					$script .= '} ';
					$script .= 'for (var j = 0; j < tabs.length; j++) { ';
						$script .= 'tabs[j].classList.remove("active"); ';
						$script .= 'tabs[j].firstChild.setAttribute("aria-selected", "false"); ';
					$script .= '} ';
					$script .= 'this.classList.add("active"); ';
					$script .= 'this.firstChild.setAttribute("aria-selected", "true"); ';
					$script .= 'var pane_id = this.firstChild.getAttribute("href").replace("#", ""); ';
					$script .= 'document.getElementById(pane_id).classList.add("active"); ';
				$script .= '}); ';
			$script .= '} ';
		$script .= '} ';
	$script .= '}); ';

	$wam->addInlineScript($script);
}
?>
<div class="weblink-edit front-end-edit">
	<?php if (!$this->canEdit) : ?>
		<h3>
			<?php throw new \Exception(Text::_('COM_WEBLINKLOGOSPRO_ERROR_MESSAGE_EDITWEBLINK_NOT_AUTHORISED'), 403); ?>
		</h3>
	<?php else : ?>
		<?php if (!$this->isWeblinkNew): ?>
			<h1><?php echo Text::_('COM_WEBLINKLOGOSPRO_EDIT_WEBLINK_TITLE'); ?></h1>
		<?php else: ?>
			<h1><?php echo Text::_('COM_WEBLINKLOGOSPRO_NEW_WEBLINK_TITLE'); ?></h1>
		<?php endif; ?>

		<form id="form-weblink" method="post" class="form-validate form-horizontal" enctype="multipart/form-data">

        	<input type="hidden" name="jform[id]" value="<?php echo $this->isWeblinkNew ? '' : $this->item->id; ?>" />

        	<?php if (!$this->config->get('show_category', 1)): ?>
        		<input type="hidden" name="jform[catid]" value="<?php echo $this->isWeblinkNew ? $this->config->get('catid_default', 0) : $this->item->catid; ?>" />
        	<?php endif; ?>

			<?php if (!$this->config->get('show_published', 1)): ?>
        		<input type="hidden" name="jform[state]" value="<?php echo $this->isWeblinkNew ? $this->config->get('published_default', 0) : $this->item->state; ?>" />
        	<?php endif; ?>

			<?php if (!$this->config->get('show_access', 1)): ?>
        		<input type="hidden" name="jform[access]" value="<?php echo $this->isWeblinkNew ? $this->config->get('access_default', 0) : $this->item->access; ?>" />
        	<?php endif; ?>

        	<?php if (!$this->config->get('show_target', 1)): ?>
        		<input type="hidden" name="jform[params][target]" value="<?php echo $this->isWeblinkNew ? $this->config->get('target_default', 1) : json_decode($this->item->params)->target; ?>" />
        	<?php endif; ?>

        	<?php if (!$this->config->get('show_clickcount', 1)): ?>
        		<input type="hidden" name="jform[params][count_clicks]" value="<?php echo $this->isWeblinkNew ? $this->config->get('clickcount_default', 0) : json_decode($this->item->params)->count_clicks; ?>" />
        	<?php endif; ?>
        	
        	<fieldset>

        	<?php echo $this->form->renderField('title'); ?>

        	<?php if (is_null($this->item->id)) : ?>
        		<?php echo $this->form->renderField('alias'); ?>
        	<?php else : ?>
        		<input type="hidden" name="jform[alias]" value="<?php echo $this->item->alias; ?>" />
        	<?php endif; ?>

			<?php /*echo HTMLHelper::_('bootstrap.startTabSet', 'myTab', array('active' => 'details'));*/ ?>
			<ul class="nav nav-tabs" id="weblinkTabTabs" role="tablist">

				<?php if ($this->bootstrap_version < 3) : ?>
					<?php $attributes = 'id="details-tab" href="#details" aria-controls="details" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="true"'; ?>
					<li class="active"><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_DETAILS'); ?></a></li>
				<?php elseif ($this->bootstrap_version == 3) : ?>
					<?php $attributes = 'id="details-tab" href="#details" aria-controls="details" role="tab" data-toggle="tab" aria-selected="true"'; ?>
					<li role="presentation" class="active"><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_DETAILS'); ?></a></li>
				<?php elseif ($this->bootstrap_version >= 4) : ?>
					<?php $attributes = 'id="details-tab" href="#details" aria-controls="details" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="true"'; ?>
					<li class="nav-item"><a class="nav-link active" <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_DETAILS'); ?></a></li>
				<?php endif; ?>

				<?php if ($this->bootstrap_version < 3) : ?>
					<?php $attributes = 'id="images-tab" href="#images" aria-controls="images" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="true"'; ?>
					<li><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_IMAGES'); ?></a></li>
				<?php elseif ($this->bootstrap_version == 3) : ?>
					<?php $attributes = 'id="images-tab" href="#images" aria-controls="images" role="tab" data-toggle="tab" aria-selected="true"'; ?>
					<li role="presentation"><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_IMAGES'); ?></a></li>
				<?php elseif ($this->bootstrap_version >= 4) : ?>
					<?php $attributes = 'id="images-tab" href="#images" aria-controls="images" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="true"'; ?>
					<li class="nav-item"><a class="nav-link" <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_IMAGES'); ?></a></li>
				<?php endif; ?>
				
				<?php if (!empty($this->edit_fields) && is_object($this->edit_fields)) : ?>
					<?php if ($this->bootstrap_version < 3) : ?>
						<?php $attributes = 'id="fields-tab" href="#fields" aria-controls="fields" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="true"'; ?>
						<li><a <?php echo $attributes; ?>><?php echo Text::_('JGLOBAL_FIELDS'); ?></a></li>
					<?php elseif ($this->bootstrap_version == 3) : ?>
						<?php $attributes = 'id="fields-tab" href="#fields" aria-controls="fields" role="tab" data-toggle="tab" aria-selected="true"'; ?>
						<li role="presentation"><a <?php echo $attributes; ?>><?php echo Text::_('JGLOBAL_FIELDS'); ?></a></li>
					<?php elseif ($this->bootstrap_version >= 4) : ?>
						<?php $attributes = 'id="fields-tab" href="#fields" aria-controls="fields" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="true"'; ?>
						<li class="nav-item"><a class="nav-link" <?php echo $attributes; ?>><?php echo Text::_('JGLOBAL_FIELDS'); ?></a></li>
					<?php endif; ?>
					
				<?php endif; ?>
				<?php if (isset($this->edit_group_fields) && !is_string($this->edit_group_fields)) : ?>
					<?php foreach ($this->edit_group_fields as $group_field) :  ?>
						<?php if (!empty($this->fieldsPerGroup[$group_field->group])) : ?>
							<?php  if ($this->bootstrap_version < 3) : ?>
								<?php $attributes = 'id="group_' . $group_field->group . '-tab" href="#group_' . $group_field->group . '" aria-controls="group_' . $group_field->group . '" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="false"'; ?>
								<li><a <?php echo $attributes; ?>><?php echo $this->groupTitle[$group_field->group]; ?></a></li>
							<?php elseif ($this->bootstrap_version == 3) : ?>
								<?php $attributes = 'id="group_' . $group_field->group . '-tab" href="#group_' . $group_field->group . '" aria-controls="group_' . $group_field->group . '" role="tab" data-toggle="tab" aria-selected="false"'; ?>
								<li role="presentation"><a <?php echo $attributes; ?>><?php echo $this->groupTitle[$group_field->group]; ?></a></li>
							<?php elseif ($this->bootstrap_version >= 4) : ?>
								<?php $attributes = 'id="group_' . $group_field->group . '-tab" href="#group_' . $group_field->group . '" aria-controls="group_' . $group_field->group . '" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="false"'; ?>
								<li class="nav-item"><a class="nav-link" <?php echo $attributes; ?>><?php echo $this->groupTitle[$group_field->group]; ?></a></li>
							<?php endif; ?>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>

				<?php if ($this->bootstrap_version < 3) : ?>
					<?php $attributes = 'id="publishing-tab" href="#publishing" aria-controls="publishing" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="true"'; ?>
					<li><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_PUBLISHING'); ?></a></li>
				<?php elseif ($this->bootstrap_version == 3) : ?>
					<?php $attributes = 'id="publishing-tab" href="#publishing" aria-controls="publishing" role="tab" data-toggle="tab" aria-selected="true"'; ?>
					<li role="presentation"><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_PUBLISHING'); ?></a></li>
				<?php elseif ($this->bootstrap_version >= 4) : ?>
					<?php $attributes = 'id="publishing-tab" href="#publishing" aria-controls="publishing" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="true"'; ?>
					<li class="nav-item"><a class="nav-link" <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_PUBLISHING'); ?></a></li>
				<?php endif; ?>

				<?php if ($this->bootstrap_version < 3) : ?>
					<?php $attributes = 'id="metadata-tab" href="#metadata" aria-controls="metadata" role="tab"' . ($this->bootstrap_version > 0 ? ' data-toggle="tab"' : ' onclick="return false;"') . ' aria-selected="true"'; ?>
					<li><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_METADATA'); ?></a></li>
				<?php elseif ($this->bootstrap_version == 3) : ?>
					<?php $attributes = 'id="metadata-tab" href="#metadata" aria-controls="metadata" role="tab" data-toggle="tab" aria-selected="true"'; ?>
					<li role="presentation"><a <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_METADATA'); ?></a></li>
				<?php elseif ($this->bootstrap_version >= 4) : ?>
					<?php $attributes = 'id="metadata-tab" href="#metadata" aria-controls="metadata" role="tab" data-' . ($this->bootstrap_version >= 5 ? 'bs-' : '') . 'toggle="tab" aria-selected="true"'; ?>
					<li class="nav-item"><a class="nav-link" <?php echo$attributes; ?>><?php echo Text::_('COM_WEBLINKLOGOSPRO_METADATA'); ?></a></li>
				<?php endif; ?>

			</ul>
			<div class="tab-content" id="weblinkTabContent">

	    	    <?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'details', Text::_('COM_WEBLINKLOGOSPRO_DETAILS'));*/ ?>
	    	    <div id="details" class="tab-pane active" role="tabpanel" aria-labelledby="details-tab">

	    			<?php echo $this->form->renderField('url'); ?>

	    			<?php if ($this->config->get('show_target', 1)): ?>
	    				<?php echo $this->form->renderField('target', 'params', $this->isWeblinkNew ? $this->config->get('target_default', 0) : json_decode($this->item->params)->target); ?>
	    			<?php endif; ?>

	    			<?php echo $this->form->renderField('width', 'params'); ?>

	    			<?php echo $this->form->renderField('height', 'params'); ?>

	    			<?php if ($this->config->get('show_clickcount', 1)): ?>
	    				<?php echo $this->form->renderField('count_clicks', 'params', $this->isWeblinkNew ? $this->config->get('clickcount_default', 0) : json_decode($this->item->params)->count_clicks); ?>
	    			<?php endif; ?>

	    			<?php echo $this->form->renderField('description'); ?>

	    	    <?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
		        </div>

	    	    <?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'images', Text::_('COM_WEBLINKLOGOSPRO_IMAGES'));*/ ?>
	    	    <div id="images" class="tab-pane" role="tabpanel" aria-labelledby="images-tab">

	    			<?php echo $this->form->renderField('image_first', 'images'); ?>

	    			<?php echo $this->form->renderField('image_first_alt', 'images'); ?>

	    			<?php echo $this->form->renderField('image_first_caption', 'images'); ?>

	    			<?php echo $this->form->renderField('float_first', 'images'); ?>

	    			<?php echo $this->form->renderField('spacer_images', 'images'); ?>

	    			<?php echo $this->form->renderField('image_second', 'images'); ?>

	    			<?php echo $this->form->renderField('image_second_alt', 'images'); ?>

	    			<?php echo $this->form->renderField('image_second_caption', 'images'); ?>

	    			<?php echo $this->form->renderField('float_second', 'images'); ?>

	    	    <?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
		        </div>

		        <?php if (!empty($this->edit_fields) && is_object($this->edit_fields)) : ?>
	        	    <?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'fields', Text::_('COM_WEBLINKLOGOSPRO__FIELDS'));*/ ?>
					<div id="fields" class="tab-pane" role="tabpanel" aria-labelledby="fields-tab">

	        	    	<?php foreach ($this->edit_fields as $edit_field) :  ?>
	        	    		<?php if ($edit_field->field != 'section') : ?>
	        	    			<?php $complexname = explode("_", $edit_field->field); ?>
	        	    			<?php if ($complexname[0] == 'customfields') : ?>
	        	    				<?php if (trim($edit_field->label) !== '') : ?>
	        	    					<?php $this->form->setFieldAttribute($complexname[1], 'label', Text::_($edit_field->label), $complexname[0]); ?>
									<?php endif; ?>
	    							<?php if (trim($edit_field->description) !== '') : ?>
	        	    					<?php $this->form->setFieldAttribute($complexname[1], 'description', Text::_($edit_field->description), $complexname[0]); ?>
	    							<?php endif; ?>
	        	    				<?php echo $this->form->renderField($complexname[1], $complexname[0]); ?>
	        	    			<?php else : ?>
									<?php if (trim($edit_field->label) !== '') : ?>
	        	    					<?php $this->form->setFieldAttribute($edit_field->field, 'label', Text::_($edit_field->label)); ?>
									<?php endif; ?>
	    							<?php if (trim($edit_field->description) !== '') : ?>
	        	    					<?php $this->form->setFieldAttribute($edit_field->field, 'description', Text::_($edit_field->description)); ?>
	    							<?php endif; ?>
	        	    				<?php echo $this->form->renderField($edit_field->field); ?>
	        	    			<?php endif; ?>
	        	    		<?php else : ?>
	        	    			<?php if ($edit_field->label) : ?>
	        	    				<h3><?php echo $edit_field->label; ?></h3>
	        	    			<?php else : ?>
	        	    				<hr>
	        	    			<?php endif; ?>
	        	    		<?php endif; ?>
	        	    	<?php endforeach; ?>
	        	    <?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
	        	    </div>
	        	<?php endif; ?>	        
		        
		        <?php if (isset($this->edit_group_fields) && !is_string($this->edit_group_fields)) : ?>
					<?php foreach ($this->edit_group_fields as $group_field) :  ?>
						<?php if (!empty($this->fieldsPerGroup[$group_field->group])) : ?>
							<?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'group_' . $group_field->group, $this->groupTitle[$group_field->group]);*/ ?>
							<div id="group_<?php echo $group_field->group; ?>" class="tab-pane" role="tabpanel" aria-labelledby="group_<?php echo $group_field->group; ?>-tab">

								<?php //echo $this->form->renderFieldset('fields_' . $group_field->group); ?>
								<?php foreach ($this->fieldsPerGroup[$group_field->group] as $key => $edit_field) : ?>
									<?php echo $this->form->renderField($edit_field->name, 'customfields'); ?>
								<?php endforeach; ?>

							<?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
							</div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>		        

	        	<?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'publishing', Text::_('COM_WEBLINKLOGOSPRO_PUBLISHING'));*/ ?>
	        	<div id="publishing" class="tab-pane" role="tabpanel" aria-labelledby="publishing-tab">

					<?php if ($this->config->get('show_category', 1)): ?>
						<?php echo $this->form->renderField('catid', null, $this->isWeblinkNew ? $this->config->get('catid_default', 0) : $this->item->catid); ?>
					<?php endif; ?>

					<?php if ($this->config->get('show_published', 1)): ?>
						<?php echo $this->form->renderField('state', null, $this->isWeblinkNew ? $this->config->get('published_default', 0) : $this->item->state); ?>
					<?php endif; ?>

					<?php if ($this->config->get('show_access', 1)): ?>
						<?php echo $this->form->renderField('access', null, $this->isWeblinkNew ? $this->config->get('access_default', 0) : $this->item->access); ?>
					<?php endif; ?>

					<?php echo $this->form->renderField('language', null, $this->isWeblinkNew ? '*' : $this->item->language); ?>

					<?php echo $this->form->renderField('tags'); ?>

	        	<?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
		        </div>

	        	<?php /*echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'metadata', Text::_('COM_WEBLINKLOGOSPRO_METADATA'));*/ ?>
	        	<div id="metadata" class="tab-pane" role="tabpanel" aria-labelledby="metadata-tab">

	        		<?php echo $this->form->renderField('metadesc'); ?>

	        		<?php echo $this->form->renderField('metakey'); ?>

	        		<?php echo $this->form->renderField('robots', 'metadata'); ?>

	        		<?php echo $this->form->renderField('rights', 'metadata'); ?>

	        	<?php /*echo HTMLHelper::_('bootstrap.endTab');*/ ?>
		        </div>

			<?php /*echo HTMLHelper::_('bootstrap.endTabSet');*/ ?>
			</div>

			<?php if ($this->captchaEnabled) : ?>
				<hr class="hr-condensed" />
    			<?php echo $this->form->renderField('captcha'); ?>
    		<?php endif; ?>
    		
    		</fieldset>

			<div class="btn-toolbar" role="toolbar">
				<?php if ($this->canSave): ?>
					<div class="btn-group me-1">
						<button type="button" class="validate btn btn-primary" onclick="Joomla.submitbutton('weblink.apply')">
							<span class="icon-check" aria-hidden="true"></span>
							<?php echo Text::_('JSAVE'); ?>
						</button>
					</div>
					<div class="btn-group me-1">
						<button type="button" class="validate btn btn-primary" onclick="Joomla.submitbutton('weblink.save')">
							<span class="icon-check" aria-hidden="true"></span>
							<?php echo Text::_('COM_WEBLINKLOGOSPRO_SAVEANDCLOSE'); ?>
						</button>
					</div>
				<?php endif; ?>
				<div class="btn-group">
					<button type="button" class="btn btn-danger" onclick="Joomla.submitbutton('weblink.cancel')">
						<span class="icon-times" aria-hidden="true"></span>
						<?php echo Text::_('JCANCEL'); ?>
					</button>
				</div>
			</div>

			<input type="hidden" name="option" value="com_weblinklogospro" />
			<input type="hidden" name="task" />
			<?php if ($this->return_page) : ?><input type="hidden" name="return" value="<?php echo $this->return_page; ?>" /><?php endif; ?>
			<?php echo HTMLHelper::_('form.token'); ?>
		</form>
	<?php endif; ?>
</div>
