﻿<?php 
/**
 * @Securitycheckpro component
 * @copyright Copyright (c) 2011 - Jose A. Luque / Securitycheck Extensions
 * @license   GNU General Public License version 3, or later
 */

// Protect from unauthorized access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

Session::checkToken('get') or die('Invalid Token');

HTMLHelper::_('bootstrap.tooltip', '.hasTooltip');

$kind_array = array(HTMLHelper::_('select.option', Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FILE'), Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FILE')),
    HTMLHelper::_('select.option', Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FOLDER'), Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FOLDER')));
            
$status_array = array(HTMLHelper::_('select.option', '0', Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_TITLE_SUSPICIOUS')),
    HTMLHelper::_('select.option', '2', Text::_('COM_SECURITYCHECKPRO_FILEINTEGRITY_IN_EXCEPTIONS_LIST')),
    HTMLHelper::_('select.option', '3', Text::_('COM_SECURITYCHECKPRO_FILEINTEGRITY_QUARANTINED')));

// styles ('data-xxx' for J3 and 'data-bs-xxxx' for J4)
$data_dismiss = "data-dismiss";
$list_group_style = 'class="margin-right-5" style="width: fit-content;"';

if (version_compare(JVERSION, '4.0', 'ge')) {	
	$data_dismiss = "data-bs-dismiss";
	$list_group_style = 'style="width: fit-content;"';
}

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

if (empty($this->last_check_malwarescan) ) {
    $this->last_check_malwarescan = Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER');
}
if (empty($this->files_status) ) {
    $this->files_status = Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_NOT_DEFINED');
}
?>

<form action="<?php echo Route::_('index.php?option=com_securitycheckpro&controller=filemanager&view=malwarescan&'. Session::getFormToken() .'=1');?>" method="post" class="margin-left-10 margin-right-10" name="adminForm" id="adminForm">

    <!-- Modal view file -->
        <div class="modal" id="view_file" tabindex="-1" role="dialog" aria-labelledby="viewfileLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header alert alert-info">
                <h2 class="modal-title" id="viewfileLabel"><?php echo Text::_('COM_SECURITYCHECKPRO_FILE_CONTENT'); ?></h2>
                <button type="button" class="close" <?php echo $data_dismiss; ?>="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">    
                <textarea rows="10" class="table">        
                <?php 
                $mainframe = Factory::getApplication();
                $contenido = $mainframe->getUserState('contenido', "vacio");
                echo $contenido;
                ?></textarea>    
              </div>
                <div class="modal-footer">                    
                    <button type="button" class="btn btn-default" <?php echo $data_dismiss; ?>="modal"><?php echo Text::_('COM_SECURITYCHECKPRO_CLOSE'); ?></button>
                </div>              
            </div>
          </div>
        </div>

<?php 
        // Cargamos la navegación
        require JPATH_ADMINISTRATOR.'/components/com_securitycheckpro/helpers/navigation.php';		
?>
                
          
            <!-- Contenido principal -->            
            <div class="row">
                
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
							<?php echo Text::_('COM_SECURITYCHECKPRO_DEEP_SCAN_STATUS'); ?>
                        </div>
                        <div class="card-body">                
							<span class="fa fa-2x fa-search" style="color:green"></span>                            
                            <div>
                                <span class="badge bg-info"><?php echo $this->deep_scan_status; ?></span>                        
                            </div>                        
                            <div class="margin-top-10">
                                <span id="more_info_deep_scan" data-bs-toggle="tooltip" title="<?php echo Text::_('COM_SECURITYCHECKPRO_DEEP_SCAN_CONTENT'); ?>" class="badge bg-dark"><?php echo Text::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
							<?php echo Text::_('COM_SECURITYCHECKPRO_CONFIG_ONLINE_SUBMISSION_TYPE_LABEL'); ?>
                        </div>
                        <div class="card-body"> 
							<span class="fa fa-2x fa-paper-plane" style="color:red"></span>                            
                            <div>
                                <span class="badge bg-info"><?php echo $this->online_submission_type; ?></span>                                            
                            </div>
                            <div class="margin-top-10">
                                <span id="more_info_submission_type" data-bs-toggle="tooltip" title="<?php echo Text::_('COM_SECURITYCHECKPRO_SUBMISSION_TYPE_CONTENT'); ?>" class="badge bg-dark"><?php echo Text::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
							<?php echo Text::_('COM_SECURITYCHECKPRO_CONFIG_TIMELINE_LABEL'); ?>
                        </div>
                        <div class="card-body">             
							<span class="fa fa-2x fa-calendar-day" style="color:blue"></span>
                            <div>
                                <span class="badge bg-info">
                                <?php 
                                if ($this->timeline == 1 ) {
                                    echo Text::_('COM_SECURITYCHECKPRO_YESTERDAY');
                                } else if ($this->timeline == 7 ) {
                                    echo Text::_('COM_SECURITYCHECKPRO_A_WEEK_AGO');
                                } else if ($this->timeline == 30 ) {
                                    echo Text::_('COM_SECURITYCHECKPRO_A_MONTH_AGO');
                                } else if ($this->timeline == 10000 ) {
                                    echo Text::_('COM_SECURITYCHECKPRO_ANYTIME');
                                }
                                ?>
                                </span>                        
                            </div>                        
                            <div class="margin-top-10">
                                <span id="more_info_timeline" data-bs-toggle="tooltip" title="<?php echo Text::_('COM_SECURITYCHECKPRO_CONFIG_TIMELINE_DESCRIPTION'); ?>" class="badge bg-dark"><?php echo Text::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
            
                <div class="col-xl-5 col-sm-5 mb-5" class="margin-bottom-3rem">
                    <div class="card text-center">    
                        <div class="card-header">
        <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_STATUS'); ?>                            
                        </div>
                        <div class="row card-body" class="justify-content-center">                                
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item active" class="font-size-13"><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_STARTTIME'); ?></li>
                                    <li class="list-group-item"><span id="start_time" class="badge bg-dark"><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER'); ?></span></li>
                                </ul>
                            </div>                            
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item active" class="font-size-13"><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_TASK'); ?></li>
                                    <li class="list-group-item">
                                        <span id="task_status" class="badge bg-info"><?php echo $this->files_status; ?></span>
                                        <span id="task_error" class="badge bg-danger none">Error</span>
                                    </li>
                                </ul>
                            </div>                                                    
                        </div>                        
                        <div id="button_start_scan" class="card-footer">
                            <button class="btn btn-primary" id="start_scan_button" type="button"><i class="fa fa-fire"></i><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_START_BUTTON'); ?></button>
                        </div>                        
                    </div>
                </div>
                
                <div class="col-xl-7 col-sm-7 mb-7">
                    <div class="card text-center">    
                        <div class="card-header">
        <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_RESULT_HEADER'); ?>
                        </div>
                        <div class="row card-body" class="justify-content-center">
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_LAST_CHECK'); ?></li>
                                    <li class="list-group-item"><span class="badge bg-dark"><?php echo $this->last_check_malwarescan; ?></span></li>
                                </ul>
                            </div>
							<div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo Text::_('COM_SECURITYCHECKPRO_TIME_TAKEN'); ?></li>
                                    <li class="list-group-item"><span class="badge bg-dark"><?php echo $this->time_taken; ?></span></li>
                                </ul>
                            </div>
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_FILES_SCANNED'); ?></li>
                                    <li class="list-group-item"><span class="badge bg-dark"><?php echo $this->files_scanned_malwarescan; ?></span></li>
                                </ul>                                
                            </div>
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success" class="font-size-13"><?php echo Text::_('COM_SECURITYCHECKPRO_SUSPICIOUS_FILES'); ?></li>
                                    <li class="list-group-item">
            <?php
            if ($this->suspicious_files > 0 ) {
                ?>        
                                        <span class="badge bg-danger">
            <?php } else {    ?>
                                        <span class="badge bg-success">
            <?php	}    ?>
            <?php echo $this->suspicious_files; ?></span>
                                    </li>
                                </ul>
                            </div>                        
                        </div>
                        <div id="button_show_log" class="card-footer">    
        <?php	                            
        if (!empty($this->log_filename) ) { ?>
                                    <button class="btn btn-success" id="view_modal_log_button" type="button"><i class="fa fa-eye"></i><?php echo substr(Text::_('COM_SECURITYCHECKPRO_ACTION_VIEWLOGS'), 0, -1); ?></button>
        <?php }    ?>                            
                        </div>                            
                    </div>                    
                </div>
                
                 <div id="scandata" class="col-lg-12 margin-top-20">
                    <div class="card mb-3">                        
                        <div class="card-body" class="margin-left-10">
                            <div id="container_repair">
                                <div id="log-container_remember_text" class="centrado margen texto_14">
                                </div>
                                <div id="div_view_log_button" class="buttonwrapper">    
                                </div>                            
                                <div id="log-container_header" class="centrado margen texto_20">    
                                </div>
                            </div>
                            
                            <div id="error_message_container" class="securitycheck-bootstrap centrado margen-container">
                                <div id="error_message">
                                </div>    
                            </div>

                            <div id="error_button" class="securitycheck-bootstrap centrado margen-container">    
                            </div>
                            
                            <div id="memory_limit_message" class="securitycheck-bootstrap centrado margen-loading texto_14">
                                <?php 
                                    // Extract 'memory_limit' value cutting the last character
                                    $memory_limit = ini_get('memory_limit');
                                    $memory_limit = (int) substr($memory_limit, 0, -1);
                                            
                                    // If $memory_limit value is less or equal than 128, shows a warning if no previous scans have finished
                                if (($memory_limit <= 128) && ($this->last_check_malwarescan == Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER')) ) {
                                    $span = "<span class=\"label label-warning\">";
                                    echo $span . Text::_('COM_SECURITYCHECKPRO_MEMORY_LIMIT_LOW') . "</span>";
                                }
                                ?>
                            </div>

                            <div id="completed_message2" class="centrado margen-loading color_verde">    
                            </div>
                                                        
                            <div id="warning_message2" class="centrado margen-loading">                                
                            </div>
                                                                            
                            <div id="backup-progress" class="progress" class="margin-bottom-20">
                                <div id="bar" class="progress-bar bg-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>    
                            
                            <div class="alert alert-warning">
                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARE_FOUND_RECOMMENDATION'); ?>
                            </div>
                            
                        <div id="container_resultado">
							<div id="filter-bar" class="filter-search-bar btn-group">
								<div class="input-group">
									<input type="text" class="form-control" name="filter_malwarescan_search" placeholder="<?php echo Text::_('JSEARCH_FILTER_LABEL'); ?>" id="filter_malwarescan_search" value="<?php echo $this->escape($this->state->get('filter.malwarescan_search')); ?>" title="<?php echo Text::_('JSEARCH_FILTER'); ?>" />
									<span class="filter-search-bar__label visually-hidden">
									<label id="filter_search-lbl" for="filter_search">Filter:</label>
									</span>
									<button type="submit" class="filter-search-bar__button btn btn-primary" aria-label="Search">
										<span class="filter-search-bar__button-icon icon-search" aria-hidden="true"></span>
									</button>
									<button class="btn btn-dark" type="button" id="search_filter_button" title="<?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?>"><i class="icon-remove"></i></button>
								</div>
							                                
                                <div class="input-group pull-left margin-left-10">
                                        <select name="filter_malwarescan_status" class="custom-select" onchange="this.form.submit()">
											<option value=""><?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_STATUS_DESCRIPTION');?></option>
											<?php echo HTMLHelper::_('select.options', $status_array, 'value', 'text', $this->state->get('filter.malwarescan_status'));?>
										</select>
										<?php
										if (!empty($this->items) ) {        
										?>
											<?php echo $this->pagination->getLimitBox(); ?>
										
										<?php } ?> 
                                </div>								
                            </div>							
               	 
        <?php if (!$this->items == null) { ?>
            <?php if (($this->online_submission_type == "Hashes") && ($this->online_checked_hashes >= 1000) ) { ?>
                            <div class="alert alert-danger">
                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_HASHES_ALERT'); ?>
                            </div>
            <?php } else if (($this->online_submission_type == "Files") && ($this->online_checked_files >= 25) ) { ?>
                            <div class="alert alert-danger">
                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_FILES_ALERT'); ?>
                            </div>                
            <?php } ?>
                            
            <?php if (empty($this->opswat_key) ) { ?>
                            <div class="alert alert-danger">
                <?php echo Text::_('COM_SECURITYCHECKPRO_NO_API_KEY_ALERT'); ?>
                            </div>
            <?php } ?>
                            
            <?php if ($this->database_error == "DATABASE_ERROR" ) { ?>
                            <div class="alert alert-danger">
                <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_DATABASE_ERROR'); ?>
                            </div>                            
            <?php } ?>

            <?php if ($this->show_all == 1 ) { ?>
                            <div class="alert alert-info">
                <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_INFO'); ?>
                            </div>                            
            <?php } ?>
			
			                                                       
            <?php
            if ((!empty($this->items)) && (!$this->state->get('filter.malwarescan_status')) ) {            
                ?>
                                <div id="permissions_buttons">
                                    <div class="pull-right" class="margin-bottom-10">
                                        <button class="btn btn-success" id="addfile_exception_button" class="margin-right-5" href="#">
                                            <i class="fa fa-plus"> </i>
                <?php echo Text::_('COM_SECURITYCHECKPRO_ADD_AS_EXCEPTION'); ?>
                                        </button>                                        
                                    
                <?php	
                if (!empty($this->opswat_key) ) { 
                    if (($this->online_submission_type == "Files") && ($this->online_checked_files < 25) ) { ?>
                                        <button type="button" id="online_check_files_button" data-loading-text="<?php echo Text::_('COM_SECURITYCHECKPRO_SENDING_FILES'); ?>" class="btn btn-primary" href="#">
                                            <i class="icon-upload icon-white"> </i>
                        <?php echo Text::_('COM_SECURITYCHECKPRO_SCAN_FILES'); ?>
                                        </button>
                    <?php } else if (($this->online_submission_type == "Hashes") && ($this->online_checked_hashes < 1000) ) { ?>
                                        <button type="button" id="online_check_hashes_button" data-loading-text="<?php echo Text::_('COM_SECURITYCHECKPRO_SENDING_HASHES'); ?>" class="btn btn-primary"  href="#">                        
                                            <i class="icon-upload icon-white"> </i>
                        <?php echo Text::_('COM_SECURITYCHECKPRO_SCAN_HASHES'); ?>
                                        </button>
                    <?php }                 
                } ?>
                <?php
            } else if ($this->state->get('filter.malwarescan_status') == 2 ) { ?>
                                    <div id="permissions_buttons">
                                        <div class="btn-group pull-right" class="margin-bottom-10">
                                            <button class="btn btn-danger" id="deletefile_exception_button" href="#">
                                                <i class="icon-trash icon-white"> </i>
                <?php echo Text::_('COM_SECURITYCHECKPRO_DELETE_EXCEPTION'); ?>
                                            </button>                                        
                <?php                  
            } else if ($this->state->get('filter.malwarescan_status') == 3 ) { ?>

                                    <button class="btn btn-info" id="restore_quarantined_file_button" href="#">
                                        <i class="icon-undo icon-white"> </i>
                <?php echo Text::_('COM_SECURITYCHECKPRO_RESTORE_QUARANTINED_FILE'); ?>
                                    </button>
                                    
                                    <button class="btn btn-danger" id="delete_quarantined_file_button" href="#">
                                        <i class="icon-trash icon-white"> </i>
                <?php echo Text::_('COM_SECURITYCHECKPRO_DELETE'); ?>
                                    </button>
                                        
            <?php } ?>    
                                    <!-- Permissions_buttons close divs -->
                                    </div>
                                </div>

                                <div>
                                    <span class="badge background-FF9EB4 padding-10-10-10-10"><?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_RESULTS');?></span>
                                </div>
                                <div class="table-responsive overflow-x-auto margin-top-20">
                                    <table id="malwarescan_status_table" class="table table-bordered table-hover logs-style">
                                    <thead>
                                        <tr>
											<?php 
												if ($this->checkbox_position == 1) {
											?>
											<th class="center">
                                                <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
                                            </th> 
											<?php 
												}
											?> 
                                            <th class="center malwarescan-table-info2">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_NAME'); ?>
                                            </th>
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TAMANNO'); ?>                
                                            </th>
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_LAST_MODIFIED'); ?>
                                            </th>
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_TYPE'); ?>
                                            </th>
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL'); ?>
                                            </th>
                                            <th>
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_DESCRIPTION'); ?>
                                            </th class="center">
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_CODE_DESCRIPTION'); ?>
                                            </th>
                                            <th class="center">
                                                <?php echo Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_ONLINE_CHECK'); ?>
                                            </th>
											<?php 
												if ($this->checkbox_position == 0) {
											?>
											<th class="center">
                                                <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
                                            </th> 
											<?php 
												}
											?>                                            
                                        </tr>
                                    </thead>
            <?php			
            $k = 0;			
            if (!empty($this->items) ) {    
                foreach ($this->items as &$row) {
                    $safe_malwarescan = $row['safe_malwarescan'];
                    ?>
					<?php 
					if ($this->checkbox_position == 1) {
						echo '<td class="centrado">' . HTMLHelper::_('grid.id', $k, $row['path'], '', 'malwarescan_status_table') . '</td>'; 
					}
					?>
                    <td class="centrado malwarescan-table-info">
                    <?php echo htmlspecialchars($row['path']); ?>
                    <br/>
                    <?php 
                    if ($row['moved_to_quarantine'] == 1) {
                        $span = "<span class=\"badge bg-info\">";
                        echo $span . Text::_('COM_SECURITYCHECKPRO_MOVED_TO_QUARANTINE') . "</span>";
                    }

                    ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['size']); ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['last_modified']); ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['malware_type']); ?>
                    </td>
                    <td class="centrado">
                    <?php
                    switch ($row['malware_alert_level']) {
                    case '0':
                        $span = "<span class=\"badge bg-warning\">";
                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_0') . "</span>";                            
                        break;
                    case '1':
                        $span = "<span class=\"badge bg-warning\">";
                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_1') . "</span>";
                        break;
                    case '2':
                         $span = "<span class=\"badge\">";
                         echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_2') . "</span>";
                        break;
                    } ?>
                    </td>
                    <td class="centrado">
                        <textarea cols="30" rows="1" readonly><?php echo str_replace('<br />', PHP_EOL, htmlspecialchars($row['malware_description'])); ?></textarea>        
                    </td>
                    <td class="centrado">
                        <textarea cols="30" rows="1" readonly><?php echo str_replace('<br />', PHP_EOL, htmlspecialchars($row['malware_code'])); ?></textarea>        
                    </td>
                    <td class="centrado">
                    <?php 
                    switch ($row['online_check']) {
                    case 0:
                        $span = "<span class=\"badge bg-success\">";
                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_CLEAN') . "</span>";
                        break;
                    case 1:
                        $span = "<span class=\"badge bg-warning\">";
                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_INFECTED') . "</span>";                            
                        break;
                    case 2:
                                                        $span = "<span class=\"badge bg-warning\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SUSPICIOUS') . "</span>";
                        break;
                    case 3:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_FAILED_TO_SCAN') . "</span>";
                        break;
                    case 4:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_CLEANED') . "</span>";
                        break;
                    case 5:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_UNKNOW') . "</span>";
                        break;
                    case 6:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_QUARANTINED') . "</span>";
                        break;
                    case 7:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SKIPPED_CLEAN') . "</span>";
                        break;
                    case 8:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SKIPPED_DIRTY') . "</span>";
                        break;
                    case 9:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_DEPTH') . "</span>";
                        break;
                    case 10:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_NOT_SCANNED') . "</span>";
                        break;
                    case 11:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_ABORTED') . "</span>";
                        break;
                    case 12:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_ENCRYPTED') . "</span>";
                        break;
                    case 13:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_SIZE') . "</span>";
                        break;
                    case 14:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_FILE_NUMBER') . "</span>";
                        break;
                    case 15:
                                                        $span = "<span class=\"badge bg-dark\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_HASH_NOT_FOUND') . "</span>";
                        break;
                    default:
                                                        $span = "<span class=\"badge bg-info\">";
                                                        echo $span . Text::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_NOT_CHECKED') . "</span>";
                    }
                    ?>
                                        </td>
                    <?php 
					if ($this->checkbox_position == 0) {
						echo '<td class="centrado">' . HTMLHelper::_('grid.id', $k, $row['path'], '', 'malwarescan_status_table') . '</td>'; 
					}
					?>
                    </tr>
                    <?php
                    $k = $k+1;
                }
            }

			?>
                                    </table>
                                    </div>

            <?php
            if (!empty($this->items) ) {        
                ?>
                                    <div class="margen">
                                        <div>
                <?php echo $this->pagination->getListFooter(); ?>
                                        </div>
                                    </div>
            <?php } ?>    
                                </div>
        <?php } else {
			if ($this->state->get('filter.malwarescan_status') == 2 ) {
				if ($this->file_manager_include_exceptions_in_database == 0 ) { 
					echo '<div class="alert alert-info">' . Text::_('COM_SECURITYCHECKPRO_EXCEPTIONS_NOT_INCLUDED_IN_DATABASE'). '</div>';                            
				} 
			}
		} ?>
                    </div>        
                </div>
            </div>
            
        </div>
</div>        

<input type="hidden" name="controller" value="filemanager" />
<input type="hidden" name="boxchecked" value="1" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="table" value="malwarescan" />
</form>