<?php 
/** 
 * @package GDPR::CONSENTS::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage consents
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
?>
 
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table class="headerlist">
		<tr>
			<td class="left">
				<div>
					<div class="input-group">
						<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_FILTER_RECORD');?>"><span class="icon-filter" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_FILTER_RECORD' ); ?>:</span>
						<input type="text" name="search" id="search" value="<?php echo htmlspecialchars($this->searchword, ENT_COMPAT, 'UTF-8');?>" class="text_area"/>
					</div>
					<button class="btn btn-primary btn-sm" onclick="this.form.submit();"><?php echo Text::_('COM_GDPR_GO' ); ?></button>
					<button class="btn btn-primary btn-sm" onclick="document.getElementById('search').value='';this.form.submit();"><?php echo Text::_('COM_GDPR_RESET' ); ?></button>
				</div>
				<div class="clr vspacer"></div>
				<div class="input-group input-group-date active">
					<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_FILTER_BY_DATE_FROM');?>"><span class="icon-calendar" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_FILTER_BY_DATE_FROM' ); ?>:</span>
					<input type="text" name="fromperiod" id="fromPeriod" data-role="calendar" autocomplete="off" value="<?php echo $this->dates['start'];?>" class="text_area"/>
				</div>
				
				<div class="input-group input-group-date active">
					<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_FILTER_BY_DATE_TO');?>"><span class="icon-calendar" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_FILTER_BY_DATE_TO' ); ?>:</span>
					<input type="text" name="toperiod" id="toPeriod" data-role="calendar" autocomplete="off" value="<?php echo $this->dates['to'];?>" class="text_area"/>
				</div>
				<button class="btn btn-primary btn-sm" onclick="document.adminForm.task.value='consents.display';this.form.submit();"><?php echo Text::_('COM_GDPR_GO' ); ?></button>
				<button class="btn btn-primary btn-sm" onclick="document.getElementById('fromPeriod').value='';document.getElementById('toPeriod').value='';this.form.submit();"><?php echo Text::_('COM_GDPR_RESET' ); ?></button>
			</td>
			<td class="right d-flex justify-content-end">
				<div class="input-group d-none d-md-flex flex-end">
					<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_STATE');?>"><span class="icon-filter" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_STATE' ); ?></span>
					<label class="visually-hidden" for="registered_user"><?php echo Text::_('COM_GDPR_USERS_ALL');?></label>
					<?php
						echo $this->lists['registered_user'];
					?>
					<label class="visually-hidden" for="limit"><?php echo Text::_('JGLOBAL_LIST_LIMIT');?></label>
					<?php
						echo $this->pagination->getLimitBox();
					?>
				</div>
			</td>
		</tr>
	</table>

	<table class="adminlist table table-striped table-hover">
		<thead>
			<tr>
				<th width="1%" class="title">
					<?php echo Text::_('COM_GDPR_NUM' ); ?>
				</th>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" class="form-check-input" onclick="Joomla.checkAll(this)" />
				</th>
				<th width="10%" class="title d-none d-md-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_URL', 'a.url', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>  
				<th width="8%" class="title">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_FORMID', 'a.formid', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="8%" class="title d-none d-md-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_FORMNAME', 'a.formname', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="5%" class="title">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_USERID', 'a.user_id', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="5%" class="title d-none d-xl-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_SESSIONID', 'a.session_id', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<?php if($this->logUserIpaddress):?>
				<th width="8%" class="title hidden-phone">
					<?php echo HTMLHelper::_('grid.sort',  'COM_GDPR_CONSENTS_REGISTRY_IPADDRESS', 'a.ipaddress', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<?php endif;?>
				<th width="7%" class="title d-none d-md-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_NAME', 'u.name', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="7%" class="title d-none d-md-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_USERNAME', 'u.username', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="8%" class="title d-none d-lg-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_EMAIL', 'u.email', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="6%" class="title d-none d-md-table-cell">
					<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_CONSENTS_REGISTRY_CONSENTDATE', 'a.consent_date', @$this->orders['order_Dir'], @$this->orders['order'], 'consents.display' ); ?>
				</th>
				<th width="20%" class="title d-none d-lg-table-cell">
					<?php echo Text::_('COM_GDPR_CONSENTS_REGISTRY_FORMFIELDS'); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="100%">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
			$k = 0;
			for ($i=0, $n=count( $this->items ); $i < $n; $i++) {
				$row = $this->items[$i];
				
				$checked = null;
				// Access check.
				if($this->user->authorise('core.edit')) {
					$checked = HTMLHelper::_('grid.id', $i, $row->id);
				} else {
					$checked = '<input type="checkbox" style="display:none" data-enabled="false" id="cb' . $i . '" name="cid[]" value="' . $row->id . '"/>';
				}
				?>
					<tr>
						<td class="title">
							<?php echo $this->pagination->getRowOffset($i); ?>
						</td>
						<td>
							<?php echo $checked; ?>
						</td>
						<td class="title d-none d-md-table-cell">
							<?php echo $row->url != '*' ? $row->url : Text::_('COM_GDPR_CONSENTS_REGISTRY_URL_ALL_PAGES'); ?>
						</td>
						<td class="title">
							<span class="badge bg-primary"><?php echo $row->formid ? $row->formid : Text::_('COM_GDPR_LOGS_NA'); ?></span>
						</td>
						<td class="title d-none d-md-table-cell">
							<span class="badge bg-warning"><?php echo $row->formname ? $row->formname : Text::_('COM_GDPR_LOGS_NA'); ?></span>
						</td>
						<td class="title">
							<?php echo (int)$row->user_id ? $row->user_id : Text::_('COM_GDPR_LOGS_NA'); ?>
						</td>
						<td class="title d-none d-xl-table-cell">
							<?php echo $row->session_id; ?>
						</td>
						<?php if($this->logUserIpaddress):?>
						<td class="title d-none d-md-table-cell">
							<?php echo $row->ipaddress; ?>
						</td>
						<?php endif;?>
						<td class="title d-none d-md-table-cell">
							<?php echo $row->name ? $row->name : Text::_('COM_GDPR_LOGS_NA'); ?>
						</td>
						<td class="title d-none d-md-table-cell">
							<?php echo $row->username ? $row->username : Text::_('COM_GDPR_LOGS_NA'); ?>
						</td>
						<td class="title d-none d-lg-table-cell">
							<?php echo $row->email ? $row->email : Text::_('COM_GDPR_LOGS_NA'); ?>
						</td>
						<td class="title d-none d-md-table-cell">
							<span class="badge bg-info"><?php echo HTMLHelper::_('date', $row->consent_date, Text::_('COM_GDPR_DATE_FORMAT_FILTER_DATETIME')); ?></span>
						</td>
						<td class="title d-none d-lg-table-cell">
							<?php 
								if($row->formfields) {
									$formFields = json_decode($row->formfields, true);
									if(is_array($formFields) && count($formFields)):?>
										<?php foreach ($formFields as $formFieldName=>$formFieldValue):?>
											( <span style="font-weight:bold"><?php echo ucfirst($formFieldName);?>: </span>
											<?php 
												$cellValue = null;
												switch($formFieldValue){
													case null:
													case '0':
														$cellValue = Text::_('COM_GDPR_LOGS_NA');
														break;
														
													default:
														$cellValue = $formFieldValue;
												}?>
												<span><?php echo $cellValue;?></span> )
											<?php
										endforeach;
									endif;
								} else {
									echo '<span class="badge bg-primary">' . Text::_('COM_GDPR_LOGS_NA') . '</span>';
								}
							?>
						</td>
					</tr>
					<?php
				}
			?>
		</tbody>
	</table>

	<input type="hidden" name="option" value="<?php echo $this->option;?>" />
	<input type="hidden" name="task" value="consents.display" />
	<input type="hidden" name="boxchecked" value="0" /> 
	<input type="hidden" name="filter_order" value="<?php echo $this->orders['order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->orders['order_Dir']; ?>" /> 
</form>