<?php
namespace JExtstore\Component\Gdpr\Administrator\Controller;
/**
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage controllers
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use JExtstore\Component\Gdpr\Administrator\Framework\Controller as GdprController;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Config as HelpersConfig;

/**
 * Controller for cookie descriptions
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage controllers
 * @since 1.4
 */
class CookiedescriptionsController extends GdprController {
	/**
	 * Set model state from session userstate
	 * @access protected
	 * @param string $scope
	 * @return void
	 */
	protected function setModelState($scope = 'default', $ordering = true): object {
		$option = $this->option;
		
		$filter_order = $this->getUserStateFromRequest ( "$option.$scope.filter_order", 'filter_order', 's.category', 'cmd' );
		$filter_order_Dir = $this->getUserStateFromRequest ( "$option.$scope.filter_order_Dir", 'filter_order_Dir', 'asc', 'word' );
		$filter_state = $this->getUserStateFromRequest ( "$option.$scope.filterstate", 'filter_state', '' );
		$category_state = $this->getUserStateFromRequest ( "$option.$scope.categorystate", 'category', '' );
		
		$defaultModel = parent::setModelState ( $scope, false );
		
		// Set model ordering state
		$defaultModel->setState ( 'order', $filter_order );
		$defaultModel->setState ( 'order_dir', $filter_order_Dir );
		$defaultModel->setState ( 'state', $filter_state );
		$defaultModel->setState ( 'category', $category_state );
		
		return $defaultModel;
	}
	
	/**
	 * Default listEntities
	 *
	 * @access public
	 * @param $cachable string
	 *       	 the view output will be cached
	 * @return void
	 */
	public function display($cachable = false, $urlparams = false) {
		// Set model state
		$defaultModel = $this->setModelState('cookiedescriptions');
		
		// Parent construction and view display
		parent::display($cachable);
	}
	
	/**
	 * Export CSV data
	 *
	 * @access public
	 * @return void
	 */
	public function exportConfig() {
		$option = $this->option;
		// Access check
		if (! $this->allowEdit ( $option )) {
			$this->setRedirect ( 'index.php?option=com_gdpr&task=cookiedescriptions.display', Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
		
		// Set model state
		$defaultModel = $this->setModelState('cookiedescriptions');
		
		$viewType = $this->document->getType ();
		$coreName = $this->getName ();
		$viewLayout = $this->app->getInput()->get ( 'layout', 'default' );
		
		$view = $this->getView ( $coreName, $viewType, '', array (
				'base_path' => $this->basePath
		) );
		
		// Push the model into the view (as default)
		$view->setModel ( $defaultModel, true );
		
		// Set the layout
		$view->setLayout ( $viewLayout );
		$view->display ('export');
	}
	
	/**
	 * Import from CSV data
	 *
	 * @access public
	 * @return void
	 */
	public function importConfig() {
		$option = $this->option;
		// Access check
		if (! $this->allowEdit ( $option )) {
			$this->setRedirect ( 'index.php?option=com_gdpr&task=cookiedescriptions.display', Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
		
		// Get the file manager instance with db connector dependency injection
		$filesManager = new HelpersConfig(Factory::getContainer()->get('DatabaseDriver'), $this->app);
		$componentConfig = $this->getModel()->getComponentParams();
		
		if(!$filesManager->importCookieDescriptions($componentConfig)) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$filesManagerException = $filesManager->getError(null, false);
			$this->app->enqueueMessage($filesManagerException->getMessage(), $filesManagerException->getExceptionLevel());
			$this->setRedirect ( "index.php?option=$option&task=cookiedescriptions.display", Text::_('COM_GDPR_ERROR_IMPORT'));
			return false;
		}
		
		$this->setRedirect ( "index.php?option=$option&task=cookiedescriptions.display", Text::_('COM_GDPR_SUCCESS_IMPORT'));
	}
	
	/**
	 * Import from CSV data
	 *
	 * @access public
	 * @return void
	 */
	public function importDefaultConfig() {
		$option = $this->option;
		// Access check
		if (! $this->allowEdit ( $option )) {
			$this->setRedirect ( 'index.php?option=com_gdpr&task=cookiedescriptions.display', Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
		
		// Get the file manager instance with db connector dependency injection
		$filesManager = new HelpersConfig(Factory::getContainer()->get('DatabaseDriver'), $this->app);
		$componentConfig = $this->getModel()->getComponentParams();
		
		if(!$filesManager->importCookieDescriptions($componentConfig, true)) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$filesManagerException = $filesManager->getError(null, false);
			$this->app->enqueueMessage($filesManagerException->getMessage(), $filesManagerException->getExceptionLevel());
			$this->setRedirect ( "index.php?option=$option&task=cookiedescriptions.display", Text::_('COM_GDPR_ERROR_IMPORT'));
			return false;
		}
		
		$this->setRedirect ( "index.php?option=$option&task=cookiedescriptions.display", Text::_('COM_GDPR_SUCCESS_IMPORT'));
	}
	
	/**
	 *
	 * Class Constructor
	 *
	 * @access public
	 * @param $config
	 * @return Object&
	 */
	public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null) {
		parent::__construct($config, $factory, $app, $input);
		
		// Register Extra tasks
		$this->registerTask ( 'applyEntity', 'saveEntity' );
		$this->registerTask ( 'unpublish', 'publishEntities' );
		$this->registerTask ( 'publish', 'publishEntities' );
	}
}