<?php
/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5.x
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.0.1.0-PRO - 2024-01-29
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\{Container, ServiceProviderInterface};
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Extension\EasyJoomlaBackupComponent;

/**
 * The config service provider
 *
 * @since 5.0.0.0-PRO
 */
return new class implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container
     *
     * @param Container $container
     *
     * @since 5.0.0.0-PRO
     */
    public function register(Container $container): void
    {
        $container->registerServiceProvider(new CategoryFactory('\\KubikRubik\\Component\\EasyJoomlaBackup'));
        $container->registerServiceProvider(new MVCFactory('\\KubikRubik\\Component\\EasyJoomlaBackup'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\KubikRubik\\Component\\EasyJoomlaBackup'));
        $container->registerServiceProvider(new RouterFactory('\\KubikRubik\\Component\\EasyJoomlaBackup'));

        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new EasyJoomlaBackupComponent($container->get(ComponentDispatcherFactoryInterface::class));

                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                $component->setRouterFactory($container->get(RouterFactoryInterface::class));

                return $component;
            }
        );
    }
};
