<?php 
/**
 * =======================================================
 * Cookies Policy Notification Bar - Joomla! Plugin v3.4.0 - 21-May-2018
 * =======================================================
 * For Joomla! 3.x
 * Author: Yiannis Christodoulou (yiannis@web357.eu)
 * Copyright (C) 2009-2018 Web357. All rights reserved.
 * Website: https://www.web357.eu/
 * Extension's page: https://www.web357.eu/joomla-extensions/cookies-policy-notification-bar
 * Demo: https://demo.web357.eu/joomla/cookies-policy-notification-bar
 * Support: support@web357.eu
 * Last modified: Monday, May 21st, 2018, 10:37:59 AM
*/

defined('_JEXEC') or die;

class plgInstallerCookiespolicynotificationbar extends JPlugin
{
    // Web357 Framework Helper Class
	public static function W357FrameworkHelperClass()
	{
		// Call the Web357 Framework Helper Class
		require_once(JPATH_PLUGINS.DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'web357framework'.DIRECTORY_SEPARATOR.'web357framework.class.php');
		$w357frmwrk = new Web357FrameworkHelperClass;
		return $w357frmwrk;
	}
    
    public function onInstallerBeforePackageDownload(&$url, &$headers)
    {
        if (parse_url($url, PHP_URL_HOST) == 'downloads.web357.eu') {

            if ($apikey = $this->W357FrameworkHelperClass()->apikey) {

                $current_url = JURI::getInstance()->toString();
                $parse = parse_url($current_url);
                $domain = isset($parse['host']) ? $parse['host'] : 'domain.com';
        		$uri = JUri::getInstance($url);
                $uri->setVar('liveupdate', 'true');
                $uri->setVar('domain', $domain);
                $uri->setVar('dlid', $apikey);
                $url = $uri->toString();

            } else {

                // load default and current language
                $jlang = JFactory::getLanguage();
                $jlang->load('plg_system_web357framework', JPATH_ADMINISTRATOR, 'en-GB', true);
                $jlang->load('plg_system_web357framework', JPATH_ADMINISTRATOR, null, true);

                // warn about missing api key
                JFactory::getApplication()->enqueueMessage(JText::_('W357FRM_APIKEY_WARNING'), 'notice');
            }

        }

        return true;
    }

}