﻿<?php 

/**
 * @ author Jose A. Luque
 * @ Copyright (c) 2011 - Jose A. Luque
 *
 * @license GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */

// Protect from unauthorized access
defined('_JEXEC') or die('Restricted access');
JSession::checkToken('get') or die('Invalid Token');

$kind_array = array(JHtml::_('select.option', JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FILE'), JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FILE')),
    JHtml::_('select.option', JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FOLDER'), JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_TITLE_FOLDER')));
            
$status_array = array(JHtml::_('select.option', '0', JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_TITLE_SUSPICIOUS')),
    JHtml::_('select.option', '2', JText::_('COM_SECURITYCHECKPRO_FILEINTEGRITY_IN_EXCEPTIONS_LIST')),
    JHtml::_('select.option', '3', JText::_('COM_SECURITYCHECKPRO_FILEINTEGRITY_QUARANTINED')));

// Cargamos los archivos javascript necesarios
$document = JFactory::getDocument();
if ( version_compare(JVERSION, '3.20', 'lt') )
{	
	$document->addScript(JURI::root().'media/system/js/core.js');
}

// styles ('data-xxx' for J3 and 'data-bs-xxxx' for J4)
$data_dismiss = "data-dismiss";
$list_group_style = 'class="margin-right-5" style="width: fit-content;"';

if (version_compare(JVERSION, '4.0', 'ge')) {	
	$data_dismiss = "data-bs-dismiss";
	$list_group_style = 'style="width: fit-content;"';
}

$document->addScript(JURI::root().'media/com_securitycheckpro/new/js/sweetalert.min.js');
// Bootstrap core JavaScript
// Inline javascript to avoid deferring in Joomla 4
echo '<script src="' . JURI::root(). '/media/com_securitycheckpro/new/vendor/popper/popper.min.js"></script>';
//$document->addScript(JURI::root().'media/com_securitycheckpro/new/vendor/popper/popper.min.js');

// Add style declaration
$media_url = "media/com_securitycheckpro/stylesheets/cpanelui.css";
JHTML::stylesheet($media_url);

$opa_icons = "media/com_securitycheckpro/stylesheets/opa-icons.css";
JHTML::stylesheet($opa_icons);

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

$sweet = "media/com_securitycheckpro/stylesheets/sweetalert.css";
JHTML::stylesheet($sweet);

?>

<?php 
// Cargamos el contenido común...
require JPATH_ADMINISTRATOR.'/components/com_securitycheckpro/helpers/common.php';

// ... y el contenido específico
require JPATH_ADMINISTRATOR.'/components/com_securitycheckpro/helpers/malwarescan.php';
?>

<?php
if (empty($this->last_check_malwarescan) ) {
    $this->last_check_malwarescan = JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER');
}
if (empty($this->files_status) ) {
    $this->files_status = JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_NOT_DEFINED');
}
?>

<form action="<?php echo JRoute::_('index.php?option=com_securitycheckpro&controller=filemanager&view=malwarescan&'. JSession::getFormToken() .'=1');?>" method="post" class="margin-left-10 margin-right-10" name="adminForm" id="adminForm">

    <!-- Modal view file -->
        <div class="modal" id="view_file" tabindex="-1" role="dialog" aria-labelledby="viewfileLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header alert alert-info">
                <h2 class="modal-title" id="viewfileLabel"><?php echo JText::_('COM_SECURITYCHECKPRO_FILE_CONTENT'); ?></h2>
                <button type="button" class="close" <?php echo $data_dismiss; ?>="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">    
                <textarea rows="10" class="table">        
                <?php 
                $mainframe = JFactory::getApplication();
                $contenido = $mainframe->getUserState('contenido', "vacio");
                echo $contenido;
                ?></textarea>    
              </div>
                <div class="modal-footer">                    
                    <button type="button" class="btn btn-default" <?php echo $data_dismiss; ?>="modal"><?php echo JText::_('COM_SECURITYCHECKPRO_CLOSE'); ?></button>
                </div>              
            </div>
          </div>
        </div>

<?php 
        // Cargamos la navegación
        require JPATH_ADMINISTRATOR.'/components/com_securitycheckpro/helpers/navigation.php';		
?>
                
          
            <!-- Contenido principal -->            
            <div class="row">
                
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
        <?php echo JText::_('COM_SECURITYCHECKPRO_DEEP_SCAN_STATUS'); ?>
                        </div>
                        <div class="card-body">                
                            <span class="sc-icon32 sc-icon-green sc-icon-search"></span>
                            <div>
                                <span class="label label-info"><?php echo $this->deep_scan_status; ?></span>                        
                            </div>                        
                            <div class="margin-top-10">
                                <span id="more_info_deep_scan" data-toggle="tooltip" title="<?php echo JText::_('COM_SECURITYCHECKPRO_DEEP_SCAN_CONTENT'); ?>" class="badge badge-dark"><?php echo JText::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
        <?php echo JText::_('COM_SECURITYCHECKPRO_CONFIG_ONLINE_SUBMISSION_TYPE_LABEL'); ?>
                        </div>
                        <div class="card-body">                
                            <span class="sc-icon32 sc-icon-red sc-icon-sent"></span>
                            <div>
                                <span class="label label-info"><?php echo $this->online_submission_type; ?></span>                                            
                            </div>
                            <div class="margin-top-10">
                                <span id="more_info_deep_scan" data-toggle="tooltip" title="<?php echo JText::_('COM_SECURITYCHECKPRO_SUBMISSION_TYPE_CONTENT'); ?>" class="badge badge-dark"><?php echo JText::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
                <div class="col-xl-3 col-sm-6 mb-3">
                    <div class="card text-center">
                        <div class="card-header">
        <?php echo JText::_('COM_SECURITYCHECKPRO_CONFIG_TIMELINE_LABEL'); ?>
                        </div>
                        <div class="card-body">                
                            <span class="sc-icon32 sc-icon-blue sc-icon-date"></span>
                            <div>
                                <span class="label label-info">
                                <?php 
                                if ($this->timeline == 1 ) {
                                    echo JText::_('COM_SECURITYCHECKPRO_YESTERDAY');
                                } else if ($this->timeline == 7 ) {
                                    echo JText::_('COM_SECURITYCHECKPRO_A_WEEK_AGO');
                                } else if ($this->timeline == 30 ) {
                                    echo JText::_('COM_SECURITYCHECKPRO_A_MONTH_AGO');
                                } else if ($this->timeline == 10000 ) {
                                    echo JText::_('COM_SECURITYCHECKPRO_ANYTIME');
                                }
                                ?>
                                </span>                        
                            </div>                        
                            <div class="margin-top-10">
                                <span id="more_info_deep_scan" data-toggle="tooltip" title="<?php echo JText::_('COM_SECURITYCHECKPRO_CONFIG_TIMELINE_DESCRIPTION'); ?>" class="badge badge-dark"><?php echo JText::_('COM_SECURITYCHECKPRO_MORE_INFO'); ?></span>
                            </div>
                        </div>
                    </div>                            
                </div>
            
                <div class="col-xl-5 col-sm-5 mb-5" class="margin-bottom-3rem">
                    <div class="card text-center">    
                        <div class="card-header">
        <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_STATUS'); ?>                            
                        </div>
                        <div class="row card-body" class="justify-content-center">                                
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item active" class="font-size-13"><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_STARTTIME'); ?></li>
                                    <li class="list-group-item"><span id="start_time" class="badge badge-dark"><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER'); ?></span></li>
                                </ul>
                            </div>                            
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item active" class="font-size-13"><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_CHECK_TASK'); ?></li>
                                    <li class="list-group-item">
                                        <span id="task_status" class="badge badge-info"><?php echo $this->files_status; ?></span>
                                        <span id="task_error" class="badge badge-danger none">Error</span>
                                    </li>
                                </ul>
                            </div>                                                    
                        </div>                        
                        <div id="button_start_scan" class="card-footer">
                            <button class="btn btn-primary" id="start_scan_button" type="button"><i class="fapro fa-fw fa-fire"></i><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_START_BUTTON'); ?></button>
                        </div>                        
                    </div>
                </div>
                
                <div class="col-xl-7 col-sm-7 mb-7">
                    <div class="card text-center">    
                        <div class="card-header">
        <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_RESULT_HEADER'); ?>
                        </div>
                        <div class="row card-body" class="justify-content-center">
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_LAST_CHECK'); ?></li>
                                    <li class="list-group-item"><span class="badge badge-dark"><?php echo $this->last_check_malwarescan; ?></span></li>
                                </ul>
                            </div>
							<div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo JText::_('COM_SECURITYCHECKPRO_TIME_TAKEN'); ?></li>
                                    <li class="list-group-item"><span class="badge badge-dark"><?php echo $this->time_taken; ?></span></li>
                                </ul>
                            </div>
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success"><?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_FILES_SCANNED'); ?></li>
                                    <li class="list-group-item"><span class="badge badge-dark"><?php echo $this->files_scanned_malwarescan; ?></span></li>
                                </ul>                                
                            </div>
                            <div <?php echo $list_group_style; ?>>
                                <ul class="list-group text-center">
                                    <li class="list-group-item text-white bg-success" class="font-size-13"><?php echo JText::_('COM_SECURITYCHECKPRO_SUSPICIOUS_FILES'); ?></li>
                                    <li class="list-group-item">
            <?php
            if ($this->suspicious_files > 0 ) {
                ?>        
                                        <span class="badge badge-danger">
            <?php } else {    ?>
                                        <span class="badge badge-success">
            <?php	}    ?>
            <?php echo $this->suspicious_files; ?></span>
                                    </li>
                                </ul>
                            </div>                        
                        </div>
                        <div id="button_show_log" class="card-footer">    
        <?php	                            
        if (!empty($this->log_filename) ) { ?>
                                    <button class="btn btn-success" id="view_modal_log_button" type="button"><i class="fapro fa-fw fa-eye"></i><?php echo substr(JText::_('COM_SECURITYCHECKPRO_ACTION_VIEWLOGS'), 0, -1); ?></button>
        <?php }    ?>                            
                        </div>                            
                    </div>                    
                </div>
                
                 <div id="scandata" class="col-lg-12 margin-top-20">
                    <div class="card mb-3">                        
                        <div class="card-body" class="margin-left-10">
                            <div id="container_repair">
                                <div id="log-container_remember_text" class="centrado margen texto_14">
                                </div>
                                <div id="div_view_log_button" class="buttonwrapper">    
                                </div>                            
                                <div id="log-container_header" class="centrado margen texto_20">    
                                </div>
                            </div>
                            
                            <div id="error_message_container" class="securitycheck-bootstrap centrado margen-container">
                                <div id="error_message">
                                </div>    
                            </div>

                            <div id="error_button" class="securitycheck-bootstrap centrado margen-container">    
                            </div>
                            
                            <div id="memory_limit_message" class="securitycheck-bootstrap centrado margen-loading texto_14">
                                <?php 
                                    // Extract 'memory_limit' value cutting the last character
                                    $memory_limit = ini_get('memory_limit');
                                    $memory_limit = (int) substr($memory_limit, 0, -1);
                                            
                                    // If $memory_limit value is less or equal than 128, shows a warning if no previous scans have finished
                                if (($memory_limit <= 128) && ($this->last_check_malwarescan == JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_NEVER')) ) {
                                    $span = "<span class=\"label label-warning\">";
                                    echo $span . JText::_('COM_SECURITYCHECKPRO_MEMORY_LIMIT_LOW') . "</span>";
                                }
                                ?>
                            </div>

                            <div id="completed_message2" class="centrado margen-loading color_verde">    
                            </div>
                                                        
                            <div id="warning_message2" class="centrado margen-loading">                                
                            </div>
                                                                            
                            <div id="backup-progress" class="progress" class="margin-bottom-20">
                                <div id="bar" class="progress-bar bg-success" role="progressbar" class="width-0" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>    
                            
                            <div class="alert alert-warning">
                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARE_FOUND_RECOMMENDATION'); ?>
                            </div>
                            
                        <div id="container_resultado">
                            <div id="filter-bar" class="btn-toolbar margin-bottom-20">
                                <div class="filter-search btn-group pull-left">
                                    <input type="text" name="filter_malwarescan_search" placeholder="<?php echo JText::_('JSEARCH_FILTER_LABEL'); ?>" id="filter_malwarescan_search" value="<?php echo $this->escape($this->state->get('filter.malwarescan_search')); ?>" title="<?php echo JText::_('JSEARCH_FILTER'); ?>" />
                                </div>
                                <div class="btn-group pull-left" class="margin-left-10">
                                    <button class="btn tip" type="submit" rel="tooltip" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                                    <button class="btn tip" type="button" id="search_filter_button" rel="tooltip" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>"><i class="icon-remove"></i></button>
                                </div>
                                
                                <div class="btn-group pull-left" class="margin-left-10">
                                    <select name="filter_malwarescan_status" class="custom-select" onchange="this.form.submit()">
                                        <option value=""><?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_STATUS_DESCRIPTION');?></option>
            <?php echo JHtml::_('select.options', $status_array, 'value', 'text', $this->state->get('filter.malwarescan_status'));?>
                                    </select>                
                                </div>    
                            </div>
               	 
        <?php if (!$this->items == null) { ?>
            <?php if (($this->online_submission_type == "Hashes") && ($this->online_checked_hashes >= 1000) ) { ?>
                            <div class="alert alert-danger">
                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_HASHES_ALERT'); ?>
                            </div>
            <?php } else if (($this->online_submission_type == "Files") && ($this->online_checked_files >= 25) ) { ?>
                            <div class="alert alert-danger">
                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_FILES_ALERT'); ?>
                            </div>                
            <?php } ?>
                            
            <?php if (empty($this->opswat_key) ) { ?>
                            <div class="alert alert-danger">
                <?php echo JText::_('COM_SECURITYCHECKPRO_NO_API_KEY_ALERT'); ?>
                            </div>
            <?php } ?>
                            
            <?php if ($this->database_error == "DATABASE_ERROR" ) { ?>
                            <div class="alert alert-danger">
                <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_DATABASE_ERROR'); ?>
                            </div>                            
            <?php } ?>

            <?php if ($this->show_all == 1 ) { ?>
                            <div class="alert alert-info">
                <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_INFO'); ?>
                            </div>                            
            <?php } ?>
			
			                                                       
            <?php
            if ((!empty($this->items)) && (!$this->state->get('filter.malwarescan_status')) ) {            
                ?>
                                <div id="permissions_buttons">
                                    <div class="pull-right" class="margin-bottom-10">
                                        <button class="btn btn-success" id="addfile_exception_button" class="margin-right-5" href="#">
                                            <i class="fapro fa-fw fa-plus"> </i>
                <?php echo JText::_('COM_SECURITYCHECKPRO_ADD_AS_EXCEPTION'); ?>
                                        </button>                                        
                                    
                <?php	
                if (!empty($this->opswat_key) ) { 
                    if (($this->online_submission_type == "Files") && ($this->online_checked_files < 25) ) { ?>
                                        <button type="button" id="online_check_files_button" data-loading-text="<?php echo JText::_('COM_SECURITYCHECKPRO_SENDING_FILES'); ?>" class="btn btn-primary" href="#">
                                            <i class="icon-upload icon-white"> </i>
                        <?php echo JText::_('COM_SECURITYCHECKPRO_SCAN_FILES'); ?>
                                        </button>
                    <?php } else if (($this->online_submission_type == "Hashes") && ($this->online_checked_hashes < 1000) ) { ?>
                                        <button type="button" id="online_check_hashes_button" data-loading-text="<?php echo JText::_('COM_SECURITYCHECKPRO_SENDING_HASHES'); ?>" class="btn btn-primary"  href="#">                        
                                            <i class="icon-upload icon-white"> </i>
                        <?php echo JText::_('COM_SECURITYCHECKPRO_SCAN_HASHES'); ?>
                                        </button>
                    <?php }                 
                } ?>
                <?php
            } else if ($this->state->get('filter.malwarescan_status') == 2 ) { ?>
                                    <div id="permissions_buttons">
                                        <div class="btn-group pull-right" class="margin-bottom-10">
                                            <button class="btn btn-danger" id="deletefile_exception_button" href="#">
                                                <i class="icon-trash icon-white"> </i>
                <?php echo JText::_('COM_SECURITYCHECKPRO_DELETE_EXCEPTION'); ?>
                                            </button>                                        
                <?php                  
            } else if ($this->state->get('filter.malwarescan_status') == 3 ) { ?>

                                    <button class="btn btn-info" id="restore_quarantined_file_button" href="#">
                                        <i class="icon-undo icon-white"> </i>
                <?php echo JText::_('COM_SECURITYCHECKPRO_RESTORE_QUARANTINED_FILE'); ?>
                                    </button>
                                    
                                    <button class="btn btn-danger" id="delete_quarantined_file_button" href="#">
                                        <i class="icon-trash icon-white"> </i>
                <?php echo JText::_('COM_SECURITYCHECKPRO_DELETE'); ?>
                                    </button>
                                        
            <?php } ?>    
                                    <!-- Permissions_buttons close divs -->
                                    </div>
                                </div>

                                <div>
                                    <span class="badge background-FF9EB4 padding-10-10-10-10"><?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_RESULTS');?></span>
                                </div>
                                <div class="table-responsive overflow-x-auto margin-top-20">
                                    <table id="malwarescan_status_table" class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
											<?php 
												if ($this->checkbox_position == 1) {
											?>
											<th class="malwarescan-table">
                                                <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
                                            </th> 
											<?php 
												}
											?> 
                                            <th class="malwarescan-table" class="malwarescan-table-info2">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_NAME'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_TAMANNO'); ?>                
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_FILEMANAGER_LAST_MODIFIED'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_TYPE'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_DESCRIPTION'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_CODE_DESCRIPTION'); ?>
                                            </th>
                                            <th class="malwarescan-table">
                                                <?php echo JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_ONLINE_CHECK'); ?>
                                            </th>
											<?php 
												if ($this->checkbox_position == 0) {
											?>
											<th class="malwarescan-table">
                                                <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
                                            </th> 
											<?php 
												}
											?>                                            
                                        </tr>
                                    </thead>
            <?php			
            $k = 0;			
            if (!empty($this->items) ) {    
                foreach ($this->items as &$row) {
                    $safe_malwarescan = $row['safe_malwarescan'];
                    ?>
					<?php 
					if ($this->checkbox_position == 1) {
						echo '<td class="centrado">' . JHtml::_('grid.id', $k, $row['path'], '', 'malwarescan_status_table') . '</td>'; 
					}
					?>
                    <td class="centrado malwarescan-table-info">
                    <?php echo htmlspecialchars($row['path']); ?>
                    <br/>
                    <?php 
                    if ($row['moved_to_quarantine'] == 1) {
                        $span = "<span class=\"badge badge-info\">";
                        echo $span . JText::_('COM_SECURITYCHECKPRO_MOVED_TO_QUARANTINE') . "</span>";
                    }

                    ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['size']); ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['last_modified']); ?>
                    </td>
                    <td class="centrado">
                    <?php echo htmlspecialchars($row['malware_type']); ?>
                    </td>
                    <td class="centrado">
                    <?php
                    switch ($row['malware_alert_level']) {
                    case '0':
                        $span = "<span class=\"badge badge-important\">";
                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_0') . "</span>";                            
                        break;
                    case '1':
                        $span = "<span class=\"badge badge-warning\">";
                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_1') . "</span>";
                        break;
                    case '2':
                         $span = "<span class=\"badge\">";
                         echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_ALERT_LEVEL_2') . "</span>";
                        break;
                    } ?>
                    </td>
                    <td class="centrado">
                        <textarea cols="30" rows="1" readonly><?php echo str_replace('<br />', PHP_EOL, htmlspecialchars($row['malware_description'])); ?></textarea>        
                    </td>
                    <td class="centrado">
                        <textarea cols="30" rows="1" readonly><?php echo str_replace('<br />', PHP_EOL, htmlspecialchars($row['malware_code'])); ?></textarea>        
                    </td>
                    <td class="centrado">
                    <?php 
                    switch ($row['online_check']) {
                    case 0:
                        $span = "<span class=\"badge badge-success\">";
                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_CLEAN') . "</span>";
                        break;
                    case 1:
                        $span = "<span class=\"badge badge-important\">";
                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_INFECTED') . "</span>";                            
                        break;
                    case 2:
                                                        $span = "<span class=\"badge badge-warning\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SUSPICIOUS') . "</span>";
                        break;
                    case 3:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_FAILED_TO_SCAN') . "</span>";
                        break;
                    case 4:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_CLEANED') . "</span>";
                        break;
                    case 5:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_UNKNOW') . "</span>";
                        break;
                    case 6:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_QUARANTINED') . "</span>";
                        break;
                    case 7:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SKIPPED_CLEAN') . "</span>";
                        break;
                    case 8:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_SKIPPED_DIRTY') . "</span>";
                        break;
                    case 9:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_DEPTH') . "</span>";
                        break;
                    case 10:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_NOT_SCANNED') . "</span>";
                        break;
                    case 11:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_ABORTED') . "</span>";
                        break;
                    case 12:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_ENCRYPTED') . "</span>";
                        break;
                    case 13:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_SIZE') . "</span>";
                        break;
                    case 14:
                                                        $span = "<span class=\"badge\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_EXCEEDED_FILE_NUMBER') . "</span>";
                        break;
                    case 15:
                                                        $span = "<span class=\"badge badge-inverse\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_HASH_NOT_FOUND') . "</span>";
                        break;
                    default:
                                                        $span = "<span class=\"badge badge-info\">";
                                                        echo $span . JText::_('COM_SECURITYCHECKPRO_MALWARESCAN_SCAN_RESULTS_NOT_CHECKED') . "</span>";
                    }
                    ?>
                                        </td>
                    <?php 
					if ($this->checkbox_position == 0) {
						echo '<td class="centrado">' . JHtml::_('grid.id', $k, $row['path'], '', 'malwarescan_status_table') . '</td>'; 
					}
					?>
                    </tr>
                    <?php
                    $k = $k+1;
                }
            }

			?>
                                    </table>
                                    </div>

            <?php
            if (!empty($this->items) ) {        
                ?>
                                    <div class="margen">
                                        <div>
                <?php echo $this->pagination->getListFooter(); echo $this->pagination->getLimitBox(); ?>
                                        </div>
                                    </div>
            <?php } ?>    
                                </div>
        <?php } else {
			if ($this->state->get('filter.malwarescan_status') == 2 ) {
				if ($this->file_manager_include_exceptions_in_database == 0 ) { 
					echo '<div class="alert alert-info">' . JText::_('COM_SECURITYCHECKPRO_EXCEPTIONS_NOT_INCLUDED_IN_DATABASE'). '</div>';                            
				} 
			}
		} ?>
                    </div>        
                </div>
            </div>
            
        </div>
</div>        

<input type="hidden" name="controller" value="filemanager" />
<input type="hidden" name="boxchecked" value="1" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="table" value="malwarescan" />
</form>
