<?php 
/** 
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage cookiedescriptions
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

$delimiter = $this->componentConfig->get('csv_delimiter', ';');
$enclosure = $this->componentConfig->get('csv_enclosure', '"');

// Clean dirty buffer
ob_end_clean();
// Open buffer
ob_start();
// Open out stream
$outstream = fopen("php://output", "w");
// Funzione di scrittura nell'output stream
function __gdproutputCSV(&$vals, $index, $userData) {
	// Translate published status field
	$cookiedescriptionsArray = (array)$vals;
	unset($cookiedescriptionsArray['id']);
	unset($cookiedescriptionsArray['checked_out']);
	unset($cookiedescriptionsArray['checked_out_time']);
	
	fputcsv($userData[0], $cookiedescriptionsArray, $userData[1], $userData[2]);
}

// Echo delle intestazioni
fputcsv ( $outstream, array (
		JText::_ ( 'COM_GDPR_COOKIEDESCRIPTIONS_COOKIE' ),
		JText::_ ( 'COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY' ),
		JText::_ ( 'COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML' ),
		JText::_ ( 'COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION' ),
		JText::_ ( 'COM_GDPR_PUBLISHED' )
), $delimiter, $enclosure );

// Output di tutti i records
array_walk($this->items, "__gdproutputCSV", array($outstream, $delimiter, $enclosure));
fclose($outstream);

// Recupero output buffer content
$contents = ob_get_clean();
$size = strlen($contents);

header ( 'Pragma: public' );
header ( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
header ( 'Expires: ' . gmdate ( 'D, d M Y H:i:s' ) . ' GMT' );
header ( 'Content-Disposition: attachment; filename="cookie_descriptions_pg' . $this->pagination->pagesCurrent . '.csv"' );
header ( 'Content-Type: text/plain' );
header ( "Content-Length: " . $size );
echo $contents;
	
exit ();