<?php 
/** 
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage links
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
if (!class_exists('JEditor')) {
	$editor = JFactory::getEditor();
} else {
	$config = JFactory::getConfig();
	$editor = JEditor::getInstance($config->get('editor'));
}
?>
<form action="index.php" method="post" name="adminForm" id="adminForm"> 
	<div class="accordion-group">
		<div class="accordion-heading opened">
			<div class="accordion-toggle noaccordion">
				<h4><span class="icon-pencil"></span><?php echo JText::_( 'COM_GDPR_COOKIEDESCRIPTION_DETAILS' ); ?></h4>
			</div>
		</div>
		<div id="details" class="accordion-body collapse in">
	      	<div class="accordion-inner">
				<table class="admintable">
					<tbody>
						<tr>
							<td class="key left_title">
								<label for="name" class="hasPopover" data-content="<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_COOKIE_DESC' ); ?>">
									<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_COOKIE' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<input class="inputbox-large" type="text" id="cookie" name="cookie" data-validation="required" value="<?php echo $this->record->cookie;?>" />
							</td>
						</tr>
						
						<tr>
							<td class="key left_title">
								<label for="name" class="hasPopover" data-content="<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY_DESC' ); ?>">
									<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<?php echo $this->lists['categories'];?>
							</td>
						</tr>
						
						<tr>
							<td class="key left_title">
								<label for="description" class="hasPopover" data-content="<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML_DESC' ); ?>">
									<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<?php echo $editor->display('descriptionhtml', $this->record->descriptionhtml, '600px', '400px', '70', '15', true); ?>
							</td>
						</tr>

						<tr>
							<td class="key left_title">
								<label for="description" class="hasPopover" data-content="<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION_DESC' ); ?>">
									<?php echo JText::_('COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<input type="text" class="inputbox-large" id="cookie" name="expiration" value="<?php echo $this->record->expiration;?>" />
							</td>
						</tr>

						<tr>
							<td class="key left_title">
								<label>
									<?php echo JText::_('COM_GDPR_PUBLISHED' ); ?>:
								</label>
							</td>
							<td class="right_details">
								<fieldset class="radio btn-group">
									<?php echo $this->lists['published']; ?>
								</fieldset>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>		
	
	<div class="clr"></div>
 
	<input type="hidden" name="option" value="<?php echo $this->option;?>" /> 
	<input type="hidden" name="id" value="<?php echo $this->record->id; ?>" />
	<input type="hidden" name="task" value="" /> 
</form>